<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Primary_Buttons_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Enter a Hex number with a length of 3 or 6 characters ranging between: 0-9, a-f, A-F. | Element container for the primary buttons of brand.
 * @subpackage Structs
 */
class Primary_Buttons_DataType extends AbstractStructBase
{
    /**
     * The Color
     * Meta information extracted from the WSDL
     * - documentation: Primary color for primary buttons of brand.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Color;
    /**
     * The Border_Color
     * Meta information extracted from the WSDL
     * - documentation: Secondary color for primary buttons of brand.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Border_Color;
    /**
     * The Text_Color
     * Meta information extracted from the WSDL
     * - documentation: Text color for primary buttons of brand.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Text_Color;
    /**
     * The Hover_Color
     * Meta information extracted from the WSDL
     * - documentation: Interactive primary color for primary buttons of brand.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Hover_Color;
    /**
     * The Hover_Border_Color
     * Meta information extracted from the WSDL
     * - documentation: Interactive secondary color for primary buttons of brand.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Hover_Border_Color;
    /**
     * The Hover_Text_Color
     * Meta information extracted from the WSDL
     * - documentation: Interactive text color for primary buttons of brand.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Hover_Text_Color;
    /**
     * Constructor method for Primary_Buttons_DataType
     * @uses Primary_Buttons_DataType::setColor()
     * @uses Primary_Buttons_DataType::setBorder_Color()
     * @uses Primary_Buttons_DataType::setText_Color()
     * @uses Primary_Buttons_DataType::setHover_Color()
     * @uses Primary_Buttons_DataType::setHover_Border_Color()
     * @uses Primary_Buttons_DataType::setHover_Text_Color()
     * @param string $color
     * @param string $border_Color
     * @param string $text_Color
     * @param string $hover_Color
     * @param string $hover_Border_Color
     * @param string $hover_Text_Color
     */
    public function __construct($color = null, $border_Color = null, $text_Color = null, $hover_Color = null, $hover_Border_Color = null, $hover_Text_Color = null)
    {
        $this
            ->setColor($color)
            ->setBorder_Color($border_Color)
            ->setText_Color($text_Color)
            ->setHover_Color($hover_Color)
            ->setHover_Border_Color($hover_Border_Color)
            ->setHover_Text_Color($hover_Text_Color);
    }
    /**
     * Get Color value
     * @return string|null
     */
    public function getColor()
    {
        return $this->Color;
    }
    /**
     * Set Color value
     * @param string $color
     * @return \StructType\Primary_Buttons_DataType
     */
    public function setColor($color = null)
    {
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color, true), gettype($color)), __LINE__);
        }
        $this->Color = $color;
        return $this;
    }
    /**
     * Get Border_Color value
     * @return string|null
     */
    public function getBorder_Color()
    {
        return $this->Border_Color;
    }
    /**
     * Set Border_Color value
     * @param string $border_Color
     * @return \StructType\Primary_Buttons_DataType
     */
    public function setBorder_Color($border_Color = null)
    {
        // validation for constraint: string
        if (!is_null($border_Color) && !is_string($border_Color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($border_Color, true), gettype($border_Color)), __LINE__);
        }
        $this->Border_Color = $border_Color;
        return $this;
    }
    /**
     * Get Text_Color value
     * @return string|null
     */
    public function getText_Color()
    {
        return $this->Text_Color;
    }
    /**
     * Set Text_Color value
     * @param string $text_Color
     * @return \StructType\Primary_Buttons_DataType
     */
    public function setText_Color($text_Color = null)
    {
        // validation for constraint: string
        if (!is_null($text_Color) && !is_string($text_Color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text_Color, true), gettype($text_Color)), __LINE__);
        }
        $this->Text_Color = $text_Color;
        return $this;
    }
    /**
     * Get Hover_Color value
     * @return string|null
     */
    public function getHover_Color()
    {
        return $this->Hover_Color;
    }
    /**
     * Set Hover_Color value
     * @param string $hover_Color
     * @return \StructType\Primary_Buttons_DataType
     */
    public function setHover_Color($hover_Color = null)
    {
        // validation for constraint: string
        if (!is_null($hover_Color) && !is_string($hover_Color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hover_Color, true), gettype($hover_Color)), __LINE__);
        }
        $this->Hover_Color = $hover_Color;
        return $this;
    }
    /**
     * Get Hover_Border_Color value
     * @return string|null
     */
    public function getHover_Border_Color()
    {
        return $this->Hover_Border_Color;
    }
    /**
     * Set Hover_Border_Color value
     * @param string $hover_Border_Color
     * @return \StructType\Primary_Buttons_DataType
     */
    public function setHover_Border_Color($hover_Border_Color = null)
    {
        // validation for constraint: string
        if (!is_null($hover_Border_Color) && !is_string($hover_Border_Color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hover_Border_Color, true), gettype($hover_Border_Color)), __LINE__);
        }
        $this->Hover_Border_Color = $hover_Border_Color;
        return $this;
    }
    /**
     * Get Hover_Text_Color value
     * @return string|null
     */
    public function getHover_Text_Color()
    {
        return $this->Hover_Text_Color;
    }
    /**
     * Set Hover_Text_Color value
     * @param string $hover_Text_Color
     * @return \StructType\Primary_Buttons_DataType
     */
    public function setHover_Text_Color($hover_Text_Color = null)
    {
        // validation for constraint: string
        if (!is_null($hover_Text_Color) && !is_string($hover_Text_Color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hover_Text_Color, true), gettype($hover_Text_Color)), __LINE__);
        }
        $this->Hover_Text_Color = $hover_Text_Color;
        return $this;
    }
}
