<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pre-Hire_Probation_Period_Length_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains details associated with the length of the Pre-Hire Probation Period.
 * @subpackage Structs
 */
class Pre_Hire_Probation_Period_Length_DataType extends AbstractStructBase
{
    /**
     * The Pre_Hire_Probation_Period_Duration_Reference
     * Meta information extracted from the WSDL
     * - documentation: The duration of the Pre-Hire Probation Period.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 3
     * @var float
     */
    public $Pre_Hire_Probation_Period_Duration_Reference;
    /**
     * The Pre_Hire_Probation_Period_Unit_Reference
     * Meta information extracted from the WSDL
     * - documentation: The unit of time used to measure the duration of the Pre-Hire Probation Period.
     * @var \StructType\Pre_Hire_Probation_Period_UnitObjectType
     */
    public $Pre_Hire_Probation_Period_Unit_Reference;
    /**
     * The Pre_Hire_Probation_Review
     * Meta information extracted from the WSDL
     * - documentation: Probation Period Review Length
     * - minOccurs: 0
     * @var \StructType\Pre_Hire_Probation_Review_DataType
     */
    public $Pre_Hire_Probation_Review;
    /**
     * Constructor method for Pre-Hire_Probation_Period_Length_DataType
     * @uses Pre_Hire_Probation_Period_Length_DataType::setPre_Hire_Probation_Period_Duration_Reference()
     * @uses Pre_Hire_Probation_Period_Length_DataType::setPre_Hire_Probation_Period_Unit_Reference()
     * @uses Pre_Hire_Probation_Period_Length_DataType::setPre_Hire_Probation_Review()
     * @param float $pre_Hire_Probation_Period_Duration_Reference
     * @param \StructType\Pre_Hire_Probation_Period_UnitObjectType $pre_Hire_Probation_Period_Unit_Reference
     * @param \StructType\Pre_Hire_Probation_Review_DataType $pre_Hire_Probation_Review
     */
    public function __construct($pre_Hire_Probation_Period_Duration_Reference = null, \StructType\Pre_Hire_Probation_Period_UnitObjectType $pre_Hire_Probation_Period_Unit_Reference = null, \StructType\Pre_Hire_Probation_Review_DataType $pre_Hire_Probation_Review = null)
    {
        $this
            ->setPre_Hire_Probation_Period_Duration_Reference($pre_Hire_Probation_Period_Duration_Reference)
            ->setPre_Hire_Probation_Period_Unit_Reference($pre_Hire_Probation_Period_Unit_Reference)
            ->setPre_Hire_Probation_Review($pre_Hire_Probation_Review);
    }
    /**
     * Get Pre_Hire_Probation_Period_Duration_Reference value
     * @return float|null
     */
    public function getPre_Hire_Probation_Period_Duration_Reference()
    {
        return $this->{'Pre-Hire_Probation_Period_Duration_Reference'};
    }
    /**
     * Set Pre_Hire_Probation_Period_Duration_Reference value
     * @param float $pre_Hire_Probation_Period_Duration_Reference
     * @return \StructType\Pre_Hire_Probation_Period_Length_DataType
     */
    public function setPre_Hire_Probation_Period_Duration_Reference($pre_Hire_Probation_Period_Duration_Reference = null)
    {
        // validation for constraint: float
        if (!is_null($pre_Hire_Probation_Period_Duration_Reference) && !(is_float($pre_Hire_Probation_Period_Duration_Reference) || is_numeric($pre_Hire_Probation_Period_Duration_Reference))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pre_Hire_Probation_Period_Duration_Reference, true), gettype($pre_Hire_Probation_Period_Duration_Reference)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($pre_Hire_Probation_Period_Duration_Reference) && mb_strlen(mb_substr($pre_Hire_Probation_Period_Duration_Reference, false !== mb_strpos($pre_Hire_Probation_Period_Duration_Reference, '.') ? mb_strpos($pre_Hire_Probation_Period_Duration_Reference, '.') + 1 : mb_strlen($pre_Hire_Probation_Period_Duration_Reference))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($pre_Hire_Probation_Period_Duration_Reference, true), mb_strlen(mb_substr($pre_Hire_Probation_Period_Duration_Reference, mb_strpos($pre_Hire_Probation_Period_Duration_Reference, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($pre_Hire_Probation_Period_Duration_Reference) && $pre_Hire_Probation_Period_Duration_Reference < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($pre_Hire_Probation_Period_Duration_Reference, true)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($pre_Hire_Probation_Period_Duration_Reference) && mb_strlen(preg_replace('/(\D)/', '', $pre_Hire_Probation_Period_Duration_Reference)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($pre_Hire_Probation_Period_Duration_Reference, true), mb_strlen(preg_replace('/(\D)/', '', $pre_Hire_Probation_Period_Duration_Reference))), __LINE__);
        }
        $this->Pre_Hire_Probation_Period_Duration_Reference = $this->{'Pre-Hire_Probation_Period_Duration_Reference'} = $pre_Hire_Probation_Period_Duration_Reference;
        return $this;
    }
    /**
     * Get Pre_Hire_Probation_Period_Unit_Reference value
     * @return \StructType\Pre_Hire_Probation_Period_UnitObjectType|null
     */
    public function getPre_Hire_Probation_Period_Unit_Reference()
    {
        return $this->{'Pre-Hire_Probation_Period_Unit_Reference'};
    }
    /**
     * Set Pre_Hire_Probation_Period_Unit_Reference value
     * @param \StructType\Pre_Hire_Probation_Period_UnitObjectType $pre_Hire_Probation_Period_Unit_Reference
     * @return \StructType\Pre_Hire_Probation_Period_Length_DataType
     */
    public function setPre_Hire_Probation_Period_Unit_Reference(\StructType\Pre_Hire_Probation_Period_UnitObjectType $pre_Hire_Probation_Period_Unit_Reference = null)
    {
        $this->Pre_Hire_Probation_Period_Unit_Reference = $this->{'Pre-Hire_Probation_Period_Unit_Reference'} = $pre_Hire_Probation_Period_Unit_Reference;
        return $this;
    }
    /**
     * Get Pre_Hire_Probation_Review value
     * @return \StructType\Pre_Hire_Probation_Review_DataType|null
     */
    public function getPre_Hire_Probation_Review()
    {
        return $this->{'Pre-Hire_Probation_Review'};
    }
    /**
     * Set Pre_Hire_Probation_Review value
     * @param \StructType\Pre_Hire_Probation_Review_DataType $pre_Hire_Probation_Review
     * @return \StructType\Pre_Hire_Probation_Period_Length_DataType
     */
    public function setPre_Hire_Probation_Review(\StructType\Pre_Hire_Probation_Review_DataType $pre_Hire_Probation_Review = null)
    {
        $this->Pre_Hire_Probation_Review = $this->{'Pre-Hire_Probation_Review'} = $pre_Hire_Probation_Review;
        return $this;
    }
}
