<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Positions_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains each Position based on the Request References or Request Criteria. The data returned is the current information as of the dates in the response filter, and does not include all historical information about the position.
 * @subpackage Structs
 */
class Positions_Response_DataType extends AbstractStructBase
{
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Position_RestrictionType[]
     */
    public $Position;
    /**
     * Constructor method for Positions_Response_DataType
     * @uses Positions_Response_DataType::setPosition()
     * @param \StructType\Position_RestrictionType[] $position
     */
    public function __construct(array $position = array())
    {
        $this
            ->setPosition($position);
    }
    /**
     * Get Position value
     * @return \StructType\Position_RestrictionType[]|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * This method is responsible for validating the values passed to the setPosition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPosition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePositionForArrayConstraintsFromSetPosition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $positions_Response_DataTypePositionItem) {
            // validation for constraint: itemType
            if (!$positions_Response_DataTypePositionItem instanceof \StructType\Position_RestrictionType) {
                $invalidValues[] = is_object($positions_Response_DataTypePositionItem) ? get_class($positions_Response_DataTypePositionItem) : sprintf('%s(%s)', gettype($positions_Response_DataTypePositionItem), var_export($positions_Response_DataTypePositionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Position property can only contain items of type \StructType\Position_RestrictionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Position value
     * @throws \InvalidArgumentException
     * @param \StructType\Position_RestrictionType[] $position
     * @return \StructType\Positions_Response_DataType
     */
    public function setPosition(array $position = array())
    {
        // validation for constraint: array
        if ('' !== ($positionArrayErrorMessage = self::validatePositionForArrayConstraintsFromSetPosition($position))) {
            throw new \InvalidArgumentException($positionArrayErrorMessage, __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Add item to Position value
     * @throws \InvalidArgumentException
     * @param \StructType\Position_RestrictionType $item
     * @return \StructType\Positions_Response_DataType
     */
    public function addToPosition(\StructType\Position_RestrictionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Position_RestrictionType) {
            throw new \InvalidArgumentException(sprintf('The Position property can only contain items of type \StructType\Position_RestrictionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Position[] = $item;
        return $this;
    }
}
