<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Position_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Utilize the Request Criteria element to search the transaction log for specific instance(s) of a Position.
 * @subpackage Structs
 */
class Position_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Transaction_Log_Criteria_Data
     * Meta information extracted from the WSDL
     * - documentation: Searches the transaction log for business processes and event lites to find specific events that occurred during a period of time.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Transaction_Log_CriteriaType[]
     */
    public $Transaction_Log_Criteria_Data;
    /**
     * The Supervisory_Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier for the organization.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supervisory_OrganizationObjectType[]
     */
    public $Supervisory_Organization_Reference;
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: A unique Identifier for a Job Requisition for a Position. Identifies all positions connected to the Job Requisition.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_RequisitionObjectType[]
     */
    public $Job_Requisition_Reference;
    /**
     * The Exclude_Filled_Positions
     * Meta information extracted from the WSDL
     * - documentation: Indicates if filled positions are to be returned in the response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Exclude_Filled_Positions;
    /**
     * The Exclude_Non_Recruitable_Positions
     * Meta information extracted from the WSDL
     * - documentation: If set to true, indicates that non-recruitable positions are to be excluded in the response. Non-recruitable positions include those with an open Job Requisition if the Recruiting Instruction is specified as "Do Not Send To
     * Recruiting System".
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Exclude_Non_Recruitable_Positions;
    /**
     * The Ignore_Future_Positions
     * Meta information extracted from the WSDL
     * - documentation: No data will be returned for positions that are available after the effective date of the request. The position information will remain in the request criteria and they will not cause an error.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Ignore_Future_Positions;
    /**
     * The Include_Closed_Positions
     * Meta information extracted from the WSDL
     * - documentation: Indicates if closed positions are to be included in the response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Closed_Positions;
    /**
     * The Show_Only_Closed_Positions
     * Meta information extracted from the WSDL
     * - documentation: Indicates if only closed positions are to be returned in the response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Show_Only_Closed_Positions;
    /**
     * The Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: The identifier of an existing Event.
     * - minOccurs: 0
     * @var \StructType\EventObjectType
     */
    public $Event_Reference;
    /**
     * The Field_And_Parameter_Criteria_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Field_And_Parameter_Criteria_DataType
     */
    public $Field_And_Parameter_Criteria_Data;
    /**
     * The Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference(s) to the location that a worker being hired/contracted using this opening can use. The results for this criteria are combined(union operation) with the results from the Additional Locations Reference criteria
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LocationObjectType[]
     */
    public $Location_Reference;
    /**
     * The Additional_Locations_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Additional Location(s) for the Job Requisition. This also applies to Positions that have Job Requisitions. The results for this criteria are combined(union operation) with the results from the Location Reference criteria
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LocationObjectType[]
     */
    public $Additional_Locations_Reference;
    /**
     * Constructor method for Position_Request_CriteriaType
     * @uses Position_Request_CriteriaType::setTransaction_Log_Criteria_Data()
     * @uses Position_Request_CriteriaType::setSupervisory_Organization_Reference()
     * @uses Position_Request_CriteriaType::setJob_Requisition_Reference()
     * @uses Position_Request_CriteriaType::setExclude_Filled_Positions()
     * @uses Position_Request_CriteriaType::setExclude_Non_Recruitable_Positions()
     * @uses Position_Request_CriteriaType::setIgnore_Future_Positions()
     * @uses Position_Request_CriteriaType::setInclude_Closed_Positions()
     * @uses Position_Request_CriteriaType::setShow_Only_Closed_Positions()
     * @uses Position_Request_CriteriaType::setEvent_Reference()
     * @uses Position_Request_CriteriaType::setField_And_Parameter_Criteria_Data()
     * @uses Position_Request_CriteriaType::setLocation_Reference()
     * @uses Position_Request_CriteriaType::setAdditional_Locations_Reference()
     * @param \StructType\Transaction_Log_CriteriaType[] $transaction_Log_Criteria_Data
     * @param \StructType\Supervisory_OrganizationObjectType[] $supervisory_Organization_Reference
     * @param \StructType\Job_RequisitionObjectType[] $job_Requisition_Reference
     * @param bool $exclude_Filled_Positions
     * @param bool $exclude_Non_Recruitable_Positions
     * @param bool $ignore_Future_Positions
     * @param bool $include_Closed_Positions
     * @param bool $show_Only_Closed_Positions
     * @param \StructType\EventObjectType $event_Reference
     * @param \StructType\Field_And_Parameter_Criteria_DataType $field_And_Parameter_Criteria_Data
     * @param \StructType\LocationObjectType[] $location_Reference
     * @param \StructType\LocationObjectType[] $additional_Locations_Reference
     */
    public function __construct(array $transaction_Log_Criteria_Data = array(), array $supervisory_Organization_Reference = array(), array $job_Requisition_Reference = array(), $exclude_Filled_Positions = null, $exclude_Non_Recruitable_Positions = null, $ignore_Future_Positions = null, $include_Closed_Positions = null, $show_Only_Closed_Positions = null, \StructType\EventObjectType $event_Reference = null, \StructType\Field_And_Parameter_Criteria_DataType $field_And_Parameter_Criteria_Data = null, array $location_Reference = array(), array $additional_Locations_Reference = array())
    {
        $this
            ->setTransaction_Log_Criteria_Data($transaction_Log_Criteria_Data)
            ->setSupervisory_Organization_Reference($supervisory_Organization_Reference)
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setExclude_Filled_Positions($exclude_Filled_Positions)
            ->setExclude_Non_Recruitable_Positions($exclude_Non_Recruitable_Positions)
            ->setIgnore_Future_Positions($ignore_Future_Positions)
            ->setInclude_Closed_Positions($include_Closed_Positions)
            ->setShow_Only_Closed_Positions($show_Only_Closed_Positions)
            ->setEvent_Reference($event_Reference)
            ->setField_And_Parameter_Criteria_Data($field_And_Parameter_Criteria_Data)
            ->setLocation_Reference($location_Reference)
            ->setAdditional_Locations_Reference($additional_Locations_Reference);
    }
    /**
     * Get Transaction_Log_Criteria_Data value
     * @return \StructType\Transaction_Log_CriteriaType[]|null
     */
    public function getTransaction_Log_Criteria_Data()
    {
        return $this->Transaction_Log_Criteria_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTransaction_Log_Criteria_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransaction_Log_Criteria_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransaction_Log_Criteria_DataForArrayConstraintsFromSetTransaction_Log_Criteria_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $position_Request_CriteriaTypeTransaction_Log_Criteria_DataItem) {
            // validation for constraint: itemType
            if (!$position_Request_CriteriaTypeTransaction_Log_Criteria_DataItem instanceof \StructType\Transaction_Log_CriteriaType) {
                $invalidValues[] = is_object($position_Request_CriteriaTypeTransaction_Log_Criteria_DataItem) ? get_class($position_Request_CriteriaTypeTransaction_Log_Criteria_DataItem) : sprintf('%s(%s)', gettype($position_Request_CriteriaTypeTransaction_Log_Criteria_DataItem), var_export($position_Request_CriteriaTypeTransaction_Log_Criteria_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Transaction_Log_Criteria_Data property can only contain items of type \StructType\Transaction_Log_CriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Transaction_Log_Criteria_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Transaction_Log_CriteriaType[] $transaction_Log_Criteria_Data
     * @return \StructType\Position_Request_CriteriaType
     */
    public function setTransaction_Log_Criteria_Data(array $transaction_Log_Criteria_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($transaction_Log_Criteria_DataArrayErrorMessage = self::validateTransaction_Log_Criteria_DataForArrayConstraintsFromSetTransaction_Log_Criteria_Data($transaction_Log_Criteria_Data))) {
            throw new \InvalidArgumentException($transaction_Log_Criteria_DataArrayErrorMessage, __LINE__);
        }
        $this->Transaction_Log_Criteria_Data = $transaction_Log_Criteria_Data;
        return $this;
    }
    /**
     * Add item to Transaction_Log_Criteria_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Transaction_Log_CriteriaType $item
     * @return \StructType\Position_Request_CriteriaType
     */
    public function addToTransaction_Log_Criteria_Data(\StructType\Transaction_Log_CriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Transaction_Log_CriteriaType) {
            throw new \InvalidArgumentException(sprintf('The Transaction_Log_Criteria_Data property can only contain items of type \StructType\Transaction_Log_CriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Transaction_Log_Criteria_Data[] = $item;
        return $this;
    }
    /**
     * Get Supervisory_Organization_Reference value
     * @return \StructType\Supervisory_OrganizationObjectType[]|null
     */
    public function getSupervisory_Organization_Reference()
    {
        return $this->Supervisory_Organization_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupervisory_Organization_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupervisory_Organization_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupervisory_Organization_ReferenceForArrayConstraintsFromSetSupervisory_Organization_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $position_Request_CriteriaTypeSupervisory_Organization_ReferenceItem) {
            // validation for constraint: itemType
            if (!$position_Request_CriteriaTypeSupervisory_Organization_ReferenceItem instanceof \StructType\Supervisory_OrganizationObjectType) {
                $invalidValues[] = is_object($position_Request_CriteriaTypeSupervisory_Organization_ReferenceItem) ? get_class($position_Request_CriteriaTypeSupervisory_Organization_ReferenceItem) : sprintf('%s(%s)', gettype($position_Request_CriteriaTypeSupervisory_Organization_ReferenceItem), var_export($position_Request_CriteriaTypeSupervisory_Organization_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supervisory_Organization_Reference property can only contain items of type \StructType\Supervisory_OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supervisory_Organization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supervisory_OrganizationObjectType[] $supervisory_Organization_Reference
     * @return \StructType\Position_Request_CriteriaType
     */
    public function setSupervisory_Organization_Reference(array $supervisory_Organization_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supervisory_Organization_ReferenceArrayErrorMessage = self::validateSupervisory_Organization_ReferenceForArrayConstraintsFromSetSupervisory_Organization_Reference($supervisory_Organization_Reference))) {
            throw new \InvalidArgumentException($supervisory_Organization_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supervisory_Organization_Reference = $supervisory_Organization_Reference;
        return $this;
    }
    /**
     * Add item to Supervisory_Organization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supervisory_OrganizationObjectType $item
     * @return \StructType\Position_Request_CriteriaType
     */
    public function addToSupervisory_Organization_Reference(\StructType\Supervisory_OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supervisory_OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supervisory_Organization_Reference property can only contain items of type \StructType\Supervisory_OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supervisory_Organization_Reference[] = $item;
        return $this;
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_RequisitionObjectType[]|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Requisition_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Requisition_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Requisition_ReferenceForArrayConstraintsFromSetJob_Requisition_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $position_Request_CriteriaTypeJob_Requisition_ReferenceItem) {
            // validation for constraint: itemType
            if (!$position_Request_CriteriaTypeJob_Requisition_ReferenceItem instanceof \StructType\Job_RequisitionObjectType) {
                $invalidValues[] = is_object($position_Request_CriteriaTypeJob_Requisition_ReferenceItem) ? get_class($position_Request_CriteriaTypeJob_Requisition_ReferenceItem) : sprintf('%s(%s)', gettype($position_Request_CriteriaTypeJob_Requisition_ReferenceItem), var_export($position_Request_CriteriaTypeJob_Requisition_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Requisition_Reference property can only contain items of type \StructType\Job_RequisitionObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Requisition_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_RequisitionObjectType[] $job_Requisition_Reference
     * @return \StructType\Position_Request_CriteriaType
     */
    public function setJob_Requisition_Reference(array $job_Requisition_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Requisition_ReferenceArrayErrorMessage = self::validateJob_Requisition_ReferenceForArrayConstraintsFromSetJob_Requisition_Reference($job_Requisition_Reference))) {
            throw new \InvalidArgumentException($job_Requisition_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Add item to Job_Requisition_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_RequisitionObjectType $item
     * @return \StructType\Position_Request_CriteriaType
     */
    public function addToJob_Requisition_Reference(\StructType\Job_RequisitionObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_RequisitionObjectType) {
            throw new \InvalidArgumentException(sprintf('The Job_Requisition_Reference property can only contain items of type \StructType\Job_RequisitionObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Requisition_Reference[] = $item;
        return $this;
    }
    /**
     * Get Exclude_Filled_Positions value
     * @return bool|null
     */
    public function getExclude_Filled_Positions()
    {
        return $this->Exclude_Filled_Positions;
    }
    /**
     * Set Exclude_Filled_Positions value
     * @param bool $exclude_Filled_Positions
     * @return \StructType\Position_Request_CriteriaType
     */
    public function setExclude_Filled_Positions($exclude_Filled_Positions = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclude_Filled_Positions) && !is_bool($exclude_Filled_Positions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclude_Filled_Positions, true), gettype($exclude_Filled_Positions)), __LINE__);
        }
        $this->Exclude_Filled_Positions = $exclude_Filled_Positions;
        return $this;
    }
    /**
     * Get Exclude_Non_Recruitable_Positions value
     * @return bool|null
     */
    public function getExclude_Non_Recruitable_Positions()
    {
        return $this->{'Exclude_Non-Recruitable_Positions'};
    }
    /**
     * Set Exclude_Non_Recruitable_Positions value
     * @param bool $exclude_Non_Recruitable_Positions
     * @return \StructType\Position_Request_CriteriaType
     */
    public function setExclude_Non_Recruitable_Positions($exclude_Non_Recruitable_Positions = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclude_Non_Recruitable_Positions) && !is_bool($exclude_Non_Recruitable_Positions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclude_Non_Recruitable_Positions, true), gettype($exclude_Non_Recruitable_Positions)), __LINE__);
        }
        $this->Exclude_Non_Recruitable_Positions = $this->{'Exclude_Non-Recruitable_Positions'} = $exclude_Non_Recruitable_Positions;
        return $this;
    }
    /**
     * Get Ignore_Future_Positions value
     * @return bool|null
     */
    public function getIgnore_Future_Positions()
    {
        return $this->Ignore_Future_Positions;
    }
    /**
     * Set Ignore_Future_Positions value
     * @param bool $ignore_Future_Positions
     * @return \StructType\Position_Request_CriteriaType
     */
    public function setIgnore_Future_Positions($ignore_Future_Positions = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignore_Future_Positions) && !is_bool($ignore_Future_Positions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignore_Future_Positions, true), gettype($ignore_Future_Positions)), __LINE__);
        }
        $this->Ignore_Future_Positions = $ignore_Future_Positions;
        return $this;
    }
    /**
     * Get Include_Closed_Positions value
     * @return bool|null
     */
    public function getInclude_Closed_Positions()
    {
        return $this->Include_Closed_Positions;
    }
    /**
     * Set Include_Closed_Positions value
     * @param bool $include_Closed_Positions
     * @return \StructType\Position_Request_CriteriaType
     */
    public function setInclude_Closed_Positions($include_Closed_Positions = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Closed_Positions) && !is_bool($include_Closed_Positions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Closed_Positions, true), gettype($include_Closed_Positions)), __LINE__);
        }
        $this->Include_Closed_Positions = $include_Closed_Positions;
        return $this;
    }
    /**
     * Get Show_Only_Closed_Positions value
     * @return bool|null
     */
    public function getShow_Only_Closed_Positions()
    {
        return $this->Show_Only_Closed_Positions;
    }
    /**
     * Set Show_Only_Closed_Positions value
     * @param bool $show_Only_Closed_Positions
     * @return \StructType\Position_Request_CriteriaType
     */
    public function setShow_Only_Closed_Positions($show_Only_Closed_Positions = null)
    {
        // validation for constraint: boolean
        if (!is_null($show_Only_Closed_Positions) && !is_bool($show_Only_Closed_Positions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($show_Only_Closed_Positions, true), gettype($show_Only_Closed_Positions)), __LINE__);
        }
        $this->Show_Only_Closed_Positions = $show_Only_Closed_Positions;
        return $this;
    }
    /**
     * Get Event_Reference value
     * @return \StructType\EventObjectType|null
     */
    public function getEvent_Reference()
    {
        return $this->Event_Reference;
    }
    /**
     * Set Event_Reference value
     * @param \StructType\EventObjectType $event_Reference
     * @return \StructType\Position_Request_CriteriaType
     */
    public function setEvent_Reference(\StructType\EventObjectType $event_Reference = null)
    {
        $this->Event_Reference = $event_Reference;
        return $this;
    }
    /**
     * Get Field_And_Parameter_Criteria_Data value
     * @return \StructType\Field_And_Parameter_Criteria_DataType|null
     */
    public function getField_And_Parameter_Criteria_Data()
    {
        return $this->Field_And_Parameter_Criteria_Data;
    }
    /**
     * Set Field_And_Parameter_Criteria_Data value
     * @param \StructType\Field_And_Parameter_Criteria_DataType $field_And_Parameter_Criteria_Data
     * @return \StructType\Position_Request_CriteriaType
     */
    public function setField_And_Parameter_Criteria_Data(\StructType\Field_And_Parameter_Criteria_DataType $field_And_Parameter_Criteria_Data = null)
    {
        $this->Field_And_Parameter_Criteria_Data = $field_And_Parameter_Criteria_Data;
        return $this;
    }
    /**
     * Get Location_Reference value
     * @return \StructType\LocationObjectType[]|null
     */
    public function getLocation_Reference()
    {
        return $this->Location_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setLocation_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocation_ReferenceForArrayConstraintsFromSetLocation_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $position_Request_CriteriaTypeLocation_ReferenceItem) {
            // validation for constraint: itemType
            if (!$position_Request_CriteriaTypeLocation_ReferenceItem instanceof \StructType\LocationObjectType) {
                $invalidValues[] = is_object($position_Request_CriteriaTypeLocation_ReferenceItem) ? get_class($position_Request_CriteriaTypeLocation_ReferenceItem) : sprintf('%s(%s)', gettype($position_Request_CriteriaTypeLocation_ReferenceItem), var_export($position_Request_CriteriaTypeLocation_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Location_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Location_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType[] $location_Reference
     * @return \StructType\Position_Request_CriteriaType
     */
    public function setLocation_Reference(array $location_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($location_ReferenceArrayErrorMessage = self::validateLocation_ReferenceForArrayConstraintsFromSetLocation_Reference($location_Reference))) {
            throw new \InvalidArgumentException($location_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Location_Reference = $location_Reference;
        return $this;
    }
    /**
     * Add item to Location_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType $item
     * @return \StructType\Position_Request_CriteriaType
     */
    public function addToLocation_Reference(\StructType\LocationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Location_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Location_Reference[] = $item;
        return $this;
    }
    /**
     * Get Additional_Locations_Reference value
     * @return \StructType\LocationObjectType[]|null
     */
    public function getAdditional_Locations_Reference()
    {
        return $this->Additional_Locations_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditional_Locations_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditional_Locations_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditional_Locations_ReferenceForArrayConstraintsFromSetAdditional_Locations_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $position_Request_CriteriaTypeAdditional_Locations_ReferenceItem) {
            // validation for constraint: itemType
            if (!$position_Request_CriteriaTypeAdditional_Locations_ReferenceItem instanceof \StructType\LocationObjectType) {
                $invalidValues[] = is_object($position_Request_CriteriaTypeAdditional_Locations_ReferenceItem) ? get_class($position_Request_CriteriaTypeAdditional_Locations_ReferenceItem) : sprintf('%s(%s)', gettype($position_Request_CriteriaTypeAdditional_Locations_ReferenceItem), var_export($position_Request_CriteriaTypeAdditional_Locations_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Additional_Locations_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Additional_Locations_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType[] $additional_Locations_Reference
     * @return \StructType\Position_Request_CriteriaType
     */
    public function setAdditional_Locations_Reference(array $additional_Locations_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($additional_Locations_ReferenceArrayErrorMessage = self::validateAdditional_Locations_ReferenceForArrayConstraintsFromSetAdditional_Locations_Reference($additional_Locations_Reference))) {
            throw new \InvalidArgumentException($additional_Locations_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Additional_Locations_Reference = $additional_Locations_Reference;
        return $this;
    }
    /**
     * Add item to Additional_Locations_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType $item
     * @return \StructType\Position_Request_CriteriaType
     */
    public function addToAdditional_Locations_Reference(\StructType\LocationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Additional_Locations_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Additional_Locations_Reference[] = $item;
        return $this;
    }
}
