<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Position_Definition_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for general data pertaining to a position opening.
 * @subpackage Structs
 */
class Position_Definition_DataType extends AbstractStructBase
{
    /**
     * The Position_ID
     * Meta information extracted from the WSDL
     * - documentation: The value that will be used for the position opening's reference ID. On a create, if left blank or not entered, a value will be generated.On an edit, if left blank or not entered, the existing value will be retained.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Position_ID;
    /**
     * The Job_Posting_Title
     * Meta information extracted from the WSDL
     * - documentation: Value that will be used in the job posting for this position opening. This value is required on the initial creation.During an edit, leaving the field blank or not submitted will cause the existing value to be retained.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Posting_Title;
    /**
     * The Job_Description_Summary
     * Meta information extracted from the WSDL
     * - documentation: Job Description Summary (plain text) for the Position.On an edit, not submitting the field will cause the existing value to be retained. To clear the value, submit a null value ([empty] in the EIB).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Description_Summary;
    /**
     * The Job_Description
     * Meta information extracted from the WSDL
     * - documentation: Job Description (rich text) for the Position.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Description;
    /**
     * The Critical_Job
     * Meta information extracted from the WSDL
     * - documentation: Boolean attribute which is set to yes if the Position Restriction is considered a critical job. If the Position Restriction has a single Job Profile the default value for this field will be taken from the Job Profile
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Critical_Job;
    /**
     * The Difficulty_to_Fill_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Difficulty to Fill for this Position Restriction. If the Position Restriction has a single Job Profile the default reference will be taken from the Job Profile
     * - minOccurs: 0
     * @var \StructType\Difficulty_to_FillObjectType
     */
    public $Difficulty_to_Fill_Reference;
    /**
     * The Available_for_Overlap
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether a position is available for overlap. Configure the setting on the Edit Tenant Setup - HCM task.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Available_for_Overlap;
    /**
     * Constructor method for Position_Definition_DataType
     * @uses Position_Definition_DataType::setPosition_ID()
     * @uses Position_Definition_DataType::setJob_Posting_Title()
     * @uses Position_Definition_DataType::setJob_Description_Summary()
     * @uses Position_Definition_DataType::setJob_Description()
     * @uses Position_Definition_DataType::setCritical_Job()
     * @uses Position_Definition_DataType::setDifficulty_to_Fill_Reference()
     * @uses Position_Definition_DataType::setAvailable_for_Overlap()
     * @param string $position_ID
     * @param string $job_Posting_Title
     * @param string $job_Description_Summary
     * @param string $job_Description
     * @param bool $critical_Job
     * @param \StructType\Difficulty_to_FillObjectType $difficulty_to_Fill_Reference
     * @param bool $available_for_Overlap
     */
    public function __construct($position_ID = null, $job_Posting_Title = null, $job_Description_Summary = null, $job_Description = null, $critical_Job = null, \StructType\Difficulty_to_FillObjectType $difficulty_to_Fill_Reference = null, $available_for_Overlap = null)
    {
        $this
            ->setPosition_ID($position_ID)
            ->setJob_Posting_Title($job_Posting_Title)
            ->setJob_Description_Summary($job_Description_Summary)
            ->setJob_Description($job_Description)
            ->setCritical_Job($critical_Job)
            ->setDifficulty_to_Fill_Reference($difficulty_to_Fill_Reference)
            ->setAvailable_for_Overlap($available_for_Overlap);
    }
    /**
     * Get Position_ID value
     * @return string|null
     */
    public function getPosition_ID()
    {
        return $this->Position_ID;
    }
    /**
     * Set Position_ID value
     * @param string $position_ID
     * @return \StructType\Position_Definition_DataType
     */
    public function setPosition_ID($position_ID = null)
    {
        // validation for constraint: string
        if (!is_null($position_ID) && !is_string($position_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($position_ID, true), gettype($position_ID)), __LINE__);
        }
        $this->Position_ID = $position_ID;
        return $this;
    }
    /**
     * Get Job_Posting_Title value
     * @return string|null
     */
    public function getJob_Posting_Title()
    {
        return $this->Job_Posting_Title;
    }
    /**
     * Set Job_Posting_Title value
     * @param string $job_Posting_Title
     * @return \StructType\Position_Definition_DataType
     */
    public function setJob_Posting_Title($job_Posting_Title = null)
    {
        // validation for constraint: string
        if (!is_null($job_Posting_Title) && !is_string($job_Posting_Title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Posting_Title, true), gettype($job_Posting_Title)), __LINE__);
        }
        $this->Job_Posting_Title = $job_Posting_Title;
        return $this;
    }
    /**
     * Get Job_Description_Summary value
     * @return string|null
     */
    public function getJob_Description_Summary()
    {
        return $this->Job_Description_Summary;
    }
    /**
     * Set Job_Description_Summary value
     * @param string $job_Description_Summary
     * @return \StructType\Position_Definition_DataType
     */
    public function setJob_Description_Summary($job_Description_Summary = null)
    {
        // validation for constraint: string
        if (!is_null($job_Description_Summary) && !is_string($job_Description_Summary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Description_Summary, true), gettype($job_Description_Summary)), __LINE__);
        }
        $this->Job_Description_Summary = $job_Description_Summary;
        return $this;
    }
    /**
     * Get Job_Description value
     * @return string|null
     */
    public function getJob_Description()
    {
        return $this->Job_Description;
    }
    /**
     * Set Job_Description value
     * @param string $job_Description
     * @return \StructType\Position_Definition_DataType
     */
    public function setJob_Description($job_Description = null)
    {
        // validation for constraint: string
        if (!is_null($job_Description) && !is_string($job_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Description, true), gettype($job_Description)), __LINE__);
        }
        $this->Job_Description = $job_Description;
        return $this;
    }
    /**
     * Get Critical_Job value
     * @return bool|null
     */
    public function getCritical_Job()
    {
        return $this->Critical_Job;
    }
    /**
     * Set Critical_Job value
     * @param bool $critical_Job
     * @return \StructType\Position_Definition_DataType
     */
    public function setCritical_Job($critical_Job = null)
    {
        // validation for constraint: boolean
        if (!is_null($critical_Job) && !is_bool($critical_Job)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($critical_Job, true), gettype($critical_Job)), __LINE__);
        }
        $this->Critical_Job = $critical_Job;
        return $this;
    }
    /**
     * Get Difficulty_to_Fill_Reference value
     * @return \StructType\Difficulty_to_FillObjectType|null
     */
    public function getDifficulty_to_Fill_Reference()
    {
        return $this->Difficulty_to_Fill_Reference;
    }
    /**
     * Set Difficulty_to_Fill_Reference value
     * @param \StructType\Difficulty_to_FillObjectType $difficulty_to_Fill_Reference
     * @return \StructType\Position_Definition_DataType
     */
    public function setDifficulty_to_Fill_Reference(\StructType\Difficulty_to_FillObjectType $difficulty_to_Fill_Reference = null)
    {
        $this->Difficulty_to_Fill_Reference = $difficulty_to_Fill_Reference;
        return $this;
    }
    /**
     * Get Available_for_Overlap value
     * @return bool|null
     */
    public function getAvailable_for_Overlap()
    {
        return $this->Available_for_Overlap;
    }
    /**
     * Set Available_for_Overlap value
     * @param bool $available_for_Overlap
     * @return \StructType\Position_Definition_DataType
     */
    public function setAvailable_for_Overlap($available_for_Overlap = null)
    {
        // validation for constraint: boolean
        if (!is_null($available_for_Overlap) && !is_bool($available_for_Overlap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($available_for_Overlap, true), gettype($available_for_Overlap)), __LINE__);
        }
        $this->Available_for_Overlap = $available_for_Overlap;
        return $this;
    }
}
