<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Personal_Information_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: You cannot submit personal information for this person and the country. | Usage Type is Invalid for this Contactable. | Wrapper element for Personal Data.
 * @subpackage Structs
 */
class Personal_Information_DataType extends AbstractStructBase
{
    /**
     * The Universal_ID
     * Meta information extracted from the WSDL
     * - documentation: The universal ID uniquely identifies the Person. It remains the same for a person regardless of what roles they have. This field will be automatically populated if a sequence generator is configured in Edit Tenant Setup-System.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Universal_ID;
    /**
     * The Name_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains the legal, preferred, and additional names for a person.
     * - minOccurs: 0
     * @var \StructType\Person_Name_DataType
     */
    public $Name_Data;
    /**
     * The Personal_Information_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Personal_Information_Common_DataType[]
     */
    public $Personal_Information_Data;
    /**
     * The Identification_Data
     * Meta information extracted from the WSDL
     * - documentation: The id information for the person (national ids, government ids, passport ids, visa ids, license ids, custom ids).Security Note: This is secured to the following domains: My ID Information, Worker ID Information, Applicant Personal
     * Data: ID Information
     * - minOccurs: 0
     * @var \StructType\Person_Identification_DataType
     */
    public $Identification_Data;
    /**
     * The Contact_Data
     * Meta information extracted from the WSDL
     * - documentation: All of the person's contact data (address, phone, email, instant messenger, web address).Security Note: The response for Contact information is secured to the My Contact Information and Worker Private Contact Information domains for
     * Get Workers and Get Payees and secured to the Applicant Data: Contact Information domain for Get Applicants web service.
     * - minOccurs: 0
     * @var \StructType\Contact_Information_DataType
     */
    public $Contact_Data;
    /**
     * The Tobacco_Use
     * Meta information extracted from the WSDL
     * - documentation: True if the person uses tobacco. To update a person's Tobacco Use, use the Put Worker Wellness Data web service.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Tobacco_Use;
    /**
     * Constructor method for Personal_Information_DataType
     * @uses Personal_Information_DataType::setUniversal_ID()
     * @uses Personal_Information_DataType::setName_Data()
     * @uses Personal_Information_DataType::setPersonal_Information_Data()
     * @uses Personal_Information_DataType::setIdentification_Data()
     * @uses Personal_Information_DataType::setContact_Data()
     * @uses Personal_Information_DataType::setTobacco_Use()
     * @param string $universal_ID
     * @param \StructType\Person_Name_DataType $name_Data
     * @param \StructType\Personal_Information_Common_DataType[] $personal_Information_Data
     * @param \StructType\Person_Identification_DataType $identification_Data
     * @param \StructType\Contact_Information_DataType $contact_Data
     * @param bool $tobacco_Use
     */
    public function __construct($universal_ID = null, \StructType\Person_Name_DataType $name_Data = null, array $personal_Information_Data = array(), \StructType\Person_Identification_DataType $identification_Data = null, \StructType\Contact_Information_DataType $contact_Data = null, $tobacco_Use = null)
    {
        $this
            ->setUniversal_ID($universal_ID)
            ->setName_Data($name_Data)
            ->setPersonal_Information_Data($personal_Information_Data)
            ->setIdentification_Data($identification_Data)
            ->setContact_Data($contact_Data)
            ->setTobacco_Use($tobacco_Use);
    }
    /**
     * Get Universal_ID value
     * @return string|null
     */
    public function getUniversal_ID()
    {
        return $this->Universal_ID;
    }
    /**
     * Set Universal_ID value
     * @param string $universal_ID
     * @return \StructType\Personal_Information_DataType
     */
    public function setUniversal_ID($universal_ID = null)
    {
        // validation for constraint: string
        if (!is_null($universal_ID) && !is_string($universal_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($universal_ID, true), gettype($universal_ID)), __LINE__);
        }
        $this->Universal_ID = $universal_ID;
        return $this;
    }
    /**
     * Get Name_Data value
     * @return \StructType\Person_Name_DataType|null
     */
    public function getName_Data()
    {
        return $this->Name_Data;
    }
    /**
     * Set Name_Data value
     * @param \StructType\Person_Name_DataType $name_Data
     * @return \StructType\Personal_Information_DataType
     */
    public function setName_Data(\StructType\Person_Name_DataType $name_Data = null)
    {
        $this->Name_Data = $name_Data;
        return $this;
    }
    /**
     * Get Personal_Information_Data value
     * @return \StructType\Personal_Information_Common_DataType[]|null
     */
    public function getPersonal_Information_Data()
    {
        return $this->Personal_Information_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPersonal_Information_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonal_Information_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersonal_Information_DataForArrayConstraintsFromSetPersonal_Information_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personal_Information_DataTypePersonal_Information_DataItem) {
            // validation for constraint: itemType
            if (!$personal_Information_DataTypePersonal_Information_DataItem instanceof \StructType\Personal_Information_Common_DataType) {
                $invalidValues[] = is_object($personal_Information_DataTypePersonal_Information_DataItem) ? get_class($personal_Information_DataTypePersonal_Information_DataItem) : sprintf('%s(%s)', gettype($personal_Information_DataTypePersonal_Information_DataItem), var_export($personal_Information_DataTypePersonal_Information_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Personal_Information_Data property can only contain items of type \StructType\Personal_Information_Common_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Personal_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Personal_Information_Common_DataType[] $personal_Information_Data
     * @return \StructType\Personal_Information_DataType
     */
    public function setPersonal_Information_Data(array $personal_Information_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($personal_Information_DataArrayErrorMessage = self::validatePersonal_Information_DataForArrayConstraintsFromSetPersonal_Information_Data($personal_Information_Data))) {
            throw new \InvalidArgumentException($personal_Information_DataArrayErrorMessage, __LINE__);
        }
        $this->Personal_Information_Data = $personal_Information_Data;
        return $this;
    }
    /**
     * Add item to Personal_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Personal_Information_Common_DataType $item
     * @return \StructType\Personal_Information_DataType
     */
    public function addToPersonal_Information_Data(\StructType\Personal_Information_Common_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Personal_Information_Common_DataType) {
            throw new \InvalidArgumentException(sprintf('The Personal_Information_Data property can only contain items of type \StructType\Personal_Information_Common_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Personal_Information_Data[] = $item;
        return $this;
    }
    /**
     * Get Identification_Data value
     * @return \StructType\Person_Identification_DataType|null
     */
    public function getIdentification_Data()
    {
        return $this->Identification_Data;
    }
    /**
     * Set Identification_Data value
     * @param \StructType\Person_Identification_DataType $identification_Data
     * @return \StructType\Personal_Information_DataType
     */
    public function setIdentification_Data(\StructType\Person_Identification_DataType $identification_Data = null)
    {
        $this->Identification_Data = $identification_Data;
        return $this;
    }
    /**
     * Get Contact_Data value
     * @return \StructType\Contact_Information_DataType|null
     */
    public function getContact_Data()
    {
        return $this->Contact_Data;
    }
    /**
     * Set Contact_Data value
     * @param \StructType\Contact_Information_DataType $contact_Data
     * @return \StructType\Personal_Information_DataType
     */
    public function setContact_Data(\StructType\Contact_Information_DataType $contact_Data = null)
    {
        $this->Contact_Data = $contact_Data;
        return $this;
    }
    /**
     * Get Tobacco_Use value
     * @return bool|null
     */
    public function getTobacco_Use()
    {
        return $this->Tobacco_Use;
    }
    /**
     * Set Tobacco_Use value
     * @param bool $tobacco_Use
     * @return \StructType\Personal_Information_DataType
     */
    public function setTobacco_Use($tobacco_Use = null)
    {
        // validation for constraint: boolean
        if (!is_null($tobacco_Use) && !is_bool($tobacco_Use)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tobacco_Use, true), gettype($tobacco_Use)), __LINE__);
        }
        $this->Tobacco_Use = $tobacco_Use;
        return $this;
    }
}
