<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Override_Notice_Period_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Adds or updates the unit and duration for a custom notice period.
 * @subpackage Structs
 */
class Override_Notice_Period_DataType extends AbstractStructBase
{
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: The duration for Employer Notice Period. Example: Number of Days, Weeks, or Months. | The number of minutes in a time slot within a time block. If you leave Time Slot Duration (minutes) 0, then there is only 1 time slot within the
     * time block and the Time Slot Duration (minutes) equals the minutes of the time block. Example: If the time block is 2 hours and Time Slot Duration (minutes) is 60, then the time block is divided into 2 time slots. If the time block is 2 hours and the
     * Time Slot Duration (minutes) is 0, then there is 1 time slot and the Time Slot Duration (minutes) still shows zero but is really 120 minutes.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 20
     * @var float
     */
    public $Duration;
    /**
     * The Unit_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Date and Time Unit. Example: Days, Weeks, or Months.
     * @var \StructType\Date_And_Time_UnitObjectType
     */
    public $Unit_Reference;
    /**
     * The Adjustment_Reference
     * Meta information extracted from the WSDL
     * - documentation: The notice period adjustment. Example: 15th or end of month, or end of month.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Adjustment_Reference;
    /**
     * Constructor method for Override_Notice_Period_DataType
     * @uses Override_Notice_Period_DataType::setDuration()
     * @uses Override_Notice_Period_DataType::setUnit_Reference()
     * @uses Override_Notice_Period_DataType::setAdjustment_Reference()
     * @param float $duration
     * @param \StructType\Date_And_Time_UnitObjectType $unit_Reference
     * @param \StructType\Unique_IdentifierObjectType $adjustment_Reference
     */
    public function __construct($duration = null, \StructType\Date_And_Time_UnitObjectType $unit_Reference = null, \StructType\Unique_IdentifierObjectType $adjustment_Reference = null)
    {
        $this
            ->setDuration($duration)
            ->setUnit_Reference($unit_Reference)
            ->setAdjustment_Reference($adjustment_Reference);
    }
    /**
     * Get Duration value
     * @return float|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param float $duration
     * @return \StructType\Override_Notice_Period_DataType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: float
        if (!is_null($duration) && !(is_float($duration) || is_numeric($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($duration) && mb_strlen(mb_substr($duration, false !== mb_strpos($duration, '.') ? mb_strpos($duration, '.') + 1 : mb_strlen($duration))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($duration, true), mb_strlen(mb_substr($duration, mb_strpos($duration, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($duration) && $duration < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($duration, true)), __LINE__);
        }
        // validation for constraint: totalDigits(20)
        if (!is_null($duration) && mb_strlen(preg_replace('/(\D)/', '', $duration)) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 20 digits, "%d" given', var_export($duration, true), mb_strlen(preg_replace('/(\D)/', '', $duration))), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get Unit_Reference value
     * @return \StructType\Date_And_Time_UnitObjectType|null
     */
    public function getUnit_Reference()
    {
        return $this->Unit_Reference;
    }
    /**
     * Set Unit_Reference value
     * @param \StructType\Date_And_Time_UnitObjectType $unit_Reference
     * @return \StructType\Override_Notice_Period_DataType
     */
    public function setUnit_Reference(\StructType\Date_And_Time_UnitObjectType $unit_Reference = null)
    {
        $this->Unit_Reference = $unit_Reference;
        return $this;
    }
    /**
     * Get Adjustment_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getAdjustment_Reference()
    {
        return $this->Adjustment_Reference;
    }
    /**
     * Set Adjustment_Reference value
     * @param \StructType\Unique_IdentifierObjectType $adjustment_Reference
     * @return \StructType\Override_Notice_Period_DataType
     */
    public function setAdjustment_Reference(\StructType\Unique_IdentifierObjectType $adjustment_Reference = null)
    {
        $this->Adjustment_Reference = $adjustment_Reference;
        return $this;
    }
}
