<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Offer_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for Offer response.
 * @subpackage Structs
 */
class Offer_ResponseType extends AbstractStructBase
{
    /**
     * The Offer_Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: Offer event reference
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Offer_Event_Reference;
    /**
     * The Business_Process_Warning
     * Meta information extracted from the WSDL
     * - documentation: Will populate text attribute if Offer Event is in Process Definition Error and there is a disposition/next step input
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Business_Process_Warning;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Offer_ResponseType
     * @uses Offer_ResponseType::setOffer_Event_Reference()
     * @uses Offer_ResponseType::setBusiness_Process_Warning()
     * @uses Offer_ResponseType::setVersion()
     * @param \StructType\Unique_IdentifierObjectType $offer_Event_Reference
     * @param string $business_Process_Warning
     * @param string $version
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $offer_Event_Reference = null, $business_Process_Warning = null, $version = null)
    {
        $this
            ->setOffer_Event_Reference($offer_Event_Reference)
            ->setBusiness_Process_Warning($business_Process_Warning)
            ->setVersion($version);
    }
    /**
     * Get Offer_Event_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getOffer_Event_Reference()
    {
        return $this->Offer_Event_Reference;
    }
    /**
     * Set Offer_Event_Reference value
     * @param \StructType\Unique_IdentifierObjectType $offer_Event_Reference
     * @return \StructType\Offer_ResponseType
     */
    public function setOffer_Event_Reference(\StructType\Unique_IdentifierObjectType $offer_Event_Reference = null)
    {
        $this->Offer_Event_Reference = $offer_Event_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Warning value
     * @return string|null
     */
    public function getBusiness_Process_Warning()
    {
        return $this->Business_Process_Warning;
    }
    /**
     * Set Business_Process_Warning value
     * @param string $business_Process_Warning
     * @return \StructType\Offer_ResponseType
     */
    public function setBusiness_Process_Warning($business_Process_Warning = null)
    {
        // validation for constraint: string
        if (!is_null($business_Process_Warning) && !is_string($business_Process_Warning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($business_Process_Warning, true), gettype($business_Process_Warning)), __LINE__);
        }
        $this->Business_Process_Warning = $business_Process_Warning;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Offer_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
