<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Multiple_Choice_Answer_Score_for_Questionnaire_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: The scores for question multiple choice answers.
 * @subpackage Structs
 */
class Multiple_Choice_Answer_Score_for_Questionnaire_DataType extends AbstractStructBase
{
    /**
     * The Question_Multiple_Choice_Answer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a question multiple choice answer.
     * @var \StructType\Question_Multiple_Choice_AnswerObjectType
     */
    public $Question_Multiple_Choice_Answer_Reference;
    /**
     * The Score
     * Meta information extracted from the WSDL
     * - documentation: The score for a question multiple choice answer.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Score;
    /**
     * Constructor method for Multiple_Choice_Answer_Score_for_Questionnaire_DataType
     * @uses Multiple_Choice_Answer_Score_for_Questionnaire_DataType::setQuestion_Multiple_Choice_Answer_Reference()
     * @uses Multiple_Choice_Answer_Score_for_Questionnaire_DataType::setScore()
     * @param \StructType\Question_Multiple_Choice_AnswerObjectType $question_Multiple_Choice_Answer_Reference
     * @param float $score
     */
    public function __construct(\StructType\Question_Multiple_Choice_AnswerObjectType $question_Multiple_Choice_Answer_Reference = null, $score = null)
    {
        $this
            ->setQuestion_Multiple_Choice_Answer_Reference($question_Multiple_Choice_Answer_Reference)
            ->setScore($score);
    }
    /**
     * Get Question_Multiple_Choice_Answer_Reference value
     * @return \StructType\Question_Multiple_Choice_AnswerObjectType|null
     */
    public function getQuestion_Multiple_Choice_Answer_Reference()
    {
        return $this->Question_Multiple_Choice_Answer_Reference;
    }
    /**
     * Set Question_Multiple_Choice_Answer_Reference value
     * @param \StructType\Question_Multiple_Choice_AnswerObjectType $question_Multiple_Choice_Answer_Reference
     * @return \StructType\Multiple_Choice_Answer_Score_for_Questionnaire_DataType
     */
    public function setQuestion_Multiple_Choice_Answer_Reference(\StructType\Question_Multiple_Choice_AnswerObjectType $question_Multiple_Choice_Answer_Reference = null)
    {
        $this->Question_Multiple_Choice_Answer_Reference = $question_Multiple_Choice_Answer_Reference;
        return $this;
    }
    /**
     * Get Score value
     * @return float|null
     */
    public function getScore()
    {
        return $this->Score;
    }
    /**
     * Set Score value
     * @param float $score
     * @return \StructType\Multiple_Choice_Answer_Score_for_Questionnaire_DataType
     */
    public function setScore($score = null)
    {
        // validation for constraint: float
        if (!is_null($score) && !(is_float($score) || is_numeric($score))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($score, true), gettype($score)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($score) && mb_strlen(mb_substr($score, false !== mb_strpos($score, '.') ? mb_strpos($score, '.') + 1 : mb_strlen($score))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($score, true), mb_strlen(mb_substr($score, mb_strpos($score, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($score) && mb_strlen(preg_replace('/(\D)/', '', $score)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($score, true), mb_strlen(preg_replace('/(\D)/', '', $score))), __LINE__);
        }
        $this->Score = $score;
        return $this;
    }
}
