<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Move_Candidate_to_Linked_Job_Requisition_ResponseType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: The response of the Move To Linked Job Requisition Web Service Task.
 * @subpackage Structs
 */
class Move_Candidate_to_Linked_Job_Requisition_ResponseType extends AbstractStructBase
{
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Job Requisition Candidates were moved to.
     * - minOccurs: 0
     * @var \StructType\Job_RequisitionObjectType
     */
    public $Job_Requisition_Reference;
    /**
     * The Evergreen_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Evergreen Requisition Candidates were moved from.
     * - minOccurs: 0
     * @var \StructType\Evergreen_Job_RequisitionObjectType
     */
    public $Evergreen_Requisition_Reference;
    /**
     * The Job_Application_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Candidates that were moved.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_ApplicationObjectType[]
     */
    public $Job_Application_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Move_Candidate_to_Linked_Job_Requisition_ResponseType
     * @uses Move_Candidate_to_Linked_Job_Requisition_ResponseType::setJob_Requisition_Reference()
     * @uses Move_Candidate_to_Linked_Job_Requisition_ResponseType::setEvergreen_Requisition_Reference()
     * @uses Move_Candidate_to_Linked_Job_Requisition_ResponseType::setJob_Application_Reference()
     * @uses Move_Candidate_to_Linked_Job_Requisition_ResponseType::setVersion()
     * @param \StructType\Job_RequisitionObjectType $job_Requisition_Reference
     * @param \StructType\Evergreen_Job_RequisitionObjectType $evergreen_Requisition_Reference
     * @param \StructType\Job_ApplicationObjectType[] $job_Application_Reference
     * @param string $version
     */
    public function __construct(\StructType\Job_RequisitionObjectType $job_Requisition_Reference = null, \StructType\Evergreen_Job_RequisitionObjectType $evergreen_Requisition_Reference = null, array $job_Application_Reference = array(), $version = null)
    {
        $this
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setEvergreen_Requisition_Reference($evergreen_Requisition_Reference)
            ->setJob_Application_Reference($job_Application_Reference)
            ->setVersion($version);
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_RequisitionObjectType|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * Set Job_Requisition_Reference value
     * @param \StructType\Job_RequisitionObjectType $job_Requisition_Reference
     * @return \StructType\Move_Candidate_to_Linked_Job_Requisition_ResponseType
     */
    public function setJob_Requisition_Reference(\StructType\Job_RequisitionObjectType $job_Requisition_Reference = null)
    {
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Get Evergreen_Requisition_Reference value
     * @return \StructType\Evergreen_Job_RequisitionObjectType|null
     */
    public function getEvergreen_Requisition_Reference()
    {
        return $this->Evergreen_Requisition_Reference;
    }
    /**
     * Set Evergreen_Requisition_Reference value
     * @param \StructType\Evergreen_Job_RequisitionObjectType $evergreen_Requisition_Reference
     * @return \StructType\Move_Candidate_to_Linked_Job_Requisition_ResponseType
     */
    public function setEvergreen_Requisition_Reference(\StructType\Evergreen_Job_RequisitionObjectType $evergreen_Requisition_Reference = null)
    {
        $this->Evergreen_Requisition_Reference = $evergreen_Requisition_Reference;
        return $this;
    }
    /**
     * Get Job_Application_Reference value
     * @return \StructType\Job_ApplicationObjectType[]|null
     */
    public function getJob_Application_Reference()
    {
        return $this->Job_Application_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Application_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Application_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Application_ReferenceForArrayConstraintsFromSetJob_Application_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $move_Candidate_to_Linked_Job_Requisition_ResponseTypeJob_Application_ReferenceItem) {
            // validation for constraint: itemType
            if (!$move_Candidate_to_Linked_Job_Requisition_ResponseTypeJob_Application_ReferenceItem instanceof \StructType\Job_ApplicationObjectType) {
                $invalidValues[] = is_object($move_Candidate_to_Linked_Job_Requisition_ResponseTypeJob_Application_ReferenceItem) ? get_class($move_Candidate_to_Linked_Job_Requisition_ResponseTypeJob_Application_ReferenceItem) : sprintf('%s(%s)', gettype($move_Candidate_to_Linked_Job_Requisition_ResponseTypeJob_Application_ReferenceItem), var_export($move_Candidate_to_Linked_Job_Requisition_ResponseTypeJob_Application_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Application_Reference property can only contain items of type \StructType\Job_ApplicationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Application_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_ApplicationObjectType[] $job_Application_Reference
     * @return \StructType\Move_Candidate_to_Linked_Job_Requisition_ResponseType
     */
    public function setJob_Application_Reference(array $job_Application_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Application_ReferenceArrayErrorMessage = self::validateJob_Application_ReferenceForArrayConstraintsFromSetJob_Application_Reference($job_Application_Reference))) {
            throw new \InvalidArgumentException($job_Application_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Job_Application_Reference = $job_Application_Reference;
        return $this;
    }
    /**
     * Add item to Job_Application_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_ApplicationObjectType $item
     * @return \StructType\Move_Candidate_to_Linked_Job_Requisition_ResponseType
     */
    public function addToJob_Application_Reference(\StructType\Job_ApplicationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_ApplicationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Job_Application_Reference property can only contain items of type \StructType\Job_ApplicationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Application_Reference[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Move_Candidate_to_Linked_Job_Requisition_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
