<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Move_Candidate_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: The result of an attempt to move a Candidate from a stage to next possible stage or to a disposition stage.
 * @subpackage Structs
 */
class Move_Candidate_ResponseType extends AbstractStructBase
{
    /**
     * The Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Job Application Event that has been moved to the requested stage.
     * - minOccurs: 0
     * @var \StructType\Recruiting_EventObjectType
     */
    public $Event_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Move_Candidate_ResponseType
     * @uses Move_Candidate_ResponseType::setEvent_Reference()
     * @uses Move_Candidate_ResponseType::setVersion()
     * @param \StructType\Recruiting_EventObjectType $event_Reference
     * @param string $version
     */
    public function __construct(\StructType\Recruiting_EventObjectType $event_Reference = null, $version = null)
    {
        $this
            ->setEvent_Reference($event_Reference)
            ->setVersion($version);
    }
    /**
     * Get Event_Reference value
     * @return \StructType\Recruiting_EventObjectType|null
     */
    public function getEvent_Reference()
    {
        return $this->Event_Reference;
    }
    /**
     * Set Event_Reference value
     * @param \StructType\Recruiting_EventObjectType $event_Reference
     * @return \StructType\Move_Candidate_ResponseType
     */
    public function setEvent_Reference(\StructType\Recruiting_EventObjectType $event_Reference = null)
    {
        $this->Event_Reference = $event_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Move_Candidate_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
