<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Masked_Recruiting_ConfigurationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Container for Masked Configuration Reference and it's elements
 * @subpackage Structs
 */
class Masked_Recruiting_ConfigurationType extends AbstractStructBase
{
    /**
     * The Masked_Recruiting_Configuration_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Masked Configuration
     * - minOccurs: 0
     * @var \StructType\Masked_ConfigurationObjectType
     */
    public $Masked_Recruiting_Configuration_Reference;
    /**
     * The Masked_Recruiting_Configuration_Data
     * Meta information extracted from the WSDL
     * - documentation: Data of Masked Configuration
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Masked_Recruiting_Configuration_DataType[]
     */
    public $Masked_Recruiting_Configuration_Data;
    /**
     * Constructor method for Masked_Recruiting_ConfigurationType
     * @uses Masked_Recruiting_ConfigurationType::setMasked_Recruiting_Configuration_Reference()
     * @uses Masked_Recruiting_ConfigurationType::setMasked_Recruiting_Configuration_Data()
     * @param \StructType\Masked_ConfigurationObjectType $masked_Recruiting_Configuration_Reference
     * @param \StructType\Masked_Recruiting_Configuration_DataType[] $masked_Recruiting_Configuration_Data
     */
    public function __construct(\StructType\Masked_ConfigurationObjectType $masked_Recruiting_Configuration_Reference = null, array $masked_Recruiting_Configuration_Data = array())
    {
        $this
            ->setMasked_Recruiting_Configuration_Reference($masked_Recruiting_Configuration_Reference)
            ->setMasked_Recruiting_Configuration_Data($masked_Recruiting_Configuration_Data);
    }
    /**
     * Get Masked_Recruiting_Configuration_Reference value
     * @return \StructType\Masked_ConfigurationObjectType|null
     */
    public function getMasked_Recruiting_Configuration_Reference()
    {
        return $this->Masked_Recruiting_Configuration_Reference;
    }
    /**
     * Set Masked_Recruiting_Configuration_Reference value
     * @param \StructType\Masked_ConfigurationObjectType $masked_Recruiting_Configuration_Reference
     * @return \StructType\Masked_Recruiting_ConfigurationType
     */
    public function setMasked_Recruiting_Configuration_Reference(\StructType\Masked_ConfigurationObjectType $masked_Recruiting_Configuration_Reference = null)
    {
        $this->Masked_Recruiting_Configuration_Reference = $masked_Recruiting_Configuration_Reference;
        return $this;
    }
    /**
     * Get Masked_Recruiting_Configuration_Data value
     * @return \StructType\Masked_Recruiting_Configuration_DataType[]|null
     */
    public function getMasked_Recruiting_Configuration_Data()
    {
        return $this->Masked_Recruiting_Configuration_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setMasked_Recruiting_Configuration_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMasked_Recruiting_Configuration_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMasked_Recruiting_Configuration_DataForArrayConstraintsFromSetMasked_Recruiting_Configuration_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $masked_Recruiting_ConfigurationTypeMasked_Recruiting_Configuration_DataItem) {
            // validation for constraint: itemType
            if (!$masked_Recruiting_ConfigurationTypeMasked_Recruiting_Configuration_DataItem instanceof \StructType\Masked_Recruiting_Configuration_DataType) {
                $invalidValues[] = is_object($masked_Recruiting_ConfigurationTypeMasked_Recruiting_Configuration_DataItem) ? get_class($masked_Recruiting_ConfigurationTypeMasked_Recruiting_Configuration_DataItem) : sprintf('%s(%s)', gettype($masked_Recruiting_ConfigurationTypeMasked_Recruiting_Configuration_DataItem), var_export($masked_Recruiting_ConfigurationTypeMasked_Recruiting_Configuration_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Masked_Recruiting_Configuration_Data property can only contain items of type \StructType\Masked_Recruiting_Configuration_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Masked_Recruiting_Configuration_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Masked_Recruiting_Configuration_DataType[] $masked_Recruiting_Configuration_Data
     * @return \StructType\Masked_Recruiting_ConfigurationType
     */
    public function setMasked_Recruiting_Configuration_Data(array $masked_Recruiting_Configuration_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($masked_Recruiting_Configuration_DataArrayErrorMessage = self::validateMasked_Recruiting_Configuration_DataForArrayConstraintsFromSetMasked_Recruiting_Configuration_Data($masked_Recruiting_Configuration_Data))) {
            throw new \InvalidArgumentException($masked_Recruiting_Configuration_DataArrayErrorMessage, __LINE__);
        }
        $this->Masked_Recruiting_Configuration_Data = $masked_Recruiting_Configuration_Data;
        return $this;
    }
    /**
     * Add item to Masked_Recruiting_Configuration_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Masked_Recruiting_Configuration_DataType $item
     * @return \StructType\Masked_Recruiting_ConfigurationType
     */
    public function addToMasked_Recruiting_Configuration_Data(\StructType\Masked_Recruiting_Configuration_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Masked_Recruiting_Configuration_DataType) {
            throw new \InvalidArgumentException(sprintf('The Masked_Recruiting_Configuration_Data property can only contain items of type \StructType\Masked_Recruiting_Configuration_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Masked_Recruiting_Configuration_Data[] = $item;
        return $this;
    }
}
