<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Manage_Job_Requisition_Freeze_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for the freezing/unfreezing of a job requisition.
 * @subpackage Structs
 */
class Manage_Job_Requisition_Freeze_DataType extends AbstractStructBase
{
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the job requisition to be frozen/unfrozen.
     * @var \StructType\Job_Requisition_EnabledObjectType
     */
    public $Job_Requisition_Reference;
    /**
     * The Freeze_Unfreeze_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the reason the job requisition is being frozen/unfrozen.
     * @var \StructType\Event_Classification_SubcategoryObjectType
     */
    public $Freeze_Unfreeze_Reason_Reference;
    /**
     * The Freeze_Unfreeze_Date
     * Meta information extracted from the WSDL
     * - documentation: The Job Requisition Manage Freeze Date is the date the job requisition will be frozen/unfrozen.
     * - maxOccurs: 1
     * @var string
     */
    public $Freeze_Unfreeze_Date;
    /**
     * The Frozen
     * Meta information extracted from the WSDL
     * - documentation: Set to true to freeze the job requisition, false to unfreeze.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Frozen;
    /**
     * The Unpost_Job_Sub_Business_Process
     * Meta information extracted from the WSDL
     * - documentation: Run the Update Job Posting sub business process to unpost the job postings associated with this Job Requisition. To use, Unpost Job must be enabled in the workflow definition for Edit Job Requisition.
     * - minOccurs: 0
     * @var \StructType\Unpost_Job_Sub_Business_ProcessType
     */
    public $Unpost_Job_Sub_Business_Process;
    /**
     * The Post_Job_Sub_Process
     * Meta information extracted from the WSDL
     * - documentation: Run the Post Job Sub Business Process to post this job requisition to one or more Job Posting Sites. To use, Post Job must be enabled in the Workflow Definition for Create Job Requisition.
     * - minOccurs: 0
     * @var \StructType\Post_Job_Sub_Business_ProcessType
     */
    public $Post_Job_Sub_Process;
    /**
     * Constructor method for Manage_Job_Requisition_Freeze_DataType
     * @uses Manage_Job_Requisition_Freeze_DataType::setJob_Requisition_Reference()
     * @uses Manage_Job_Requisition_Freeze_DataType::setFreeze_Unfreeze_Reason_Reference()
     * @uses Manage_Job_Requisition_Freeze_DataType::setFreeze_Unfreeze_Date()
     * @uses Manage_Job_Requisition_Freeze_DataType::setFrozen()
     * @uses Manage_Job_Requisition_Freeze_DataType::setUnpost_Job_Sub_Business_Process()
     * @uses Manage_Job_Requisition_Freeze_DataType::setPost_Job_Sub_Process()
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @param \StructType\Event_Classification_SubcategoryObjectType $freeze_Unfreeze_Reason_Reference
     * @param string $freeze_Unfreeze_Date
     * @param bool $frozen
     * @param \StructType\Unpost_Job_Sub_Business_ProcessType $unpost_Job_Sub_Business_Process
     * @param \StructType\Post_Job_Sub_Business_ProcessType $post_Job_Sub_Process
     */
    public function __construct(\StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null, \StructType\Event_Classification_SubcategoryObjectType $freeze_Unfreeze_Reason_Reference = null, $freeze_Unfreeze_Date = null, $frozen = null, \StructType\Unpost_Job_Sub_Business_ProcessType $unpost_Job_Sub_Business_Process = null, \StructType\Post_Job_Sub_Business_ProcessType $post_Job_Sub_Process = null)
    {
        $this
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setFreeze_Unfreeze_Reason_Reference($freeze_Unfreeze_Reason_Reference)
            ->setFreeze_Unfreeze_Date($freeze_Unfreeze_Date)
            ->setFrozen($frozen)
            ->setUnpost_Job_Sub_Business_Process($unpost_Job_Sub_Business_Process)
            ->setPost_Job_Sub_Process($post_Job_Sub_Process);
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_Requisition_EnabledObjectType|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * Set Job_Requisition_Reference value
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @return \StructType\Manage_Job_Requisition_Freeze_DataType
     */
    public function setJob_Requisition_Reference(\StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null)
    {
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Get Freeze_Unfreeze_Reason_Reference value
     * @return \StructType\Event_Classification_SubcategoryObjectType|null
     */
    public function getFreeze_Unfreeze_Reason_Reference()
    {
        return $this->Freeze_Unfreeze_Reason_Reference;
    }
    /**
     * Set Freeze_Unfreeze_Reason_Reference value
     * @param \StructType\Event_Classification_SubcategoryObjectType $freeze_Unfreeze_Reason_Reference
     * @return \StructType\Manage_Job_Requisition_Freeze_DataType
     */
    public function setFreeze_Unfreeze_Reason_Reference(\StructType\Event_Classification_SubcategoryObjectType $freeze_Unfreeze_Reason_Reference = null)
    {
        $this->Freeze_Unfreeze_Reason_Reference = $freeze_Unfreeze_Reason_Reference;
        return $this;
    }
    /**
     * Get Freeze_Unfreeze_Date value
     * @return string|null
     */
    public function getFreeze_Unfreeze_Date()
    {
        return $this->Freeze_Unfreeze_Date;
    }
    /**
     * Set Freeze_Unfreeze_Date value
     * @param string $freeze_Unfreeze_Date
     * @return \StructType\Manage_Job_Requisition_Freeze_DataType
     */
    public function setFreeze_Unfreeze_Date($freeze_Unfreeze_Date = null)
    {
        // validation for constraint: string
        if (!is_null($freeze_Unfreeze_Date) && !is_string($freeze_Unfreeze_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($freeze_Unfreeze_Date, true), gettype($freeze_Unfreeze_Date)), __LINE__);
        }
        $this->Freeze_Unfreeze_Date = $freeze_Unfreeze_Date;
        return $this;
    }
    /**
     * Get Frozen value
     * @return bool|null
     */
    public function getFrozen()
    {
        return $this->Frozen;
    }
    /**
     * Set Frozen value
     * @param bool $frozen
     * @return \StructType\Manage_Job_Requisition_Freeze_DataType
     */
    public function setFrozen($frozen = null)
    {
        // validation for constraint: boolean
        if (!is_null($frozen) && !is_bool($frozen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($frozen, true), gettype($frozen)), __LINE__);
        }
        $this->Frozen = $frozen;
        return $this;
    }
    /**
     * Get Unpost_Job_Sub_Business_Process value
     * @return \StructType\Unpost_Job_Sub_Business_ProcessType|null
     */
    public function getUnpost_Job_Sub_Business_Process()
    {
        return $this->Unpost_Job_Sub_Business_Process;
    }
    /**
     * Set Unpost_Job_Sub_Business_Process value
     * @param \StructType\Unpost_Job_Sub_Business_ProcessType $unpost_Job_Sub_Business_Process
     * @return \StructType\Manage_Job_Requisition_Freeze_DataType
     */
    public function setUnpost_Job_Sub_Business_Process(\StructType\Unpost_Job_Sub_Business_ProcessType $unpost_Job_Sub_Business_Process = null)
    {
        $this->Unpost_Job_Sub_Business_Process = $unpost_Job_Sub_Business_Process;
        return $this;
    }
    /**
     * Get Post_Job_Sub_Process value
     * @return \StructType\Post_Job_Sub_Business_ProcessType|null
     */
    public function getPost_Job_Sub_Process()
    {
        return $this->Post_Job_Sub_Process;
    }
    /**
     * Set Post_Job_Sub_Process value
     * @param \StructType\Post_Job_Sub_Business_ProcessType $post_Job_Sub_Process
     * @return \StructType\Manage_Job_Requisition_Freeze_DataType
     */
    public function setPost_Job_Sub_Process(\StructType\Post_Job_Sub_Business_ProcessType $post_Job_Sub_Process = null)
    {
        $this->Post_Job_Sub_Process = $post_Job_Sub_Process;
        return $this;
    }
}
