<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Maintain_Candidate_List_Assignment_Subedit_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the data for the Configuration Rule Rows
 * @subpackage Structs
 */
class Maintain_Candidate_List_Assignment_Subedit_DataType extends AbstractStructBase
{
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: The order of the job requisition interview team session. | Order | The order for the Recruiting Self-Schedule Calendar Type. | The Row Order | An alphanumeric value indicating the order of this row.
     * - base: xsd:string
     * - maxLength: 6
     * - maxOccurs: 1
     * @var string
     */
    public $Order;
    /**
     * The Condition_Rule_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Job Requisition Condition Rule
     * @var \StructType\Condition_RuleObjectType
     */
    public $Condition_Rule_Reference;
    /**
     * The Candidate_Grid_Configuration_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Candidate List Configuration Grid
     * @var \StructType\Grid_ConfigurationObjectType
     */
    public $Candidate_Grid_Configuration_Reference;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: The Rule Comment
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for Maintain_Candidate_List_Assignment_Subedit_DataType
     * @uses Maintain_Candidate_List_Assignment_Subedit_DataType::setOrder()
     * @uses Maintain_Candidate_List_Assignment_Subedit_DataType::setCondition_Rule_Reference()
     * @uses Maintain_Candidate_List_Assignment_Subedit_DataType::setCandidate_Grid_Configuration_Reference()
     * @uses Maintain_Candidate_List_Assignment_Subedit_DataType::setComment()
     * @param string $order
     * @param \StructType\Condition_RuleObjectType $condition_Rule_Reference
     * @param \StructType\Grid_ConfigurationObjectType $candidate_Grid_Configuration_Reference
     * @param string $comment
     */
    public function __construct($order = null, \StructType\Condition_RuleObjectType $condition_Rule_Reference = null, \StructType\Grid_ConfigurationObjectType $candidate_Grid_Configuration_Reference = null, $comment = null)
    {
        $this
            ->setOrder($order)
            ->setCondition_Rule_Reference($condition_Rule_Reference)
            ->setCandidate_Grid_Configuration_Reference($candidate_Grid_Configuration_Reference)
            ->setComment($comment);
    }
    /**
     * Get Order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param string $order
     * @return \StructType\Maintain_Candidate_List_Assignment_Subedit_DataType
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($order) && mb_strlen($order) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Condition_Rule_Reference value
     * @return \StructType\Condition_RuleObjectType|null
     */
    public function getCondition_Rule_Reference()
    {
        return $this->Condition_Rule_Reference;
    }
    /**
     * Set Condition_Rule_Reference value
     * @param \StructType\Condition_RuleObjectType $condition_Rule_Reference
     * @return \StructType\Maintain_Candidate_List_Assignment_Subedit_DataType
     */
    public function setCondition_Rule_Reference(\StructType\Condition_RuleObjectType $condition_Rule_Reference = null)
    {
        $this->Condition_Rule_Reference = $condition_Rule_Reference;
        return $this;
    }
    /**
     * Get Candidate_Grid_Configuration_Reference value
     * @return \StructType\Grid_ConfigurationObjectType|null
     */
    public function getCandidate_Grid_Configuration_Reference()
    {
        return $this->Candidate_Grid_Configuration_Reference;
    }
    /**
     * Set Candidate_Grid_Configuration_Reference value
     * @param \StructType\Grid_ConfigurationObjectType $candidate_Grid_Configuration_Reference
     * @return \StructType\Maintain_Candidate_List_Assignment_Subedit_DataType
     */
    public function setCandidate_Grid_Configuration_Reference(\StructType\Grid_ConfigurationObjectType $candidate_Grid_Configuration_Reference = null)
    {
        $this->Candidate_Grid_Configuration_Reference = $candidate_Grid_Configuration_Reference;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Maintain_Candidate_List_Assignment_Subedit_DataType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
}
