<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Maintain_Candidate_List_Assignment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Maintain Candidate List Assignment Data
 * @subpackage Structs
 */
class Maintain_Candidate_List_Assignment_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Candidate_List_Default_Grid_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contains the Default Configuration Grid
     * @var \StructType\Grid_ConfigurationObjectType
     */
    public $Candidate_List_Default_Grid_Reference;
    /**
     * The Candidate_Grid_Configuration_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains the Condition Rules for Maintain Candidate List Assignment
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Maintain_Candidate_List_Assignment_Subedit_DataType[]
     */
    public $Candidate_Grid_Configuration_Data;
    /**
     * The Internal_Candidate_Grid_Configuration_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contains the Internal Candidate Grid Configuration for Recruiter Hub
     * @var \StructType\Grid_ConfigurationObjectType
     */
    public $Internal_Candidate_Grid_Configuration_Reference;
    /**
     * The Referral_Candidate_Grid_Configuration_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contains the Referral Candidate Grid Configuration for Recruiter Hub
     * @var \StructType\Grid_ConfigurationObjectType
     */
    public $Referral_Candidate_Grid_Configuration_Reference;
    /**
     * The Mass_Actions_Candidate_Grid_Configuration_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contains the Mass Actions Candidate Grid Configuration
     * @var \StructType\Grid_ConfigurationObjectType
     */
    public $Mass_Actions_Candidate_Grid_Configuration_Reference;
    /**
     * Constructor method for Maintain_Candidate_List_Assignment_DataType
     * @uses Maintain_Candidate_List_Assignment_DataType::setID()
     * @uses Maintain_Candidate_List_Assignment_DataType::setCandidate_List_Default_Grid_Reference()
     * @uses Maintain_Candidate_List_Assignment_DataType::setCandidate_Grid_Configuration_Data()
     * @uses Maintain_Candidate_List_Assignment_DataType::setInternal_Candidate_Grid_Configuration_Reference()
     * @uses Maintain_Candidate_List_Assignment_DataType::setReferral_Candidate_Grid_Configuration_Reference()
     * @uses Maintain_Candidate_List_Assignment_DataType::setMass_Actions_Candidate_Grid_Configuration_Reference()
     * @param string $iD
     * @param \StructType\Grid_ConfigurationObjectType $candidate_List_Default_Grid_Reference
     * @param \StructType\Maintain_Candidate_List_Assignment_Subedit_DataType[] $candidate_Grid_Configuration_Data
     * @param \StructType\Grid_ConfigurationObjectType $internal_Candidate_Grid_Configuration_Reference
     * @param \StructType\Grid_ConfigurationObjectType $referral_Candidate_Grid_Configuration_Reference
     * @param \StructType\Grid_ConfigurationObjectType $mass_Actions_Candidate_Grid_Configuration_Reference
     */
    public function __construct($iD = null, \StructType\Grid_ConfigurationObjectType $candidate_List_Default_Grid_Reference = null, array $candidate_Grid_Configuration_Data = array(), \StructType\Grid_ConfigurationObjectType $internal_Candidate_Grid_Configuration_Reference = null, \StructType\Grid_ConfigurationObjectType $referral_Candidate_Grid_Configuration_Reference = null, \StructType\Grid_ConfigurationObjectType $mass_Actions_Candidate_Grid_Configuration_Reference = null)
    {
        $this
            ->setID($iD)
            ->setCandidate_List_Default_Grid_Reference($candidate_List_Default_Grid_Reference)
            ->setCandidate_Grid_Configuration_Data($candidate_Grid_Configuration_Data)
            ->setInternal_Candidate_Grid_Configuration_Reference($internal_Candidate_Grid_Configuration_Reference)
            ->setReferral_Candidate_Grid_Configuration_Reference($referral_Candidate_Grid_Configuration_Reference)
            ->setMass_Actions_Candidate_Grid_Configuration_Reference($mass_Actions_Candidate_Grid_Configuration_Reference);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Maintain_Candidate_List_Assignment_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Candidate_List_Default_Grid_Reference value
     * @return \StructType\Grid_ConfigurationObjectType|null
     */
    public function getCandidate_List_Default_Grid_Reference()
    {
        return $this->Candidate_List_Default_Grid_Reference;
    }
    /**
     * Set Candidate_List_Default_Grid_Reference value
     * @param \StructType\Grid_ConfigurationObjectType $candidate_List_Default_Grid_Reference
     * @return \StructType\Maintain_Candidate_List_Assignment_DataType
     */
    public function setCandidate_List_Default_Grid_Reference(\StructType\Grid_ConfigurationObjectType $candidate_List_Default_Grid_Reference = null)
    {
        $this->Candidate_List_Default_Grid_Reference = $candidate_List_Default_Grid_Reference;
        return $this;
    }
    /**
     * Get Candidate_Grid_Configuration_Data value
     * @return \StructType\Maintain_Candidate_List_Assignment_Subedit_DataType[]|null
     */
    public function getCandidate_Grid_Configuration_Data()
    {
        return $this->Candidate_Grid_Configuration_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCandidate_Grid_Configuration_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCandidate_Grid_Configuration_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCandidate_Grid_Configuration_DataForArrayConstraintsFromSetCandidate_Grid_Configuration_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $maintain_Candidate_List_Assignment_DataTypeCandidate_Grid_Configuration_DataItem) {
            // validation for constraint: itemType
            if (!$maintain_Candidate_List_Assignment_DataTypeCandidate_Grid_Configuration_DataItem instanceof \StructType\Maintain_Candidate_List_Assignment_Subedit_DataType) {
                $invalidValues[] = is_object($maintain_Candidate_List_Assignment_DataTypeCandidate_Grid_Configuration_DataItem) ? get_class($maintain_Candidate_List_Assignment_DataTypeCandidate_Grid_Configuration_DataItem) : sprintf('%s(%s)', gettype($maintain_Candidate_List_Assignment_DataTypeCandidate_Grid_Configuration_DataItem), var_export($maintain_Candidate_List_Assignment_DataTypeCandidate_Grid_Configuration_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Candidate_Grid_Configuration_Data property can only contain items of type \StructType\Maintain_Candidate_List_Assignment_Subedit_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Candidate_Grid_Configuration_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Maintain_Candidate_List_Assignment_Subedit_DataType[] $candidate_Grid_Configuration_Data
     * @return \StructType\Maintain_Candidate_List_Assignment_DataType
     */
    public function setCandidate_Grid_Configuration_Data(array $candidate_Grid_Configuration_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($candidate_Grid_Configuration_DataArrayErrorMessage = self::validateCandidate_Grid_Configuration_DataForArrayConstraintsFromSetCandidate_Grid_Configuration_Data($candidate_Grid_Configuration_Data))) {
            throw new \InvalidArgumentException($candidate_Grid_Configuration_DataArrayErrorMessage, __LINE__);
        }
        $this->Candidate_Grid_Configuration_Data = $candidate_Grid_Configuration_Data;
        return $this;
    }
    /**
     * Add item to Candidate_Grid_Configuration_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Maintain_Candidate_List_Assignment_Subedit_DataType $item
     * @return \StructType\Maintain_Candidate_List_Assignment_DataType
     */
    public function addToCandidate_Grid_Configuration_Data(\StructType\Maintain_Candidate_List_Assignment_Subedit_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Maintain_Candidate_List_Assignment_Subedit_DataType) {
            throw new \InvalidArgumentException(sprintf('The Candidate_Grid_Configuration_Data property can only contain items of type \StructType\Maintain_Candidate_List_Assignment_Subedit_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Candidate_Grid_Configuration_Data[] = $item;
        return $this;
    }
    /**
     * Get Internal_Candidate_Grid_Configuration_Reference value
     * @return \StructType\Grid_ConfigurationObjectType|null
     */
    public function getInternal_Candidate_Grid_Configuration_Reference()
    {
        return $this->Internal_Candidate_Grid_Configuration_Reference;
    }
    /**
     * Set Internal_Candidate_Grid_Configuration_Reference value
     * @param \StructType\Grid_ConfigurationObjectType $internal_Candidate_Grid_Configuration_Reference
     * @return \StructType\Maintain_Candidate_List_Assignment_DataType
     */
    public function setInternal_Candidate_Grid_Configuration_Reference(\StructType\Grid_ConfigurationObjectType $internal_Candidate_Grid_Configuration_Reference = null)
    {
        $this->Internal_Candidate_Grid_Configuration_Reference = $internal_Candidate_Grid_Configuration_Reference;
        return $this;
    }
    /**
     * Get Referral_Candidate_Grid_Configuration_Reference value
     * @return \StructType\Grid_ConfigurationObjectType|null
     */
    public function getReferral_Candidate_Grid_Configuration_Reference()
    {
        return $this->Referral_Candidate_Grid_Configuration_Reference;
    }
    /**
     * Set Referral_Candidate_Grid_Configuration_Reference value
     * @param \StructType\Grid_ConfigurationObjectType $referral_Candidate_Grid_Configuration_Reference
     * @return \StructType\Maintain_Candidate_List_Assignment_DataType
     */
    public function setReferral_Candidate_Grid_Configuration_Reference(\StructType\Grid_ConfigurationObjectType $referral_Candidate_Grid_Configuration_Reference = null)
    {
        $this->Referral_Candidate_Grid_Configuration_Reference = $referral_Candidate_Grid_Configuration_Reference;
        return $this;
    }
    /**
     * Get Mass_Actions_Candidate_Grid_Configuration_Reference value
     * @return \StructType\Grid_ConfigurationObjectType|null
     */
    public function getMass_Actions_Candidate_Grid_Configuration_Reference()
    {
        return $this->Mass_Actions_Candidate_Grid_Configuration_Reference;
    }
    /**
     * Set Mass_Actions_Candidate_Grid_Configuration_Reference value
     * @param \StructType\Grid_ConfigurationObjectType $mass_Actions_Candidate_Grid_Configuration_Reference
     * @return \StructType\Maintain_Candidate_List_Assignment_DataType
     */
    public function setMass_Actions_Candidate_Grid_Configuration_Reference(\StructType\Grid_ConfigurationObjectType $mass_Actions_Candidate_Grid_Configuration_Reference = null)
    {
        $this->Mass_Actions_Candidate_Grid_Configuration_Reference = $mass_Actions_Candidate_Grid_Configuration_Reference;
        return $this;
    }
}
