<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Language_Qualification_ReplacementType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for Language Qualifications. Allows all language qualifications for a Job Profile or Position Restriction to be removed - or to replace all existing language qualifications with those sent in the web service.
 * @subpackage Structs
 */
class Language_Qualification_ReplacementType extends AbstractStructBase
{
    /**
     * The Language_Qualification_Replacement_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Language_Qualification_Profile_Replacement_DataType[]
     */
    public $Language_Qualification_Replacement_Data;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: If Yes, deletes all the default qualifications for the position restriction or job profile.
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Language_Qualification_ReplacementType
     * @uses Language_Qualification_ReplacementType::setLanguage_Qualification_Replacement_Data()
     * @uses Language_Qualification_ReplacementType::setDelete()
     * @param \StructType\Language_Qualification_Profile_Replacement_DataType[] $language_Qualification_Replacement_Data
     * @param bool $delete
     */
    public function __construct(array $language_Qualification_Replacement_Data = array(), $delete = null)
    {
        $this
            ->setLanguage_Qualification_Replacement_Data($language_Qualification_Replacement_Data)
            ->setDelete($delete);
    }
    /**
     * Get Language_Qualification_Replacement_Data value
     * @return \StructType\Language_Qualification_Profile_Replacement_DataType[]|null
     */
    public function getLanguage_Qualification_Replacement_Data()
    {
        return $this->Language_Qualification_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setLanguage_Qualification_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLanguage_Qualification_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLanguage_Qualification_Replacement_DataForArrayConstraintsFromSetLanguage_Qualification_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $language_Qualification_ReplacementTypeLanguage_Qualification_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$language_Qualification_ReplacementTypeLanguage_Qualification_Replacement_DataItem instanceof \StructType\Language_Qualification_Profile_Replacement_DataType) {
                $invalidValues[] = is_object($language_Qualification_ReplacementTypeLanguage_Qualification_Replacement_DataItem) ? get_class($language_Qualification_ReplacementTypeLanguage_Qualification_Replacement_DataItem) : sprintf('%s(%s)', gettype($language_Qualification_ReplacementTypeLanguage_Qualification_Replacement_DataItem), var_export($language_Qualification_ReplacementTypeLanguage_Qualification_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Language_Qualification_Replacement_Data property can only contain items of type \StructType\Language_Qualification_Profile_Replacement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Language_Qualification_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Language_Qualification_Profile_Replacement_DataType[] $language_Qualification_Replacement_Data
     * @return \StructType\Language_Qualification_ReplacementType
     */
    public function setLanguage_Qualification_Replacement_Data(array $language_Qualification_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($language_Qualification_Replacement_DataArrayErrorMessage = self::validateLanguage_Qualification_Replacement_DataForArrayConstraintsFromSetLanguage_Qualification_Replacement_Data($language_Qualification_Replacement_Data))) {
            throw new \InvalidArgumentException($language_Qualification_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Language_Qualification_Replacement_Data = $language_Qualification_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Language_Qualification_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Language_Qualification_Profile_Replacement_DataType $item
     * @return \StructType\Language_Qualification_ReplacementType
     */
    public function addToLanguage_Qualification_Replacement_Data(\StructType\Language_Qualification_Profile_Replacement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Language_Qualification_Profile_Replacement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Language_Qualification_Replacement_Data property can only contain items of type \StructType\Language_Qualification_Profile_Replacement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Language_Qualification_Replacement_Data[] = $item;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Language_Qualification_ReplacementType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
