<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Language_Profile_for_Job_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the language profile's information for a position.
 * @subpackage Structs
 */
class Language_Profile_for_Job_DataType extends AbstractStructBase
{
    /**
     * The Language_Reference
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier for a language.
     * - minOccurs: 0
     * @var \StructType\LanguageObjectType
     */
    public $Language_Reference;
    /**
     * The Language_Ability_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Language_Ability_DataType[]
     */
    public $Language_Ability_Data;
    /**
     * The Required
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the profile is required for this position.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Required;
    /**
     * The Qualification_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: The source (job profile or position) reference from which the qualification came from.
     * - minOccurs: 0
     * @var \StructType\Talent_Qualification_EnabledObjectType
     */
    public $Qualification_Source_Reference;
    /**
     * Constructor method for Language_Profile_for_Job_DataType
     * @uses Language_Profile_for_Job_DataType::setLanguage_Reference()
     * @uses Language_Profile_for_Job_DataType::setLanguage_Ability_Data()
     * @uses Language_Profile_for_Job_DataType::setRequired()
     * @uses Language_Profile_for_Job_DataType::setQualification_Source_Reference()
     * @param \StructType\LanguageObjectType $language_Reference
     * @param \StructType\Language_Ability_DataType[] $language_Ability_Data
     * @param bool $required
     * @param \StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference
     */
    public function __construct(\StructType\LanguageObjectType $language_Reference = null, array $language_Ability_Data = array(), $required = null, \StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference = null)
    {
        $this
            ->setLanguage_Reference($language_Reference)
            ->setLanguage_Ability_Data($language_Ability_Data)
            ->setRequired($required)
            ->setQualification_Source_Reference($qualification_Source_Reference);
    }
    /**
     * Get Language_Reference value
     * @return \StructType\LanguageObjectType|null
     */
    public function getLanguage_Reference()
    {
        return $this->Language_Reference;
    }
    /**
     * Set Language_Reference value
     * @param \StructType\LanguageObjectType $language_Reference
     * @return \StructType\Language_Profile_for_Job_DataType
     */
    public function setLanguage_Reference(\StructType\LanguageObjectType $language_Reference = null)
    {
        $this->Language_Reference = $language_Reference;
        return $this;
    }
    /**
     * Get Language_Ability_Data value
     * @return \StructType\Language_Ability_DataType[]|null
     */
    public function getLanguage_Ability_Data()
    {
        return $this->Language_Ability_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setLanguage_Ability_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLanguage_Ability_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLanguage_Ability_DataForArrayConstraintsFromSetLanguage_Ability_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $language_Profile_for_Job_DataTypeLanguage_Ability_DataItem) {
            // validation for constraint: itemType
            if (!$language_Profile_for_Job_DataTypeLanguage_Ability_DataItem instanceof \StructType\Language_Ability_DataType) {
                $invalidValues[] = is_object($language_Profile_for_Job_DataTypeLanguage_Ability_DataItem) ? get_class($language_Profile_for_Job_DataTypeLanguage_Ability_DataItem) : sprintf('%s(%s)', gettype($language_Profile_for_Job_DataTypeLanguage_Ability_DataItem), var_export($language_Profile_for_Job_DataTypeLanguage_Ability_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Language_Ability_Data property can only contain items of type \StructType\Language_Ability_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Language_Ability_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Language_Ability_DataType[] $language_Ability_Data
     * @return \StructType\Language_Profile_for_Job_DataType
     */
    public function setLanguage_Ability_Data(array $language_Ability_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($language_Ability_DataArrayErrorMessage = self::validateLanguage_Ability_DataForArrayConstraintsFromSetLanguage_Ability_Data($language_Ability_Data))) {
            throw new \InvalidArgumentException($language_Ability_DataArrayErrorMessage, __LINE__);
        }
        $this->Language_Ability_Data = $language_Ability_Data;
        return $this;
    }
    /**
     * Add item to Language_Ability_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Language_Ability_DataType $item
     * @return \StructType\Language_Profile_for_Job_DataType
     */
    public function addToLanguage_Ability_Data(\StructType\Language_Ability_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Language_Ability_DataType) {
            throw new \InvalidArgumentException(sprintf('The Language_Ability_Data property can only contain items of type \StructType\Language_Ability_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Language_Ability_Data[] = $item;
        return $this;
    }
    /**
     * Get Required value
     * @return bool|null
     */
    public function getRequired()
    {
        return $this->Required;
    }
    /**
     * Set Required value
     * @param bool $required
     * @return \StructType\Language_Profile_for_Job_DataType
     */
    public function setRequired($required = null)
    {
        // validation for constraint: boolean
        if (!is_null($required) && !is_bool($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($required, true), gettype($required)), __LINE__);
        }
        $this->Required = $required;
        return $this;
    }
    /**
     * Get Qualification_Source_Reference value
     * @return \StructType\Talent_Qualification_EnabledObjectType|null
     */
    public function getQualification_Source_Reference()
    {
        return $this->Qualification_Source_Reference;
    }
    /**
     * Set Qualification_Source_Reference value
     * @param \StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference
     * @return \StructType\Language_Profile_for_Job_DataType
     */
    public function setQualification_Source_Reference(\StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference = null)
    {
        $this->Qualification_Source_Reference = $qualification_Source_Reference;
        return $this;
    }
}
