<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Requisition_Organizations_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Containing element for the cost center and custom organizations related to the job requisition.
 * @subpackage Structs
 */
class Job_Requisition_Organizations_DataType extends AbstractStructBase
{
    /**
     * The Organization_Assignments_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Organization_Assignments_for_Job_Requisition_DataType[]
     */
    public $Organization_Assignments_Data;
    /**
     * Constructor method for Job_Requisition_Organizations_DataType
     * @uses Job_Requisition_Organizations_DataType::setOrganization_Assignments_Data()
     * @param \StructType\Organization_Assignments_for_Job_Requisition_DataType[] $organization_Assignments_Data
     */
    public function __construct(array $organization_Assignments_Data = array())
    {
        $this
            ->setOrganization_Assignments_Data($organization_Assignments_Data);
    }
    /**
     * Get Organization_Assignments_Data value
     * @return \StructType\Organization_Assignments_for_Job_Requisition_DataType[]|null
     */
    public function getOrganization_Assignments_Data()
    {
        return $this->Organization_Assignments_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setOrganization_Assignments_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrganization_Assignments_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrganization_Assignments_DataForArrayConstraintsFromSetOrganization_Assignments_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Requisition_Organizations_DataTypeOrganization_Assignments_DataItem) {
            // validation for constraint: itemType
            if (!$job_Requisition_Organizations_DataTypeOrganization_Assignments_DataItem instanceof \StructType\Organization_Assignments_for_Job_Requisition_DataType) {
                $invalidValues[] = is_object($job_Requisition_Organizations_DataTypeOrganization_Assignments_DataItem) ? get_class($job_Requisition_Organizations_DataTypeOrganization_Assignments_DataItem) : sprintf('%s(%s)', gettype($job_Requisition_Organizations_DataTypeOrganization_Assignments_DataItem), var_export($job_Requisition_Organizations_DataTypeOrganization_Assignments_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Organization_Assignments_Data property can only contain items of type \StructType\Organization_Assignments_for_Job_Requisition_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Organization_Assignments_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Organization_Assignments_for_Job_Requisition_DataType[] $organization_Assignments_Data
     * @return \StructType\Job_Requisition_Organizations_DataType
     */
    public function setOrganization_Assignments_Data(array $organization_Assignments_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($organization_Assignments_DataArrayErrorMessage = self::validateOrganization_Assignments_DataForArrayConstraintsFromSetOrganization_Assignments_Data($organization_Assignments_Data))) {
            throw new \InvalidArgumentException($organization_Assignments_DataArrayErrorMessage, __LINE__);
        }
        $this->Organization_Assignments_Data = $organization_Assignments_Data;
        return $this;
    }
    /**
     * Add item to Organization_Assignments_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Organization_Assignments_for_Job_Requisition_DataType $item
     * @return \StructType\Job_Requisition_Organizations_DataType
     */
    public function addToOrganization_Assignments_Data(\StructType\Organization_Assignments_for_Job_Requisition_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Organization_Assignments_for_Job_Requisition_DataType) {
            throw new \InvalidArgumentException(sprintf('The Organization_Assignments_Data property can only contain items of type \StructType\Organization_Assignments_for_Job_Requisition_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Organization_Assignments_Data[] = $item;
        return $this;
    }
}
