<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Requisition_Interview_SessionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains delete attribute, which marks a job requisition interview session for delete, a reference to a job requisition interview session, and job requisition interview session data.
 * @subpackage Structs
 */
class Job_Requisition_Interview_SessionType extends AbstractStructBase
{
    /**
     * The Job_Requisition_Interview_Session_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a job requisition interview session.
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_Interview_SessionObjectType
     */
    public $Job_Requisition_Interview_Session_Reference;
    /**
     * The Job_Requisition_Interview_Session_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains the reference id, order, interviewers, duration, interview type, alternate interviewers, and comment data for the job requisition interview team session.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_Interview_Team_Session_DataType[]
     */
    public $Job_Requisition_Interview_Session_Data;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the job requisition interview session reference will be deleted.
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Job_Requisition_Interview_SessionType
     * @uses Job_Requisition_Interview_SessionType::setJob_Requisition_Interview_Session_Reference()
     * @uses Job_Requisition_Interview_SessionType::setJob_Requisition_Interview_Session_Data()
     * @uses Job_Requisition_Interview_SessionType::setDelete()
     * @param \StructType\Job_Requisition_Interview_SessionObjectType $job_Requisition_Interview_Session_Reference
     * @param \StructType\Job_Requisition_Interview_Team_Session_DataType[] $job_Requisition_Interview_Session_Data
     * @param bool $delete
     */
    public function __construct(\StructType\Job_Requisition_Interview_SessionObjectType $job_Requisition_Interview_Session_Reference = null, array $job_Requisition_Interview_Session_Data = array(), $delete = null)
    {
        $this
            ->setJob_Requisition_Interview_Session_Reference($job_Requisition_Interview_Session_Reference)
            ->setJob_Requisition_Interview_Session_Data($job_Requisition_Interview_Session_Data)
            ->setDelete($delete);
    }
    /**
     * Get Job_Requisition_Interview_Session_Reference value
     * @return \StructType\Job_Requisition_Interview_SessionObjectType|null
     */
    public function getJob_Requisition_Interview_Session_Reference()
    {
        return $this->Job_Requisition_Interview_Session_Reference;
    }
    /**
     * Set Job_Requisition_Interview_Session_Reference value
     * @param \StructType\Job_Requisition_Interview_SessionObjectType $job_Requisition_Interview_Session_Reference
     * @return \StructType\Job_Requisition_Interview_SessionType
     */
    public function setJob_Requisition_Interview_Session_Reference(\StructType\Job_Requisition_Interview_SessionObjectType $job_Requisition_Interview_Session_Reference = null)
    {
        $this->Job_Requisition_Interview_Session_Reference = $job_Requisition_Interview_Session_Reference;
        return $this;
    }
    /**
     * Get Job_Requisition_Interview_Session_Data value
     * @return \StructType\Job_Requisition_Interview_Team_Session_DataType[]|null
     */
    public function getJob_Requisition_Interview_Session_Data()
    {
        return $this->Job_Requisition_Interview_Session_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Requisition_Interview_Session_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Requisition_Interview_Session_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Requisition_Interview_Session_DataForArrayConstraintsFromSetJob_Requisition_Interview_Session_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Requisition_Interview_SessionTypeJob_Requisition_Interview_Session_DataItem) {
            // validation for constraint: itemType
            if (!$job_Requisition_Interview_SessionTypeJob_Requisition_Interview_Session_DataItem instanceof \StructType\Job_Requisition_Interview_Team_Session_DataType) {
                $invalidValues[] = is_object($job_Requisition_Interview_SessionTypeJob_Requisition_Interview_Session_DataItem) ? get_class($job_Requisition_Interview_SessionTypeJob_Requisition_Interview_Session_DataItem) : sprintf('%s(%s)', gettype($job_Requisition_Interview_SessionTypeJob_Requisition_Interview_Session_DataItem), var_export($job_Requisition_Interview_SessionTypeJob_Requisition_Interview_Session_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Requisition_Interview_Session_Data property can only contain items of type \StructType\Job_Requisition_Interview_Team_Session_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Requisition_Interview_Session_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Requisition_Interview_Team_Session_DataType[] $job_Requisition_Interview_Session_Data
     * @return \StructType\Job_Requisition_Interview_SessionType
     */
    public function setJob_Requisition_Interview_Session_Data(array $job_Requisition_Interview_Session_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Requisition_Interview_Session_DataArrayErrorMessage = self::validateJob_Requisition_Interview_Session_DataForArrayConstraintsFromSetJob_Requisition_Interview_Session_Data($job_Requisition_Interview_Session_Data))) {
            throw new \InvalidArgumentException($job_Requisition_Interview_Session_DataArrayErrorMessage, __LINE__);
        }
        $this->Job_Requisition_Interview_Session_Data = $job_Requisition_Interview_Session_Data;
        return $this;
    }
    /**
     * Add item to Job_Requisition_Interview_Session_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Requisition_Interview_Team_Session_DataType $item
     * @return \StructType\Job_Requisition_Interview_SessionType
     */
    public function addToJob_Requisition_Interview_Session_Data(\StructType\Job_Requisition_Interview_Team_Session_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Requisition_Interview_Team_Session_DataType) {
            throw new \InvalidArgumentException(sprintf('The Job_Requisition_Interview_Session_Data property can only contain items of type \StructType\Job_Requisition_Interview_Team_Session_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Requisition_Interview_Session_Data[] = $item;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Job_Requisition_Interview_SessionType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
