<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Requisition_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element for a Job Requisition
 * @subpackage Structs
 */
class Job_Requisition_DataType extends AbstractStructBase
{
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier used to reference a job requisition.
     * - minOccurs: 0
     * @var \StructType\Job_RequisitionObjectType
     */
    public $Job_Requisition_Reference;
    /**
     * The Job_Requisition_ID
     * Meta information extracted from the WSDL
     * - documentation: The ID of the Job Requisition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Requisition_ID;
    /**
     * The Job_Requisition_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Job Requisition Status. The effective job requisition for a position restriction may have a status of Open or Frozen. If it is Frozen, then the position cannot be filled.
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_StatusObjectType
     */
    public $Job_Requisition_Status_Reference;
    /**
     * The Job_Posting_Title
     * Meta information extracted from the WSDL
     * - documentation: The Job Posting Title of the Job Requisition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Posting_Title;
    /**
     * The Recruiting_Instruction_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Recruiting_Instruction_DataType
     */
    public $Recruiting_Instruction_Data;
    /**
     * The Academic_Tenure_Eligible
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Job Requisition is for a position that is academic tenure eligible.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Academic_Tenure_Eligible;
    /**
     * The Number_of_Openings
     * Meta information extracted from the WSDL
     * - documentation: Number of openings associated with the job requisition. There can be no more than 100 positions allocated for a Job Requisition for a Position Management Organization. | The number of positions made available by the job requisition.
     * This number can only be greater than 1 for job requisitions created with the "new position" option. A value of greater than 1 was only allowed starting in W16. This element must be omitted for the Create Job Requisition and Edit Job Requisition
     * operations. | Number of openings associated with the job requisition
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 7
     * @var float
     */
    public $Number_of_Openings;
    /**
     * The Job_Description_Summary
     * Meta information extracted from the WSDL
     * - documentation: The job description summary (plain text) for the job requisition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Description_Summary;
    /**
     * The Justification
     * Meta information extracted from the WSDL
     * - documentation: The Justification for the Job Requisition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Justification;
    /**
     * The Job_Requisition_Attachments
     * Meta information extracted from the WSDL
     * - documentation: File Attachments for the Job Requisition
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_AttachmentsType
     */
    public $Job_Requisition_Attachments;
    /**
     * The Recruiting_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: The Recruiting Start Date for the Job Requisition. Recruiting cannot be done for the position prior to this date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Recruiting_Start_Date;
    /**
     * The Target_Hire_Date
     * Meta information extracted from the WSDL
     * - documentation: The Target Hire Date for the Job Requisition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Target_Hire_Date;
    /**
     * The Target_End_Date
     * Meta information extracted from the WSDL
     * - documentation: The Target End Date for the Job Requisition is required for fixed term employees and contingent worker sub-types that are specified as requiring cost information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Target_End_Date;
    /**
     * The Job_Profile_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Job Profile for the Job Requisition.
     * - minOccurs: 0
     * @var \StructType\Job_ProfileObjectType
     */
    public $Job_Profile_Reference;
    /**
     * The Worker_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Worker Type for the Job Requisition.
     * - minOccurs: 0
     * @var \StructType\Worker_TypeObjectType
     */
    public $Worker_Type_Reference;
    /**
     * The Position_Worker_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Worker Sub-Type for the Job Requisition.
     * - minOccurs: 0
     * @var \StructType\Position_Worker_TypeObjectType
     */
    public $Position_Worker_Type_Reference;
    /**
     * The Primary_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Location must be of usage Business Site. | The Primary Location for the Job Requisition.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Primary_Location_Reference;
    /**
     * The Additional_Locations_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Additional Location(s) for the Job Requisition.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LocationObjectType[]
     */
    public $Additional_Locations_Reference;
    /**
     * The Position_Time_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Position Time Type for the Job Requisition.
     * - minOccurs: 0
     * @var \StructType\Position_Time_TypeObjectType
     */
    public $Position_Time_Type_Reference;
    /**
     * The Scheduled_Weekly_Hours
     * Meta information extracted from the WSDL
     * - documentation: The Schedule Hours for the Job Requisition. | The scheduled weekly hours for the job requisition. If empty, Workday automatically populates this value from the position restrictions. | The scheduled weekly hours associated with the
     * offer
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 14
     * @var float
     */
    public $Scheduled_Weekly_Hours;
    /**
     * The Work_Shift_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Work Shift for the Job Requisition.
     * - minOccurs: 0
     * @var \StructType\Work_ShiftObjectType
     */
    public $Work_Shift_Reference;
    /**
     * The Spotlight_Job
     * Meta information extracted from the WSDL
     * - documentation: If Y, indicates that this is a highlighted job requisition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Spotlight_Job;
    /**
     * The Qualification_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing the qualification data for the Job Requisition.
     * - minOccurs: 0
     * @var \StructType\Qualification_Data_for_Position_Restriction_or_Job_ProfileType
     */
    public $Qualification_Data;
    /**
     * The Replacement_for_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: If the job requisition exists with the purpose of replacing a worker, enter the reference worker.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Replacement_for_Worker_Reference;
    /**
     * Constructor method for Job_Requisition_DataType
     * @uses Job_Requisition_DataType::setJob_Requisition_Reference()
     * @uses Job_Requisition_DataType::setJob_Requisition_ID()
     * @uses Job_Requisition_DataType::setJob_Requisition_Status_Reference()
     * @uses Job_Requisition_DataType::setJob_Posting_Title()
     * @uses Job_Requisition_DataType::setRecruiting_Instruction_Data()
     * @uses Job_Requisition_DataType::setAcademic_Tenure_Eligible()
     * @uses Job_Requisition_DataType::setNumber_of_Openings()
     * @uses Job_Requisition_DataType::setJob_Description_Summary()
     * @uses Job_Requisition_DataType::setJustification()
     * @uses Job_Requisition_DataType::setJob_Requisition_Attachments()
     * @uses Job_Requisition_DataType::setRecruiting_Start_Date()
     * @uses Job_Requisition_DataType::setTarget_Hire_Date()
     * @uses Job_Requisition_DataType::setTarget_End_Date()
     * @uses Job_Requisition_DataType::setJob_Profile_Reference()
     * @uses Job_Requisition_DataType::setWorker_Type_Reference()
     * @uses Job_Requisition_DataType::setPosition_Worker_Type_Reference()
     * @uses Job_Requisition_DataType::setPrimary_Location_Reference()
     * @uses Job_Requisition_DataType::setAdditional_Locations_Reference()
     * @uses Job_Requisition_DataType::setPosition_Time_Type_Reference()
     * @uses Job_Requisition_DataType::setScheduled_Weekly_Hours()
     * @uses Job_Requisition_DataType::setWork_Shift_Reference()
     * @uses Job_Requisition_DataType::setSpotlight_Job()
     * @uses Job_Requisition_DataType::setQualification_Data()
     * @uses Job_Requisition_DataType::setReplacement_for_Worker_Reference()
     * @param \StructType\Job_RequisitionObjectType $job_Requisition_Reference
     * @param string $job_Requisition_ID
     * @param \StructType\Job_Requisition_StatusObjectType $job_Requisition_Status_Reference
     * @param string $job_Posting_Title
     * @param \StructType\Recruiting_Instruction_DataType $recruiting_Instruction_Data
     * @param bool $academic_Tenure_Eligible
     * @param float $number_of_Openings
     * @param string $job_Description_Summary
     * @param string $justification
     * @param \StructType\Job_Requisition_AttachmentsType $job_Requisition_Attachments
     * @param string $recruiting_Start_Date
     * @param string $target_Hire_Date
     * @param string $target_End_Date
     * @param \StructType\Job_ProfileObjectType $job_Profile_Reference
     * @param \StructType\Worker_TypeObjectType $worker_Type_Reference
     * @param \StructType\Position_Worker_TypeObjectType $position_Worker_Type_Reference
     * @param \StructType\LocationObjectType $primary_Location_Reference
     * @param \StructType\LocationObjectType[] $additional_Locations_Reference
     * @param \StructType\Position_Time_TypeObjectType $position_Time_Type_Reference
     * @param float $scheduled_Weekly_Hours
     * @param \StructType\Work_ShiftObjectType $work_Shift_Reference
     * @param bool $spotlight_Job
     * @param \StructType\Qualification_Data_for_Position_Restriction_or_Job_ProfileType $qualification_Data
     * @param \StructType\WorkerObjectType $replacement_for_Worker_Reference
     */
    public function __construct(\StructType\Job_RequisitionObjectType $job_Requisition_Reference = null, $job_Requisition_ID = null, \StructType\Job_Requisition_StatusObjectType $job_Requisition_Status_Reference = null, $job_Posting_Title = null, \StructType\Recruiting_Instruction_DataType $recruiting_Instruction_Data = null, $academic_Tenure_Eligible = null, $number_of_Openings = null, $job_Description_Summary = null, $justification = null, \StructType\Job_Requisition_AttachmentsType $job_Requisition_Attachments = null, $recruiting_Start_Date = null, $target_Hire_Date = null, $target_End_Date = null, \StructType\Job_ProfileObjectType $job_Profile_Reference = null, \StructType\Worker_TypeObjectType $worker_Type_Reference = null, \StructType\Position_Worker_TypeObjectType $position_Worker_Type_Reference = null, \StructType\LocationObjectType $primary_Location_Reference = null, array $additional_Locations_Reference = array(), \StructType\Position_Time_TypeObjectType $position_Time_Type_Reference = null, $scheduled_Weekly_Hours = null, \StructType\Work_ShiftObjectType $work_Shift_Reference = null, $spotlight_Job = null, \StructType\Qualification_Data_for_Position_Restriction_or_Job_ProfileType $qualification_Data = null, \StructType\WorkerObjectType $replacement_for_Worker_Reference = null)
    {
        $this
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setJob_Requisition_ID($job_Requisition_ID)
            ->setJob_Requisition_Status_Reference($job_Requisition_Status_Reference)
            ->setJob_Posting_Title($job_Posting_Title)
            ->setRecruiting_Instruction_Data($recruiting_Instruction_Data)
            ->setAcademic_Tenure_Eligible($academic_Tenure_Eligible)
            ->setNumber_of_Openings($number_of_Openings)
            ->setJob_Description_Summary($job_Description_Summary)
            ->setJustification($justification)
            ->setJob_Requisition_Attachments($job_Requisition_Attachments)
            ->setRecruiting_Start_Date($recruiting_Start_Date)
            ->setTarget_Hire_Date($target_Hire_Date)
            ->setTarget_End_Date($target_End_Date)
            ->setJob_Profile_Reference($job_Profile_Reference)
            ->setWorker_Type_Reference($worker_Type_Reference)
            ->setPosition_Worker_Type_Reference($position_Worker_Type_Reference)
            ->setPrimary_Location_Reference($primary_Location_Reference)
            ->setAdditional_Locations_Reference($additional_Locations_Reference)
            ->setPosition_Time_Type_Reference($position_Time_Type_Reference)
            ->setScheduled_Weekly_Hours($scheduled_Weekly_Hours)
            ->setWork_Shift_Reference($work_Shift_Reference)
            ->setSpotlight_Job($spotlight_Job)
            ->setQualification_Data($qualification_Data)
            ->setReplacement_for_Worker_Reference($replacement_for_Worker_Reference);
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_RequisitionObjectType|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * Set Job_Requisition_Reference value
     * @param \StructType\Job_RequisitionObjectType $job_Requisition_Reference
     * @return \StructType\Job_Requisition_DataType
     */
    public function setJob_Requisition_Reference(\StructType\Job_RequisitionObjectType $job_Requisition_Reference = null)
    {
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Get Job_Requisition_ID value
     * @return string|null
     */
    public function getJob_Requisition_ID()
    {
        return $this->Job_Requisition_ID;
    }
    /**
     * Set Job_Requisition_ID value
     * @param string $job_Requisition_ID
     * @return \StructType\Job_Requisition_DataType
     */
    public function setJob_Requisition_ID($job_Requisition_ID = null)
    {
        // validation for constraint: string
        if (!is_null($job_Requisition_ID) && !is_string($job_Requisition_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Requisition_ID, true), gettype($job_Requisition_ID)), __LINE__);
        }
        $this->Job_Requisition_ID = $job_Requisition_ID;
        return $this;
    }
    /**
     * Get Job_Requisition_Status_Reference value
     * @return \StructType\Job_Requisition_StatusObjectType|null
     */
    public function getJob_Requisition_Status_Reference()
    {
        return $this->Job_Requisition_Status_Reference;
    }
    /**
     * Set Job_Requisition_Status_Reference value
     * @param \StructType\Job_Requisition_StatusObjectType $job_Requisition_Status_Reference
     * @return \StructType\Job_Requisition_DataType
     */
    public function setJob_Requisition_Status_Reference(\StructType\Job_Requisition_StatusObjectType $job_Requisition_Status_Reference = null)
    {
        $this->Job_Requisition_Status_Reference = $job_Requisition_Status_Reference;
        return $this;
    }
    /**
     * Get Job_Posting_Title value
     * @return string|null
     */
    public function getJob_Posting_Title()
    {
        return $this->Job_Posting_Title;
    }
    /**
     * Set Job_Posting_Title value
     * @param string $job_Posting_Title
     * @return \StructType\Job_Requisition_DataType
     */
    public function setJob_Posting_Title($job_Posting_Title = null)
    {
        // validation for constraint: string
        if (!is_null($job_Posting_Title) && !is_string($job_Posting_Title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Posting_Title, true), gettype($job_Posting_Title)), __LINE__);
        }
        $this->Job_Posting_Title = $job_Posting_Title;
        return $this;
    }
    /**
     * Get Recruiting_Instruction_Data value
     * @return \StructType\Recruiting_Instruction_DataType|null
     */
    public function getRecruiting_Instruction_Data()
    {
        return $this->Recruiting_Instruction_Data;
    }
    /**
     * Set Recruiting_Instruction_Data value
     * @param \StructType\Recruiting_Instruction_DataType $recruiting_Instruction_Data
     * @return \StructType\Job_Requisition_DataType
     */
    public function setRecruiting_Instruction_Data(\StructType\Recruiting_Instruction_DataType $recruiting_Instruction_Data = null)
    {
        $this->Recruiting_Instruction_Data = $recruiting_Instruction_Data;
        return $this;
    }
    /**
     * Get Academic_Tenure_Eligible value
     * @return bool|null
     */
    public function getAcademic_Tenure_Eligible()
    {
        return $this->Academic_Tenure_Eligible;
    }
    /**
     * Set Academic_Tenure_Eligible value
     * @param bool $academic_Tenure_Eligible
     * @return \StructType\Job_Requisition_DataType
     */
    public function setAcademic_Tenure_Eligible($academic_Tenure_Eligible = null)
    {
        // validation for constraint: boolean
        if (!is_null($academic_Tenure_Eligible) && !is_bool($academic_Tenure_Eligible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($academic_Tenure_Eligible, true), gettype($academic_Tenure_Eligible)), __LINE__);
        }
        $this->Academic_Tenure_Eligible = $academic_Tenure_Eligible;
        return $this;
    }
    /**
     * Get Number_of_Openings value
     * @return float|null
     */
    public function getNumber_of_Openings()
    {
        return $this->Number_of_Openings;
    }
    /**
     * Set Number_of_Openings value
     * @param float $number_of_Openings
     * @return \StructType\Job_Requisition_DataType
     */
    public function setNumber_of_Openings($number_of_Openings = null)
    {
        // validation for constraint: float
        if (!is_null($number_of_Openings) && !(is_float($number_of_Openings) || is_numeric($number_of_Openings))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number_of_Openings, true), gettype($number_of_Openings)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($number_of_Openings) && mb_strlen(mb_substr($number_of_Openings, false !== mb_strpos($number_of_Openings, '.') ? mb_strpos($number_of_Openings, '.') + 1 : mb_strlen($number_of_Openings))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($number_of_Openings, true), mb_strlen(mb_substr($number_of_Openings, mb_strpos($number_of_Openings, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($number_of_Openings) && $number_of_Openings < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($number_of_Openings, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($number_of_Openings) && mb_strlen(preg_replace('/(\D)/', '', $number_of_Openings)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($number_of_Openings, true), mb_strlen(preg_replace('/(\D)/', '', $number_of_Openings))), __LINE__);
        }
        $this->Number_of_Openings = $number_of_Openings;
        return $this;
    }
    /**
     * Get Job_Description_Summary value
     * @return string|null
     */
    public function getJob_Description_Summary()
    {
        return $this->Job_Description_Summary;
    }
    /**
     * Set Job_Description_Summary value
     * @param string $job_Description_Summary
     * @return \StructType\Job_Requisition_DataType
     */
    public function setJob_Description_Summary($job_Description_Summary = null)
    {
        // validation for constraint: string
        if (!is_null($job_Description_Summary) && !is_string($job_Description_Summary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Description_Summary, true), gettype($job_Description_Summary)), __LINE__);
        }
        $this->Job_Description_Summary = $job_Description_Summary;
        return $this;
    }
    /**
     * Get Justification value
     * @return string|null
     */
    public function getJustification()
    {
        return $this->Justification;
    }
    /**
     * Set Justification value
     * @param string $justification
     * @return \StructType\Job_Requisition_DataType
     */
    public function setJustification($justification = null)
    {
        // validation for constraint: string
        if (!is_null($justification) && !is_string($justification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($justification, true), gettype($justification)), __LINE__);
        }
        $this->Justification = $justification;
        return $this;
    }
    /**
     * Get Job_Requisition_Attachments value
     * @return \StructType\Job_Requisition_AttachmentsType|null
     */
    public function getJob_Requisition_Attachments()
    {
        return $this->Job_Requisition_Attachments;
    }
    /**
     * Set Job_Requisition_Attachments value
     * @param \StructType\Job_Requisition_AttachmentsType $job_Requisition_Attachments
     * @return \StructType\Job_Requisition_DataType
     */
    public function setJob_Requisition_Attachments(\StructType\Job_Requisition_AttachmentsType $job_Requisition_Attachments = null)
    {
        $this->Job_Requisition_Attachments = $job_Requisition_Attachments;
        return $this;
    }
    /**
     * Get Recruiting_Start_Date value
     * @return string|null
     */
    public function getRecruiting_Start_Date()
    {
        return $this->Recruiting_Start_Date;
    }
    /**
     * Set Recruiting_Start_Date value
     * @param string $recruiting_Start_Date
     * @return \StructType\Job_Requisition_DataType
     */
    public function setRecruiting_Start_Date($recruiting_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($recruiting_Start_Date) && !is_string($recruiting_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recruiting_Start_Date, true), gettype($recruiting_Start_Date)), __LINE__);
        }
        $this->Recruiting_Start_Date = $recruiting_Start_Date;
        return $this;
    }
    /**
     * Get Target_Hire_Date value
     * @return string|null
     */
    public function getTarget_Hire_Date()
    {
        return $this->Target_Hire_Date;
    }
    /**
     * Set Target_Hire_Date value
     * @param string $target_Hire_Date
     * @return \StructType\Job_Requisition_DataType
     */
    public function setTarget_Hire_Date($target_Hire_Date = null)
    {
        // validation for constraint: string
        if (!is_null($target_Hire_Date) && !is_string($target_Hire_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target_Hire_Date, true), gettype($target_Hire_Date)), __LINE__);
        }
        $this->Target_Hire_Date = $target_Hire_Date;
        return $this;
    }
    /**
     * Get Target_End_Date value
     * @return string|null
     */
    public function getTarget_End_Date()
    {
        return $this->Target_End_Date;
    }
    /**
     * Set Target_End_Date value
     * @param string $target_End_Date
     * @return \StructType\Job_Requisition_DataType
     */
    public function setTarget_End_Date($target_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($target_End_Date) && !is_string($target_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target_End_Date, true), gettype($target_End_Date)), __LINE__);
        }
        $this->Target_End_Date = $target_End_Date;
        return $this;
    }
    /**
     * Get Job_Profile_Reference value
     * @return \StructType\Job_ProfileObjectType|null
     */
    public function getJob_Profile_Reference()
    {
        return $this->Job_Profile_Reference;
    }
    /**
     * Set Job_Profile_Reference value
     * @param \StructType\Job_ProfileObjectType $job_Profile_Reference
     * @return \StructType\Job_Requisition_DataType
     */
    public function setJob_Profile_Reference(\StructType\Job_ProfileObjectType $job_Profile_Reference = null)
    {
        $this->Job_Profile_Reference = $job_Profile_Reference;
        return $this;
    }
    /**
     * Get Worker_Type_Reference value
     * @return \StructType\Worker_TypeObjectType|null
     */
    public function getWorker_Type_Reference()
    {
        return $this->Worker_Type_Reference;
    }
    /**
     * Set Worker_Type_Reference value
     * @param \StructType\Worker_TypeObjectType $worker_Type_Reference
     * @return \StructType\Job_Requisition_DataType
     */
    public function setWorker_Type_Reference(\StructType\Worker_TypeObjectType $worker_Type_Reference = null)
    {
        $this->Worker_Type_Reference = $worker_Type_Reference;
        return $this;
    }
    /**
     * Get Position_Worker_Type_Reference value
     * @return \StructType\Position_Worker_TypeObjectType|null
     */
    public function getPosition_Worker_Type_Reference()
    {
        return $this->Position_Worker_Type_Reference;
    }
    /**
     * Set Position_Worker_Type_Reference value
     * @param \StructType\Position_Worker_TypeObjectType $position_Worker_Type_Reference
     * @return \StructType\Job_Requisition_DataType
     */
    public function setPosition_Worker_Type_Reference(\StructType\Position_Worker_TypeObjectType $position_Worker_Type_Reference = null)
    {
        $this->Position_Worker_Type_Reference = $position_Worker_Type_Reference;
        return $this;
    }
    /**
     * Get Primary_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getPrimary_Location_Reference()
    {
        return $this->Primary_Location_Reference;
    }
    /**
     * Set Primary_Location_Reference value
     * @param \StructType\LocationObjectType $primary_Location_Reference
     * @return \StructType\Job_Requisition_DataType
     */
    public function setPrimary_Location_Reference(\StructType\LocationObjectType $primary_Location_Reference = null)
    {
        $this->Primary_Location_Reference = $primary_Location_Reference;
        return $this;
    }
    /**
     * Get Additional_Locations_Reference value
     * @return \StructType\LocationObjectType[]|null
     */
    public function getAdditional_Locations_Reference()
    {
        return $this->Additional_Locations_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditional_Locations_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditional_Locations_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditional_Locations_ReferenceForArrayConstraintsFromSetAdditional_Locations_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Requisition_DataTypeAdditional_Locations_ReferenceItem) {
            // validation for constraint: itemType
            if (!$job_Requisition_DataTypeAdditional_Locations_ReferenceItem instanceof \StructType\LocationObjectType) {
                $invalidValues[] = is_object($job_Requisition_DataTypeAdditional_Locations_ReferenceItem) ? get_class($job_Requisition_DataTypeAdditional_Locations_ReferenceItem) : sprintf('%s(%s)', gettype($job_Requisition_DataTypeAdditional_Locations_ReferenceItem), var_export($job_Requisition_DataTypeAdditional_Locations_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Additional_Locations_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Additional_Locations_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType[] $additional_Locations_Reference
     * @return \StructType\Job_Requisition_DataType
     */
    public function setAdditional_Locations_Reference(array $additional_Locations_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($additional_Locations_ReferenceArrayErrorMessage = self::validateAdditional_Locations_ReferenceForArrayConstraintsFromSetAdditional_Locations_Reference($additional_Locations_Reference))) {
            throw new \InvalidArgumentException($additional_Locations_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Additional_Locations_Reference = $additional_Locations_Reference;
        return $this;
    }
    /**
     * Add item to Additional_Locations_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType $item
     * @return \StructType\Job_Requisition_DataType
     */
    public function addToAdditional_Locations_Reference(\StructType\LocationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Additional_Locations_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Additional_Locations_Reference[] = $item;
        return $this;
    }
    /**
     * Get Position_Time_Type_Reference value
     * @return \StructType\Position_Time_TypeObjectType|null
     */
    public function getPosition_Time_Type_Reference()
    {
        return $this->Position_Time_Type_Reference;
    }
    /**
     * Set Position_Time_Type_Reference value
     * @param \StructType\Position_Time_TypeObjectType $position_Time_Type_Reference
     * @return \StructType\Job_Requisition_DataType
     */
    public function setPosition_Time_Type_Reference(\StructType\Position_Time_TypeObjectType $position_Time_Type_Reference = null)
    {
        $this->Position_Time_Type_Reference = $position_Time_Type_Reference;
        return $this;
    }
    /**
     * Get Scheduled_Weekly_Hours value
     * @return float|null
     */
    public function getScheduled_Weekly_Hours()
    {
        return $this->Scheduled_Weekly_Hours;
    }
    /**
     * Set Scheduled_Weekly_Hours value
     * @param float $scheduled_Weekly_Hours
     * @return \StructType\Job_Requisition_DataType
     */
    public function setScheduled_Weekly_Hours($scheduled_Weekly_Hours = null)
    {
        // validation for constraint: float
        if (!is_null($scheduled_Weekly_Hours) && !(is_float($scheduled_Weekly_Hours) || is_numeric($scheduled_Weekly_Hours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($scheduled_Weekly_Hours, true), gettype($scheduled_Weekly_Hours)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($scheduled_Weekly_Hours) && mb_strlen(mb_substr($scheduled_Weekly_Hours, false !== mb_strpos($scheduled_Weekly_Hours, '.') ? mb_strpos($scheduled_Weekly_Hours, '.') + 1 : mb_strlen($scheduled_Weekly_Hours))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($scheduled_Weekly_Hours, true), mb_strlen(mb_substr($scheduled_Weekly_Hours, mb_strpos($scheduled_Weekly_Hours, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(14)
        if (!is_null($scheduled_Weekly_Hours) && mb_strlen(preg_replace('/(\D)/', '', $scheduled_Weekly_Hours)) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 14 digits, "%d" given', var_export($scheduled_Weekly_Hours, true), mb_strlen(preg_replace('/(\D)/', '', $scheduled_Weekly_Hours))), __LINE__);
        }
        $this->Scheduled_Weekly_Hours = $scheduled_Weekly_Hours;
        return $this;
    }
    /**
     * Get Work_Shift_Reference value
     * @return \StructType\Work_ShiftObjectType|null
     */
    public function getWork_Shift_Reference()
    {
        return $this->Work_Shift_Reference;
    }
    /**
     * Set Work_Shift_Reference value
     * @param \StructType\Work_ShiftObjectType $work_Shift_Reference
     * @return \StructType\Job_Requisition_DataType
     */
    public function setWork_Shift_Reference(\StructType\Work_ShiftObjectType $work_Shift_Reference = null)
    {
        $this->Work_Shift_Reference = $work_Shift_Reference;
        return $this;
    }
    /**
     * Get Spotlight_Job value
     * @return bool|null
     */
    public function getSpotlight_Job()
    {
        return $this->Spotlight_Job;
    }
    /**
     * Set Spotlight_Job value
     * @param bool $spotlight_Job
     * @return \StructType\Job_Requisition_DataType
     */
    public function setSpotlight_Job($spotlight_Job = null)
    {
        // validation for constraint: boolean
        if (!is_null($spotlight_Job) && !is_bool($spotlight_Job)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($spotlight_Job, true), gettype($spotlight_Job)), __LINE__);
        }
        $this->Spotlight_Job = $spotlight_Job;
        return $this;
    }
    /**
     * Get Qualification_Data value
     * @return \StructType\Qualification_Data_for_Position_Restriction_or_Job_ProfileType|null
     */
    public function getQualification_Data()
    {
        return $this->Qualification_Data;
    }
    /**
     * Set Qualification_Data value
     * @param \StructType\Qualification_Data_for_Position_Restriction_or_Job_ProfileType $qualification_Data
     * @return \StructType\Job_Requisition_DataType
     */
    public function setQualification_Data(\StructType\Qualification_Data_for_Position_Restriction_or_Job_ProfileType $qualification_Data = null)
    {
        $this->Qualification_Data = $qualification_Data;
        return $this;
    }
    /**
     * Get Replacement_for_Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getReplacement_for_Worker_Reference()
    {
        return $this->Replacement_for_Worker_Reference;
    }
    /**
     * Set Replacement_for_Worker_Reference value
     * @param \StructType\WorkerObjectType $replacement_for_Worker_Reference
     * @return \StructType\Job_Requisition_DataType
     */
    public function setReplacement_for_Worker_Reference(\StructType\WorkerObjectType $replacement_for_Worker_Reference = null)
    {
        $this->Replacement_for_Worker_Reference = $replacement_for_Worker_Reference;
        return $this;
    }
}
