<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Posting_Site_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Get Job Posting Site via the Reference ID
 * @subpackage Structs
 */
class Job_Posting_Site_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Job_Posting_Site_Reference
     * Meta information extracted from the WSDL
     * - documentation: Select a single Job Posting Site using its Reference ID
     * - maxOccurs: unbounded
     * @var \StructType\Job_Posting_SiteObjectType[]
     */
    public $Job_Posting_Site_Reference;
    /**
     * Constructor method for Job_Posting_Site_Request_ReferencesType
     * @uses Job_Posting_Site_Request_ReferencesType::setJob_Posting_Site_Reference()
     * @param \StructType\Job_Posting_SiteObjectType[] $job_Posting_Site_Reference
     */
    public function __construct(array $job_Posting_Site_Reference = array())
    {
        $this
            ->setJob_Posting_Site_Reference($job_Posting_Site_Reference);
    }
    /**
     * Get Job_Posting_Site_Reference value
     * @return \StructType\Job_Posting_SiteObjectType[]|null
     */
    public function getJob_Posting_Site_Reference()
    {
        return $this->Job_Posting_Site_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Posting_Site_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Posting_Site_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Posting_Site_ReferenceForArrayConstraintsFromSetJob_Posting_Site_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Posting_Site_Request_ReferencesTypeJob_Posting_Site_ReferenceItem) {
            // validation for constraint: itemType
            if (!$job_Posting_Site_Request_ReferencesTypeJob_Posting_Site_ReferenceItem instanceof \StructType\Job_Posting_SiteObjectType) {
                $invalidValues[] = is_object($job_Posting_Site_Request_ReferencesTypeJob_Posting_Site_ReferenceItem) ? get_class($job_Posting_Site_Request_ReferencesTypeJob_Posting_Site_ReferenceItem) : sprintf('%s(%s)', gettype($job_Posting_Site_Request_ReferencesTypeJob_Posting_Site_ReferenceItem), var_export($job_Posting_Site_Request_ReferencesTypeJob_Posting_Site_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Posting_Site_Reference property can only contain items of type \StructType\Job_Posting_SiteObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Posting_Site_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Posting_SiteObjectType[] $job_Posting_Site_Reference
     * @return \StructType\Job_Posting_Site_Request_ReferencesType
     */
    public function setJob_Posting_Site_Reference(array $job_Posting_Site_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Posting_Site_ReferenceArrayErrorMessage = self::validateJob_Posting_Site_ReferenceForArrayConstraintsFromSetJob_Posting_Site_Reference($job_Posting_Site_Reference))) {
            throw new \InvalidArgumentException($job_Posting_Site_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Job_Posting_Site_Reference = $job_Posting_Site_Reference;
        return $this;
    }
    /**
     * Add item to Job_Posting_Site_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Posting_SiteObjectType $item
     * @return \StructType\Job_Posting_Site_Request_ReferencesType
     */
    public function addToJob_Posting_Site_Reference(\StructType\Job_Posting_SiteObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Posting_SiteObjectType) {
            throw new \InvalidArgumentException(sprintf('The Job_Posting_Site_Reference property can only contain items of type \StructType\Job_Posting_SiteObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Posting_Site_Reference[] = $item;
        return $this;
    }
}
