<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Posting_Reference_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Data used to identify the Job Posting when no Job Posting Reference is supplied.
 * @subpackage Structs
 */
class Job_Posting_Reference_DataType extends AbstractStructBase
{
    /**
     * The Job_Posting_Site_Name
     * Meta information extracted from the WSDL
     * - documentation: Name of Job Posting Site
     * - choice: Job_Posting_Site_Name | Job_Posting_Site_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var string
     */
    public $Job_Posting_Site_Name;
    /**
     * The Job_Posting_Site_Reference
     * Meta information extracted from the WSDL
     * - documentation: Refence to the Job Posting Site.
     * - choice: Job_Posting_Site_Name | Job_Posting_Site_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Job_Posting_SiteObjectType
     */
    public $Job_Posting_Site_Reference;
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: Job Requisition for the Job Posting.
     * @var \StructType\Job_Requisition_EnabledObjectType
     */
    public $Job_Requisition_Reference;
    /**
     * Constructor method for Job_Posting_Reference_DataType
     * @uses Job_Posting_Reference_DataType::setJob_Posting_Site_Name()
     * @uses Job_Posting_Reference_DataType::setJob_Posting_Site_Reference()
     * @uses Job_Posting_Reference_DataType::setJob_Requisition_Reference()
     * @param string $job_Posting_Site_Name
     * @param \StructType\Job_Posting_SiteObjectType $job_Posting_Site_Reference
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     */
    public function __construct($job_Posting_Site_Name = null, \StructType\Job_Posting_SiteObjectType $job_Posting_Site_Reference = null, \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null)
    {
        $this
            ->setJob_Posting_Site_Name($job_Posting_Site_Name)
            ->setJob_Posting_Site_Reference($job_Posting_Site_Reference)
            ->setJob_Requisition_Reference($job_Requisition_Reference);
    }
    /**
     * Get Job_Posting_Site_Name value
     * @return string|null
     */
    public function getJob_Posting_Site_Name()
    {
        return isset($this->Job_Posting_Site_Name) ? $this->Job_Posting_Site_Name : null;
    }
    /**
     * This method is responsible for validating the value passed to the setJob_Posting_Site_Name method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Posting_Site_Name method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateJob_Posting_Site_NameForChoiceConstraintsFromSetJob_Posting_Site_Name($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Job_Posting_Site_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Job_Posting_Site_Name can\'t be set as the property %s is already set. Only one property must be set among these properties: Job_Posting_Site_Name, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Job_Posting_Site_Name value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $job_Posting_Site_Name
     * @return \StructType\Job_Posting_Reference_DataType
     */
    public function setJob_Posting_Site_Name($job_Posting_Site_Name = null)
    {
        // validation for constraint: string
        if (!is_null($job_Posting_Site_Name) && !is_string($job_Posting_Site_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Posting_Site_Name, true), gettype($job_Posting_Site_Name)), __LINE__);
        }
        // validation for constraint: choice(Job_Posting_Site_Name, Job_Posting_Site_Reference)
        if ('' !== ($job_Posting_Site_NameChoiceErrorMessage = self::validateJob_Posting_Site_NameForChoiceConstraintsFromSetJob_Posting_Site_Name($job_Posting_Site_Name))) {
            throw new \InvalidArgumentException($job_Posting_Site_NameChoiceErrorMessage, __LINE__);
        }
        if (is_null($job_Posting_Site_Name) || (is_array($job_Posting_Site_Name) && empty($job_Posting_Site_Name))) {
            unset($this->Job_Posting_Site_Name);
        } else {
            $this->Job_Posting_Site_Name = $job_Posting_Site_Name;
        }
        return $this;
    }
    /**
     * Get Job_Posting_Site_Reference value
     * @return \StructType\Job_Posting_SiteObjectType|null
     */
    public function getJob_Posting_Site_Reference()
    {
        return isset($this->Job_Posting_Site_Reference) ? $this->Job_Posting_Site_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setJob_Posting_Site_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Posting_Site_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateJob_Posting_Site_ReferenceForChoiceConstraintsFromSetJob_Posting_Site_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Job_Posting_Site_Name',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Job_Posting_Site_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Job_Posting_Site_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Job_Posting_Site_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Posting_SiteObjectType $job_Posting_Site_Reference
     * @return \StructType\Job_Posting_Reference_DataType
     */
    public function setJob_Posting_Site_Reference(\StructType\Job_Posting_SiteObjectType $job_Posting_Site_Reference = null)
    {
        // validation for constraint: choice(Job_Posting_Site_Name, Job_Posting_Site_Reference)
        if ('' !== ($job_Posting_Site_ReferenceChoiceErrorMessage = self::validateJob_Posting_Site_ReferenceForChoiceConstraintsFromSetJob_Posting_Site_Reference($job_Posting_Site_Reference))) {
            throw new \InvalidArgumentException($job_Posting_Site_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($job_Posting_Site_Reference) || (is_array($job_Posting_Site_Reference) && empty($job_Posting_Site_Reference))) {
            unset($this->Job_Posting_Site_Reference);
        } else {
            $this->Job_Posting_Site_Reference = $job_Posting_Site_Reference;
        }
        return $this;
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_Requisition_EnabledObjectType|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * Set Job_Requisition_Reference value
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @return \StructType\Job_Posting_Reference_DataType
     */
    public function setJob_Requisition_Reference(\StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null)
    {
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
}
