<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Interviewer_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data for interviewer.
 * @subpackage Structs
 */
class Interviewer_DataType extends AbstractStructBase
{
    /**
     * The Interviewer_Name
     * Meta information extracted from the WSDL
     * - documentation: References the interviewer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Interviewer_Name;
    /**
     * The Interviewer_Email_Address
     * Meta information extracted from the WSDL
     * - documentation: Email Address of the interviewer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Interviewer_Email_Address;
    /**
     * Constructor method for Interviewer_DataType
     * @uses Interviewer_DataType::setInterviewer_Name()
     * @uses Interviewer_DataType::setInterviewer_Email_Address()
     * @param string $interviewer_Name
     * @param string $interviewer_Email_Address
     */
    public function __construct($interviewer_Name = null, $interviewer_Email_Address = null)
    {
        $this
            ->setInterviewer_Name($interviewer_Name)
            ->setInterviewer_Email_Address($interviewer_Email_Address);
    }
    /**
     * Get Interviewer_Name value
     * @return string|null
     */
    public function getInterviewer_Name()
    {
        return $this->Interviewer_Name;
    }
    /**
     * Set Interviewer_Name value
     * @param string $interviewer_Name
     * @return \StructType\Interviewer_DataType
     */
    public function setInterviewer_Name($interviewer_Name = null)
    {
        // validation for constraint: string
        if (!is_null($interviewer_Name) && !is_string($interviewer_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interviewer_Name, true), gettype($interviewer_Name)), __LINE__);
        }
        $this->Interviewer_Name = $interviewer_Name;
        return $this;
    }
    /**
     * Get Interviewer_Email_Address value
     * @return string|null
     */
    public function getInterviewer_Email_Address()
    {
        return $this->Interviewer_Email_Address;
    }
    /**
     * Set Interviewer_Email_Address value
     * @param string $interviewer_Email_Address
     * @return \StructType\Interviewer_DataType
     */
    public function setInterviewer_Email_Address($interviewer_Email_Address = null)
    {
        // validation for constraint: string
        if (!is_null($interviewer_Email_Address) && !is_string($interviewer_Email_Address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interviewer_Email_Address, true), gettype($interviewer_Email_Address)), __LINE__);
        }
        $this->Interviewer_Email_Address = $interviewer_Email_Address;
        return $this;
    }
}
