<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Interview_Session_Details_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the interviewers, duration in minutes, interview start time, interview end time, interview type, and comment data.
 * @subpackage Structs
 */
class Interview_Session_Details_DataType extends AbstractStructBase
{
    /**
     * The Interviewers_Reference
     * Meta information extracted from the WSDL
     * - documentation: The interviewer on the interview team.
     * - maxOccurs: unbounded
     * @var \StructType\WorkerObjectType[]
     */
    public $Interviewers_Reference;
    /**
     * The Interview_Start_Time
     * Meta information extracted from the WSDL
     * - documentation: The start day and time of the interview.
     * - maxOccurs: 1
     * @var string
     */
    public $Interview_Start_Time;
    /**
     * The Interview_End_Time
     * Meta information extracted from the WSDL
     * - documentation: The end day and time of the interview.
     * - maxOccurs: 1
     * @var string
     */
    public $Interview_End_Time;
    /**
     * The Interview_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: The location of the interview session.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Interview_Location_Reference;
    /**
     * The Interview_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The type of interview the interview session will be.
     * - minOccurs: 0
     * @var \StructType\Interview_TypeObjectType
     */
    public $Interview_Type_Reference;
    /**
     * The Interview_Competencies_Reference
     * Meta information extracted from the WSDL
     * - documentation: The competencies an interviewer should evaluate the candidate on.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CompetencyObjectType[]
     */
    public $Interview_Competencies_Reference;
    /**
     * The Interview_Questionnaires_Reference
     * Meta information extracted from the WSDL
     * - documentation: The questionnaires an interviewer should evaluate for an interview session.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\QuestionnaireObjectType[]
     */
    public $Interview_Questionnaires_Reference;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: Comment for the interviewers on the interview session.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for Interview_Session_Details_DataType
     * @uses Interview_Session_Details_DataType::setInterviewers_Reference()
     * @uses Interview_Session_Details_DataType::setInterview_Start_Time()
     * @uses Interview_Session_Details_DataType::setInterview_End_Time()
     * @uses Interview_Session_Details_DataType::setInterview_Location_Reference()
     * @uses Interview_Session_Details_DataType::setInterview_Type_Reference()
     * @uses Interview_Session_Details_DataType::setInterview_Competencies_Reference()
     * @uses Interview_Session_Details_DataType::setInterview_Questionnaires_Reference()
     * @uses Interview_Session_Details_DataType::setComment()
     * @param \StructType\WorkerObjectType[] $interviewers_Reference
     * @param string $interview_Start_Time
     * @param string $interview_End_Time
     * @param \StructType\LocationObjectType $interview_Location_Reference
     * @param \StructType\Interview_TypeObjectType $interview_Type_Reference
     * @param \StructType\CompetencyObjectType[] $interview_Competencies_Reference
     * @param \StructType\QuestionnaireObjectType[] $interview_Questionnaires_Reference
     * @param string $comment
     */
    public function __construct(array $interviewers_Reference = array(), $interview_Start_Time = null, $interview_End_Time = null, \StructType\LocationObjectType $interview_Location_Reference = null, \StructType\Interview_TypeObjectType $interview_Type_Reference = null, array $interview_Competencies_Reference = array(), array $interview_Questionnaires_Reference = array(), $comment = null)
    {
        $this
            ->setInterviewers_Reference($interviewers_Reference)
            ->setInterview_Start_Time($interview_Start_Time)
            ->setInterview_End_Time($interview_End_Time)
            ->setInterview_Location_Reference($interview_Location_Reference)
            ->setInterview_Type_Reference($interview_Type_Reference)
            ->setInterview_Competencies_Reference($interview_Competencies_Reference)
            ->setInterview_Questionnaires_Reference($interview_Questionnaires_Reference)
            ->setComment($comment);
    }
    /**
     * Get Interviewers_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getInterviewers_Reference()
    {
        return $this->Interviewers_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setInterviewers_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInterviewers_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInterviewers_ReferenceForArrayConstraintsFromSetInterviewers_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interview_Session_Details_DataTypeInterviewers_ReferenceItem) {
            // validation for constraint: itemType
            if (!$interview_Session_Details_DataTypeInterviewers_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($interview_Session_Details_DataTypeInterviewers_ReferenceItem) ? get_class($interview_Session_Details_DataTypeInterviewers_ReferenceItem) : sprintf('%s(%s)', gettype($interview_Session_Details_DataTypeInterviewers_ReferenceItem), var_export($interview_Session_Details_DataTypeInterviewers_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Interviewers_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Interviewers_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $interviewers_Reference
     * @return \StructType\Interview_Session_Details_DataType
     */
    public function setInterviewers_Reference(array $interviewers_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($interviewers_ReferenceArrayErrorMessage = self::validateInterviewers_ReferenceForArrayConstraintsFromSetInterviewers_Reference($interviewers_Reference))) {
            throw new \InvalidArgumentException($interviewers_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Interviewers_Reference = $interviewers_Reference;
        return $this;
    }
    /**
     * Add item to Interviewers_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Interview_Session_Details_DataType
     */
    public function addToInterviewers_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Interviewers_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Interviewers_Reference[] = $item;
        return $this;
    }
    /**
     * Get Interview_Start_Time value
     * @return string|null
     */
    public function getInterview_Start_Time()
    {
        return $this->Interview_Start_Time;
    }
    /**
     * Set Interview_Start_Time value
     * @param string $interview_Start_Time
     * @return \StructType\Interview_Session_Details_DataType
     */
    public function setInterview_Start_Time($interview_Start_Time = null)
    {
        // validation for constraint: string
        if (!is_null($interview_Start_Time) && !is_string($interview_Start_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interview_Start_Time, true), gettype($interview_Start_Time)), __LINE__);
        }
        $this->Interview_Start_Time = $interview_Start_Time;
        return $this;
    }
    /**
     * Get Interview_End_Time value
     * @return string|null
     */
    public function getInterview_End_Time()
    {
        return $this->Interview_End_Time;
    }
    /**
     * Set Interview_End_Time value
     * @param string $interview_End_Time
     * @return \StructType\Interview_Session_Details_DataType
     */
    public function setInterview_End_Time($interview_End_Time = null)
    {
        // validation for constraint: string
        if (!is_null($interview_End_Time) && !is_string($interview_End_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interview_End_Time, true), gettype($interview_End_Time)), __LINE__);
        }
        $this->Interview_End_Time = $interview_End_Time;
        return $this;
    }
    /**
     * Get Interview_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getInterview_Location_Reference()
    {
        return $this->Interview_Location_Reference;
    }
    /**
     * Set Interview_Location_Reference value
     * @param \StructType\LocationObjectType $interview_Location_Reference
     * @return \StructType\Interview_Session_Details_DataType
     */
    public function setInterview_Location_Reference(\StructType\LocationObjectType $interview_Location_Reference = null)
    {
        $this->Interview_Location_Reference = $interview_Location_Reference;
        return $this;
    }
    /**
     * Get Interview_Type_Reference value
     * @return \StructType\Interview_TypeObjectType|null
     */
    public function getInterview_Type_Reference()
    {
        return $this->Interview_Type_Reference;
    }
    /**
     * Set Interview_Type_Reference value
     * @param \StructType\Interview_TypeObjectType $interview_Type_Reference
     * @return \StructType\Interview_Session_Details_DataType
     */
    public function setInterview_Type_Reference(\StructType\Interview_TypeObjectType $interview_Type_Reference = null)
    {
        $this->Interview_Type_Reference = $interview_Type_Reference;
        return $this;
    }
    /**
     * Get Interview_Competencies_Reference value
     * @return \StructType\CompetencyObjectType[]|null
     */
    public function getInterview_Competencies_Reference()
    {
        return $this->Interview_Competencies_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setInterview_Competencies_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInterview_Competencies_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInterview_Competencies_ReferenceForArrayConstraintsFromSetInterview_Competencies_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interview_Session_Details_DataTypeInterview_Competencies_ReferenceItem) {
            // validation for constraint: itemType
            if (!$interview_Session_Details_DataTypeInterview_Competencies_ReferenceItem instanceof \StructType\CompetencyObjectType) {
                $invalidValues[] = is_object($interview_Session_Details_DataTypeInterview_Competencies_ReferenceItem) ? get_class($interview_Session_Details_DataTypeInterview_Competencies_ReferenceItem) : sprintf('%s(%s)', gettype($interview_Session_Details_DataTypeInterview_Competencies_ReferenceItem), var_export($interview_Session_Details_DataTypeInterview_Competencies_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Interview_Competencies_Reference property can only contain items of type \StructType\CompetencyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Interview_Competencies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompetencyObjectType[] $interview_Competencies_Reference
     * @return \StructType\Interview_Session_Details_DataType
     */
    public function setInterview_Competencies_Reference(array $interview_Competencies_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($interview_Competencies_ReferenceArrayErrorMessage = self::validateInterview_Competencies_ReferenceForArrayConstraintsFromSetInterview_Competencies_Reference($interview_Competencies_Reference))) {
            throw new \InvalidArgumentException($interview_Competencies_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Interview_Competencies_Reference = $interview_Competencies_Reference;
        return $this;
    }
    /**
     * Add item to Interview_Competencies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompetencyObjectType $item
     * @return \StructType\Interview_Session_Details_DataType
     */
    public function addToInterview_Competencies_Reference(\StructType\CompetencyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompetencyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Interview_Competencies_Reference property can only contain items of type \StructType\CompetencyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Interview_Competencies_Reference[] = $item;
        return $this;
    }
    /**
     * Get Interview_Questionnaires_Reference value
     * @return \StructType\QuestionnaireObjectType[]|null
     */
    public function getInterview_Questionnaires_Reference()
    {
        return $this->Interview_Questionnaires_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setInterview_Questionnaires_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInterview_Questionnaires_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInterview_Questionnaires_ReferenceForArrayConstraintsFromSetInterview_Questionnaires_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interview_Session_Details_DataTypeInterview_Questionnaires_ReferenceItem) {
            // validation for constraint: itemType
            if (!$interview_Session_Details_DataTypeInterview_Questionnaires_ReferenceItem instanceof \StructType\QuestionnaireObjectType) {
                $invalidValues[] = is_object($interview_Session_Details_DataTypeInterview_Questionnaires_ReferenceItem) ? get_class($interview_Session_Details_DataTypeInterview_Questionnaires_ReferenceItem) : sprintf('%s(%s)', gettype($interview_Session_Details_DataTypeInterview_Questionnaires_ReferenceItem), var_export($interview_Session_Details_DataTypeInterview_Questionnaires_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Interview_Questionnaires_Reference property can only contain items of type \StructType\QuestionnaireObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Interview_Questionnaires_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\QuestionnaireObjectType[] $interview_Questionnaires_Reference
     * @return \StructType\Interview_Session_Details_DataType
     */
    public function setInterview_Questionnaires_Reference(array $interview_Questionnaires_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($interview_Questionnaires_ReferenceArrayErrorMessage = self::validateInterview_Questionnaires_ReferenceForArrayConstraintsFromSetInterview_Questionnaires_Reference($interview_Questionnaires_Reference))) {
            throw new \InvalidArgumentException($interview_Questionnaires_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Interview_Questionnaires_Reference = $interview_Questionnaires_Reference;
        return $this;
    }
    /**
     * Add item to Interview_Questionnaires_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\QuestionnaireObjectType $item
     * @return \StructType\Interview_Session_Details_DataType
     */
    public function addToInterview_Questionnaires_Reference(\StructType\QuestionnaireObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\QuestionnaireObjectType) {
            throw new \InvalidArgumentException(sprintf('The Interview_Questionnaires_Reference property can only contain items of type \StructType\QuestionnaireObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Interview_Questionnaires_Reference[] = $item;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Interview_Session_Details_DataType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
}
