<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Header_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Enter a Hex number with a length of 3 or 6 characters ranging between: 0-9, a-f, A-F. | Element container for header styling components.
 * @subpackage Structs
 */
class Header_DataType extends AbstractStructBase
{
    /**
     * The Background_Color
     * Meta information extracted from the WSDL
     * - documentation: Background color for the header of brand.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Background_Color;
    /**
     * The Text_Color
     * Meta information extracted from the WSDL
     * - documentation: Text color for the header of brand.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Text_Color;
    /**
     * The Accent_Bar_Color
     * Meta information extracted from the WSDL
     * - documentation: Accent bar color for the header of brand.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Accent_Bar_Color;
    /**
     * The Logo_Image_Data
     * Meta information extracted from the WSDL
     * - documentation: Element container for the header image of brand.
     * - minOccurs: 0
     * @var \StructType\Brand_Image_DataType
     */
    public $Logo_Image_Data;
    /**
     * The Image_Banner_Data
     * Meta information extracted from the WSDL
     * - documentation: Element container for image banner.
     * - minOccurs: 0
     * @var \StructType\Image_Banner_DataType
     */
    public $Image_Banner_Data;
    /**
     * Constructor method for Header_DataType
     * @uses Header_DataType::setBackground_Color()
     * @uses Header_DataType::setText_Color()
     * @uses Header_DataType::setAccent_Bar_Color()
     * @uses Header_DataType::setLogo_Image_Data()
     * @uses Header_DataType::setImage_Banner_Data()
     * @param string $background_Color
     * @param string $text_Color
     * @param string $accent_Bar_Color
     * @param \StructType\Brand_Image_DataType $logo_Image_Data
     * @param \StructType\Image_Banner_DataType $image_Banner_Data
     */
    public function __construct($background_Color = null, $text_Color = null, $accent_Bar_Color = null, \StructType\Brand_Image_DataType $logo_Image_Data = null, \StructType\Image_Banner_DataType $image_Banner_Data = null)
    {
        $this
            ->setBackground_Color($background_Color)
            ->setText_Color($text_Color)
            ->setAccent_Bar_Color($accent_Bar_Color)
            ->setLogo_Image_Data($logo_Image_Data)
            ->setImage_Banner_Data($image_Banner_Data);
    }
    /**
     * Get Background_Color value
     * @return string|null
     */
    public function getBackground_Color()
    {
        return $this->Background_Color;
    }
    /**
     * Set Background_Color value
     * @param string $background_Color
     * @return \StructType\Header_DataType
     */
    public function setBackground_Color($background_Color = null)
    {
        // validation for constraint: string
        if (!is_null($background_Color) && !is_string($background_Color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($background_Color, true), gettype($background_Color)), __LINE__);
        }
        $this->Background_Color = $background_Color;
        return $this;
    }
    /**
     * Get Text_Color value
     * @return string|null
     */
    public function getText_Color()
    {
        return $this->Text_Color;
    }
    /**
     * Set Text_Color value
     * @param string $text_Color
     * @return \StructType\Header_DataType
     */
    public function setText_Color($text_Color = null)
    {
        // validation for constraint: string
        if (!is_null($text_Color) && !is_string($text_Color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text_Color, true), gettype($text_Color)), __LINE__);
        }
        $this->Text_Color = $text_Color;
        return $this;
    }
    /**
     * Get Accent_Bar_Color value
     * @return string|null
     */
    public function getAccent_Bar_Color()
    {
        return $this->Accent_Bar_Color;
    }
    /**
     * Set Accent_Bar_Color value
     * @param string $accent_Bar_Color
     * @return \StructType\Header_DataType
     */
    public function setAccent_Bar_Color($accent_Bar_Color = null)
    {
        // validation for constraint: string
        if (!is_null($accent_Bar_Color) && !is_string($accent_Bar_Color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accent_Bar_Color, true), gettype($accent_Bar_Color)), __LINE__);
        }
        $this->Accent_Bar_Color = $accent_Bar_Color;
        return $this;
    }
    /**
     * Get Logo_Image_Data value
     * @return \StructType\Brand_Image_DataType|null
     */
    public function getLogo_Image_Data()
    {
        return $this->Logo_Image_Data;
    }
    /**
     * Set Logo_Image_Data value
     * @param \StructType\Brand_Image_DataType $logo_Image_Data
     * @return \StructType\Header_DataType
     */
    public function setLogo_Image_Data(\StructType\Brand_Image_DataType $logo_Image_Data = null)
    {
        $this->Logo_Image_Data = $logo_Image_Data;
        return $this;
    }
    /**
     * Get Image_Banner_Data value
     * @return \StructType\Image_Banner_DataType|null
     */
    public function getImage_Banner_Data()
    {
        return $this->Image_Banner_Data;
    }
    /**
     * Set Image_Banner_Data value
     * @param \StructType\Image_Banner_DataType $image_Banner_Data
     * @return \StructType\Header_DataType
     */
    public function setImage_Banner_Data(\StructType\Image_Banner_DataType $image_Banner_Data = null)
    {
        $this->Image_Banner_Data = $image_Banner_Data;
        return $this;
    }
}
