<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Get_Web_Conference_Interview_Data_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains interview data for the web conference.
 * @subpackage Structs
 */
class Get_Web_Conference_Interview_Data_RequestType extends AbstractStructBase
{
    /**
     * The Request_References
     * Meta information extracted from the WSDL
     * - documentation: References to Interview Data to retrieve.
     * - minOccurs: 0
     * @var \StructType\Web_Conference_Interview_Data_Request_ReferencesType
     */
    public $Request_References;
    /**
     * The Response_Filter
     * Meta information extracted from the WSDL
     * - documentation: Parameters that let you filter the data returned in the response. You can filter returned data by dates and page attributes.
     * - minOccurs: 0
     * @var \StructType\Response_FilterType
     */
    public $Response_Filter;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Get_Web_Conference_Interview_Data_RequestType
     * @uses Get_Web_Conference_Interview_Data_RequestType::setRequest_References()
     * @uses Get_Web_Conference_Interview_Data_RequestType::setResponse_Filter()
     * @uses Get_Web_Conference_Interview_Data_RequestType::setVersion()
     * @param \StructType\Web_Conference_Interview_Data_Request_ReferencesType $request_References
     * @param \StructType\Response_FilterType $response_Filter
     * @param string $version
     */
    public function __construct(\StructType\Web_Conference_Interview_Data_Request_ReferencesType $request_References = null, \StructType\Response_FilterType $response_Filter = null, $version = null)
    {
        $this
            ->setRequest_References($request_References)
            ->setResponse_Filter($response_Filter)
            ->setVersion($version);
    }
    /**
     * Get Request_References value
     * @return \StructType\Web_Conference_Interview_Data_Request_ReferencesType|null
     */
    public function getRequest_References()
    {
        return $this->Request_References;
    }
    /**
     * Set Request_References value
     * @param \StructType\Web_Conference_Interview_Data_Request_ReferencesType $request_References
     * @return \StructType\Get_Web_Conference_Interview_Data_RequestType
     */
    public function setRequest_References(\StructType\Web_Conference_Interview_Data_Request_ReferencesType $request_References = null)
    {
        $this->Request_References = $request_References;
        return $this;
    }
    /**
     * Get Response_Filter value
     * @return \StructType\Response_FilterType|null
     */
    public function getResponse_Filter()
    {
        return $this->Response_Filter;
    }
    /**
     * Set Response_Filter value
     * @param \StructType\Response_FilterType $response_Filter
     * @return \StructType\Get_Web_Conference_Interview_Data_RequestType
     */
    public function setResponse_Filter(\StructType\Response_FilterType $response_Filter = null)
    {
        $this->Response_Filter = $response_Filter;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Get_Web_Conference_Interview_Data_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
