<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Get_Organizations_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Root element for Get Organizations operation request
 * @subpackage Structs
 */
class Get_Organizations_RequestType extends AbstractStructBase
{
    /**
     * The Request_References
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element containing references to specific organizations
     * - minOccurs: 0
     * @var \StructType\Contextually_Secured_Organization_Request_ReferencesType
     */
    public $Request_References;
    /**
     * The Request_Criteria
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element containing filtering criteria to subset the organizations to return in the response.
     * - minOccurs: 0
     * @var \StructType\Organization_Request_CriteriaType
     */
    public $Request_Criteria;
    /**
     * The Response_Filter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Response_FilterType
     */
    public $Response_Filter;
    /**
     * The Response_Group
     * Meta information extracted from the WSDL
     * - documentation: The response group allows for the response data to be tailored to only included elements that the user is looking for. If no response group is provided in the request, then only the following elements will be returned: Reference,
     * Organization Data, Hierarchy Data and if a Supervisory Organization Type the Supervisory Data.
     * - minOccurs: 0
     * @var \StructType\Organization_Response_GroupType
     */
    public $Response_Group;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Get_Organizations_RequestType
     * @uses Get_Organizations_RequestType::setRequest_References()
     * @uses Get_Organizations_RequestType::setRequest_Criteria()
     * @uses Get_Organizations_RequestType::setResponse_Filter()
     * @uses Get_Organizations_RequestType::setResponse_Group()
     * @uses Get_Organizations_RequestType::setVersion()
     * @param \StructType\Contextually_Secured_Organization_Request_ReferencesType $request_References
     * @param \StructType\Organization_Request_CriteriaType $request_Criteria
     * @param \StructType\Response_FilterType $response_Filter
     * @param \StructType\Organization_Response_GroupType $response_Group
     * @param string $version
     */
    public function __construct(\StructType\Contextually_Secured_Organization_Request_ReferencesType $request_References = null, \StructType\Organization_Request_CriteriaType $request_Criteria = null, \StructType\Response_FilterType $response_Filter = null, \StructType\Organization_Response_GroupType $response_Group = null, $version = null)
    {
        $this
            ->setRequest_References($request_References)
            ->setRequest_Criteria($request_Criteria)
            ->setResponse_Filter($response_Filter)
            ->setResponse_Group($response_Group)
            ->setVersion($version);
    }
    /**
     * Get Request_References value
     * @return \StructType\Contextually_Secured_Organization_Request_ReferencesType|null
     */
    public function getRequest_References()
    {
        return $this->Request_References;
    }
    /**
     * Set Request_References value
     * @param \StructType\Contextually_Secured_Organization_Request_ReferencesType $request_References
     * @return \StructType\Get_Organizations_RequestType
     */
    public function setRequest_References(\StructType\Contextually_Secured_Organization_Request_ReferencesType $request_References = null)
    {
        $this->Request_References = $request_References;
        return $this;
    }
    /**
     * Get Request_Criteria value
     * @return \StructType\Organization_Request_CriteriaType|null
     */
    public function getRequest_Criteria()
    {
        return $this->Request_Criteria;
    }
    /**
     * Set Request_Criteria value
     * @param \StructType\Organization_Request_CriteriaType $request_Criteria
     * @return \StructType\Get_Organizations_RequestType
     */
    public function setRequest_Criteria(\StructType\Organization_Request_CriteriaType $request_Criteria = null)
    {
        $this->Request_Criteria = $request_Criteria;
        return $this;
    }
    /**
     * Get Response_Filter value
     * @return \StructType\Response_FilterType|null
     */
    public function getResponse_Filter()
    {
        return $this->Response_Filter;
    }
    /**
     * Set Response_Filter value
     * @param \StructType\Response_FilterType $response_Filter
     * @return \StructType\Get_Organizations_RequestType
     */
    public function setResponse_Filter(\StructType\Response_FilterType $response_Filter = null)
    {
        $this->Response_Filter = $response_Filter;
        return $this;
    }
    /**
     * Get Response_Group value
     * @return \StructType\Organization_Response_GroupType|null
     */
    public function getResponse_Group()
    {
        return $this->Response_Group;
    }
    /**
     * Set Response_Group value
     * @param \StructType\Organization_Response_GroupType $response_Group
     * @return \StructType\Get_Organizations_RequestType
     */
    public function setResponse_Group(\StructType\Organization_Response_GroupType $response_Group = null)
    {
        $this->Response_Group = $response_Group;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Get_Organizations_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
