<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Get_Job_Application_Template_Translation_RequestType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains Job Application Template reference, language filter, and response filter
 * @subpackage Structs
 */
class Get_Job_Application_Template_Translation_RequestType extends AbstractStructBase
{
    /**
     * The Request_References
     * Meta information extracted from the WSDL
     * - documentation: Contains Job Application Template reference
     * - minOccurs: 0
     * @var \StructType\Job_Application_Template_Request_ReferenceType
     */
    public $Request_References;
    /**
     * The Request_Criteria
     * Meta information extracted from the WSDL
     * - documentation: Contains reference to target language for translation
     * - minOccurs: 0
     * @var \StructType\Job_Application_Template_Translation_Request_CriteriaType
     */
    public $Request_Criteria;
    /**
     * The Response_Filter
     * Meta information extracted from the WSDL
     * - documentation: Contains reference to target language for translation
     * - minOccurs: 0
     * @var \StructType\Response_FilterType
     */
    public $Response_Filter;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Get_Job_Application_Template_Translation_RequestType
     * @uses Get_Job_Application_Template_Translation_RequestType::setRequest_References()
     * @uses Get_Job_Application_Template_Translation_RequestType::setRequest_Criteria()
     * @uses Get_Job_Application_Template_Translation_RequestType::setResponse_Filter()
     * @uses Get_Job_Application_Template_Translation_RequestType::setVersion()
     * @param \StructType\Job_Application_Template_Request_ReferenceType $request_References
     * @param \StructType\Job_Application_Template_Translation_Request_CriteriaType $request_Criteria
     * @param \StructType\Response_FilterType $response_Filter
     * @param string $version
     */
    public function __construct(\StructType\Job_Application_Template_Request_ReferenceType $request_References = null, \StructType\Job_Application_Template_Translation_Request_CriteriaType $request_Criteria = null, \StructType\Response_FilterType $response_Filter = null, $version = null)
    {
        $this
            ->setRequest_References($request_References)
            ->setRequest_Criteria($request_Criteria)
            ->setResponse_Filter($response_Filter)
            ->setVersion($version);
    }
    /**
     * Get Request_References value
     * @return \StructType\Job_Application_Template_Request_ReferenceType|null
     */
    public function getRequest_References()
    {
        return $this->Request_References;
    }
    /**
     * Set Request_References value
     * @param \StructType\Job_Application_Template_Request_ReferenceType $request_References
     * @return \StructType\Get_Job_Application_Template_Translation_RequestType
     */
    public function setRequest_References(\StructType\Job_Application_Template_Request_ReferenceType $request_References = null)
    {
        $this->Request_References = $request_References;
        return $this;
    }
    /**
     * Get Request_Criteria value
     * @return \StructType\Job_Application_Template_Translation_Request_CriteriaType|null
     */
    public function getRequest_Criteria()
    {
        return $this->Request_Criteria;
    }
    /**
     * Set Request_Criteria value
     * @param \StructType\Job_Application_Template_Translation_Request_CriteriaType $request_Criteria
     * @return \StructType\Get_Job_Application_Template_Translation_RequestType
     */
    public function setRequest_Criteria(\StructType\Job_Application_Template_Translation_Request_CriteriaType $request_Criteria = null)
    {
        $this->Request_Criteria = $request_Criteria;
        return $this;
    }
    /**
     * Get Response_Filter value
     * @return \StructType\Response_FilterType|null
     */
    public function getResponse_Filter()
    {
        return $this->Response_Filter;
    }
    /**
     * Set Response_Filter value
     * @param \StructType\Response_FilterType $response_Filter
     * @return \StructType\Get_Job_Application_Template_Translation_RequestType
     */
    public function setResponse_Filter(\StructType\Response_FilterType $response_Filter = null)
    {
        $this->Response_Filter = $response_Filter;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Get_Job_Application_Template_Translation_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
