<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Evergreen_Job_Requisition_Response_GroupType StructType
 * Meta information extracted from the WSDL
 * - documentation: The response group allows for the response data to be tailored to only included elements that the user is looking for. If no response group is provided in the request then only the following elements will be returned: Reference,
 * Evergreen Requisition Definition Data, and Evergreen Requisition Restrictions Data.
 * @subpackage Structs
 */
class Evergreen_Job_Requisition_Response_GroupType extends AbstractStructBase
{
    /**
     * The Include_Reference
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Reference for the Job Requisition is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Reference;
    /**
     * The Include_Job_Requisition_Definition_Data
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Job Requisition Definition Data is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Job_Requisition_Definition_Data;
    /**
     * The Create_Job_Requisition_Restrictions_Data
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Job Requisition Definition Data is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Create_Job_Requisition_Restrictions_Data;
    /**
     * The Include_Qualifications
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Position's Qualifications (Competencies, Education, Responsibilities, etc.) are included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Qualifications;
    /**
     * The Include_Job_Requisition_Attachments
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Position's Open Job Requisition Attachments (if they exist) are included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Job_Requisition_Attachments;
    /**
     * The Include_Organizations
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the job requisition organization assignments (if they exist) are included in the response. This is only applicable for job requisitions for supervisory organizations using the job management staffing model.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Organizations;
    /**
     * The Include_Roles
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the Roles Data element is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Roles;
    /**
     * Constructor method for Evergreen_Job_Requisition_Response_GroupType
     * @uses Evergreen_Job_Requisition_Response_GroupType::setInclude_Reference()
     * @uses Evergreen_Job_Requisition_Response_GroupType::setInclude_Job_Requisition_Definition_Data()
     * @uses Evergreen_Job_Requisition_Response_GroupType::setCreate_Job_Requisition_Restrictions_Data()
     * @uses Evergreen_Job_Requisition_Response_GroupType::setInclude_Qualifications()
     * @uses Evergreen_Job_Requisition_Response_GroupType::setInclude_Job_Requisition_Attachments()
     * @uses Evergreen_Job_Requisition_Response_GroupType::setInclude_Organizations()
     * @uses Evergreen_Job_Requisition_Response_GroupType::setInclude_Roles()
     * @param bool $include_Reference
     * @param bool $include_Job_Requisition_Definition_Data
     * @param bool $create_Job_Requisition_Restrictions_Data
     * @param bool $include_Qualifications
     * @param bool $include_Job_Requisition_Attachments
     * @param bool $include_Organizations
     * @param bool $include_Roles
     */
    public function __construct($include_Reference = null, $include_Job_Requisition_Definition_Data = null, $create_Job_Requisition_Restrictions_Data = null, $include_Qualifications = null, $include_Job_Requisition_Attachments = null, $include_Organizations = null, $include_Roles = null)
    {
        $this
            ->setInclude_Reference($include_Reference)
            ->setInclude_Job_Requisition_Definition_Data($include_Job_Requisition_Definition_Data)
            ->setCreate_Job_Requisition_Restrictions_Data($create_Job_Requisition_Restrictions_Data)
            ->setInclude_Qualifications($include_Qualifications)
            ->setInclude_Job_Requisition_Attachments($include_Job_Requisition_Attachments)
            ->setInclude_Organizations($include_Organizations)
            ->setInclude_Roles($include_Roles);
    }
    /**
     * Get Include_Reference value
     * @return bool|null
     */
    public function getInclude_Reference()
    {
        return $this->Include_Reference;
    }
    /**
     * Set Include_Reference value
     * @param bool $include_Reference
     * @return \StructType\Evergreen_Job_Requisition_Response_GroupType
     */
    public function setInclude_Reference($include_Reference = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Reference) && !is_bool($include_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Reference, true), gettype($include_Reference)), __LINE__);
        }
        $this->Include_Reference = $include_Reference;
        return $this;
    }
    /**
     * Get Include_Job_Requisition_Definition_Data value
     * @return bool|null
     */
    public function getInclude_Job_Requisition_Definition_Data()
    {
        return $this->Include_Job_Requisition_Definition_Data;
    }
    /**
     * Set Include_Job_Requisition_Definition_Data value
     * @param bool $include_Job_Requisition_Definition_Data
     * @return \StructType\Evergreen_Job_Requisition_Response_GroupType
     */
    public function setInclude_Job_Requisition_Definition_Data($include_Job_Requisition_Definition_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Job_Requisition_Definition_Data) && !is_bool($include_Job_Requisition_Definition_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Job_Requisition_Definition_Data, true), gettype($include_Job_Requisition_Definition_Data)), __LINE__);
        }
        $this->Include_Job_Requisition_Definition_Data = $include_Job_Requisition_Definition_Data;
        return $this;
    }
    /**
     * Get Create_Job_Requisition_Restrictions_Data value
     * @return bool|null
     */
    public function getCreate_Job_Requisition_Restrictions_Data()
    {
        return $this->Create_Job_Requisition_Restrictions_Data;
    }
    /**
     * Set Create_Job_Requisition_Restrictions_Data value
     * @param bool $create_Job_Requisition_Restrictions_Data
     * @return \StructType\Evergreen_Job_Requisition_Response_GroupType
     */
    public function setCreate_Job_Requisition_Restrictions_Data($create_Job_Requisition_Restrictions_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($create_Job_Requisition_Restrictions_Data) && !is_bool($create_Job_Requisition_Restrictions_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($create_Job_Requisition_Restrictions_Data, true), gettype($create_Job_Requisition_Restrictions_Data)), __LINE__);
        }
        $this->Create_Job_Requisition_Restrictions_Data = $create_Job_Requisition_Restrictions_Data;
        return $this;
    }
    /**
     * Get Include_Qualifications value
     * @return bool|null
     */
    public function getInclude_Qualifications()
    {
        return $this->Include_Qualifications;
    }
    /**
     * Set Include_Qualifications value
     * @param bool $include_Qualifications
     * @return \StructType\Evergreen_Job_Requisition_Response_GroupType
     */
    public function setInclude_Qualifications($include_Qualifications = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Qualifications) && !is_bool($include_Qualifications)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Qualifications, true), gettype($include_Qualifications)), __LINE__);
        }
        $this->Include_Qualifications = $include_Qualifications;
        return $this;
    }
    /**
     * Get Include_Job_Requisition_Attachments value
     * @return bool|null
     */
    public function getInclude_Job_Requisition_Attachments()
    {
        return $this->Include_Job_Requisition_Attachments;
    }
    /**
     * Set Include_Job_Requisition_Attachments value
     * @param bool $include_Job_Requisition_Attachments
     * @return \StructType\Evergreen_Job_Requisition_Response_GroupType
     */
    public function setInclude_Job_Requisition_Attachments($include_Job_Requisition_Attachments = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Job_Requisition_Attachments) && !is_bool($include_Job_Requisition_Attachments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Job_Requisition_Attachments, true), gettype($include_Job_Requisition_Attachments)), __LINE__);
        }
        $this->Include_Job_Requisition_Attachments = $include_Job_Requisition_Attachments;
        return $this;
    }
    /**
     * Get Include_Organizations value
     * @return bool|null
     */
    public function getInclude_Organizations()
    {
        return $this->Include_Organizations;
    }
    /**
     * Set Include_Organizations value
     * @param bool $include_Organizations
     * @return \StructType\Evergreen_Job_Requisition_Response_GroupType
     */
    public function setInclude_Organizations($include_Organizations = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Organizations) && !is_bool($include_Organizations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Organizations, true), gettype($include_Organizations)), __LINE__);
        }
        $this->Include_Organizations = $include_Organizations;
        return $this;
    }
    /**
     * Get Include_Roles value
     * @return bool|null
     */
    public function getInclude_Roles()
    {
        return $this->Include_Roles;
    }
    /**
     * Set Include_Roles value
     * @param bool $include_Roles
     * @return \StructType\Evergreen_Job_Requisition_Response_GroupType
     */
    public function setInclude_Roles($include_Roles = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Roles) && !is_bool($include_Roles)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Roles, true), gettype($include_Roles)), __LINE__);
        }
        $this->Include_Roles = $include_Roles;
        return $this;
    }
}
