<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Employment_Agreement_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: A request to initiate an employment agreement.
 * @subpackage Structs
 */
class Employment_Agreement_RequestType extends AbstractStructBase
{
    /**
     * The Dynamic_Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Dynamic_Business_Process_ParametersType
     */
    public $Dynamic_Business_Process_Parameters;
    /**
     * The Employment_Agreement_Data
     * @var \StructType\Employment_Agreement_DataType
     */
    public $Employment_Agreement_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Employment_Agreement_RequestType
     * @uses Employment_Agreement_RequestType::setDynamic_Business_Process_Parameters()
     * @uses Employment_Agreement_RequestType::setEmployment_Agreement_Data()
     * @uses Employment_Agreement_RequestType::setVersion()
     * @param \StructType\Dynamic_Business_Process_ParametersType $dynamic_Business_Process_Parameters
     * @param \StructType\Employment_Agreement_DataType $employment_Agreement_Data
     * @param string $version
     */
    public function __construct(\StructType\Dynamic_Business_Process_ParametersType $dynamic_Business_Process_Parameters = null, \StructType\Employment_Agreement_DataType $employment_Agreement_Data = null, $version = null)
    {
        $this
            ->setDynamic_Business_Process_Parameters($dynamic_Business_Process_Parameters)
            ->setEmployment_Agreement_Data($employment_Agreement_Data)
            ->setVersion($version);
    }
    /**
     * Get Dynamic_Business_Process_Parameters value
     * @return \StructType\Dynamic_Business_Process_ParametersType|null
     */
    public function getDynamic_Business_Process_Parameters()
    {
        return $this->Dynamic_Business_Process_Parameters;
    }
    /**
     * Set Dynamic_Business_Process_Parameters value
     * @param \StructType\Dynamic_Business_Process_ParametersType $dynamic_Business_Process_Parameters
     * @return \StructType\Employment_Agreement_RequestType
     */
    public function setDynamic_Business_Process_Parameters(\StructType\Dynamic_Business_Process_ParametersType $dynamic_Business_Process_Parameters = null)
    {
        $this->Dynamic_Business_Process_Parameters = $dynamic_Business_Process_Parameters;
        return $this;
    }
    /**
     * Get Employment_Agreement_Data value
     * @return \StructType\Employment_Agreement_DataType|null
     */
    public function getEmployment_Agreement_Data()
    {
        return $this->Employment_Agreement_Data;
    }
    /**
     * Set Employment_Agreement_Data value
     * @param \StructType\Employment_Agreement_DataType $employment_Agreement_Data
     * @return \StructType\Employment_Agreement_RequestType
     */
    public function setEmployment_Agreement_Data(\StructType\Employment_Agreement_DataType $employment_Agreement_Data = null)
    {
        $this->Employment_Agreement_Data = $employment_Agreement_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Employment_Agreement_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
