<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Employment_Agreement_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains details of the employment agreement.
 * @subpackage Structs
 */
class Employment_Agreement_DataType extends AbstractStructBase
{
    /**
     * The Job_Application_Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Job Application associated to the employment agreement.
     * - choice: Job_Application_Event_Reference | Job_Application_Reference | Candidate_Criteria_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Job_Application_Event_Reference;
    /**
     * The Job_Application_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Job Application associated with the employment agreement.
     * - choice: Job_Application_Event_Reference | Job_Application_Reference | Candidate_Criteria_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Job_ApplicationObjectType
     */
    public $Job_Application_Reference;
    /**
     * The Candidate_Criteria_Data
     * Meta information extracted from the WSDL
     * - documentation: A Candidate and Job Requisition reference associated with the employment agreement.
     * - choice: Job_Application_Event_Reference | Job_Application_Reference | Candidate_Criteria_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Move_Candidate_CriteriaType
     */
    public $Candidate_Criteria_Data;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Employment_Agreement_Event_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains the employment agreement details.
     * @var \StructType\Offer_Event_DataType
     */
    public $Employment_Agreement_Event_Data;
    /**
     * The Propose_Compensation_Sub_Process
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Propose_Compensation_For_Employment_Sub_Business_ProcessType
     */
    public $Propose_Compensation_Sub_Process;
    /**
     * The Request_One_Time_Payment_Sub_Process
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Request_One_Time_Payment_Sub_Business_ProcessType
     */
    public $Request_One_Time_Payment_Sub_Process;
    /**
     * The Request_Stock_Grant_Sub_Process
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Request_Stock_Offer_Sub_Business_ProcessType
     */
    public $Request_Stock_Grant_Sub_Process;
    /**
     * The Pre_Hire_Probation_Period_Sub_Process
     * Meta information extracted from the WSDL
     * - documentation: Pre-Hire Probation Period associated with the Employment Agreement.
     * - minOccurs: 0
     * @var \StructType\Pre_Hire_Probation_Period_Sub_Business_ProcessType
     */
    public $Pre_Hire_Probation_Period_Sub_Process;
    /**
     * The Pre_Hire_Contract_Details_Sub_Process
     * Meta information extracted from the WSDL
     * - documentation: Pre-Hire Contract Details associated with the Employment Agreement.
     * - minOccurs: 0
     * @var \StructType\Pre_Hire_Contract_Details_Sub_Business_ProcessType
     */
    public $Pre_Hire_Contract_Details_Sub_Process;
    /**
     * The Pre_Hire_Collective_Agreement_Sub_Process
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Assign_Employee_Collective_Agreement_Sub_Business_ProcessType
     */
    public $Pre_Hire_Collective_Agreement_Sub_Process;
    /**
     * The Pre_Hire_Edit_Notice_Period_Sub_Process
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Edit_Notice_Periods_Sub_Business_ProcessType
     */
    public $Pre_Hire_Edit_Notice_Period_Sub_Process;
    /**
     * Constructor method for Employment_Agreement_DataType
     * @uses Employment_Agreement_DataType::setJob_Application_Event_Reference()
     * @uses Employment_Agreement_DataType::setJob_Application_Reference()
     * @uses Employment_Agreement_DataType::setCandidate_Criteria_Data()
     * @uses Employment_Agreement_DataType::setBusiness_Process_Parameters()
     * @uses Employment_Agreement_DataType::setEmployment_Agreement_Event_Data()
     * @uses Employment_Agreement_DataType::setPropose_Compensation_Sub_Process()
     * @uses Employment_Agreement_DataType::setRequest_One_Time_Payment_Sub_Process()
     * @uses Employment_Agreement_DataType::setRequest_Stock_Grant_Sub_Process()
     * @uses Employment_Agreement_DataType::setPre_Hire_Probation_Period_Sub_Process()
     * @uses Employment_Agreement_DataType::setPre_Hire_Contract_Details_Sub_Process()
     * @uses Employment_Agreement_DataType::setPre_Hire_Collective_Agreement_Sub_Process()
     * @uses Employment_Agreement_DataType::setPre_Hire_Edit_Notice_Period_Sub_Process()
     * @param \StructType\Unique_IdentifierObjectType $job_Application_Event_Reference
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @param \StructType\Move_Candidate_CriteriaType $candidate_Criteria_Data
     * @param \StructType\Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Offer_Event_DataType $employment_Agreement_Event_Data
     * @param \StructType\Propose_Compensation_For_Employment_Sub_Business_ProcessType $propose_Compensation_Sub_Process
     * @param \StructType\Request_One_Time_Payment_Sub_Business_ProcessType $request_One_Time_Payment_Sub_Process
     * @param \StructType\Request_Stock_Offer_Sub_Business_ProcessType $request_Stock_Grant_Sub_Process
     * @param \StructType\Pre_Hire_Probation_Period_Sub_Business_ProcessType $pre_Hire_Probation_Period_Sub_Process
     * @param \StructType\Pre_Hire_Contract_Details_Sub_Business_ProcessType $pre_Hire_Contract_Details_Sub_Process
     * @param \StructType\Assign_Employee_Collective_Agreement_Sub_Business_ProcessType $pre_Hire_Collective_Agreement_Sub_Process
     * @param \StructType\Edit_Notice_Periods_Sub_Business_ProcessType $pre_Hire_Edit_Notice_Period_Sub_Process
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $job_Application_Event_Reference = null, \StructType\Job_ApplicationObjectType $job_Application_Reference = null, \StructType\Move_Candidate_CriteriaType $candidate_Criteria_Data = null, \StructType\Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Offer_Event_DataType $employment_Agreement_Event_Data = null, \StructType\Propose_Compensation_For_Employment_Sub_Business_ProcessType $propose_Compensation_Sub_Process = null, \StructType\Request_One_Time_Payment_Sub_Business_ProcessType $request_One_Time_Payment_Sub_Process = null, \StructType\Request_Stock_Offer_Sub_Business_ProcessType $request_Stock_Grant_Sub_Process = null, \StructType\Pre_Hire_Probation_Period_Sub_Business_ProcessType $pre_Hire_Probation_Period_Sub_Process = null, \StructType\Pre_Hire_Contract_Details_Sub_Business_ProcessType $pre_Hire_Contract_Details_Sub_Process = null, \StructType\Assign_Employee_Collective_Agreement_Sub_Business_ProcessType $pre_Hire_Collective_Agreement_Sub_Process = null, \StructType\Edit_Notice_Periods_Sub_Business_ProcessType $pre_Hire_Edit_Notice_Period_Sub_Process = null)
    {
        $this
            ->setJob_Application_Event_Reference($job_Application_Event_Reference)
            ->setJob_Application_Reference($job_Application_Reference)
            ->setCandidate_Criteria_Data($candidate_Criteria_Data)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setEmployment_Agreement_Event_Data($employment_Agreement_Event_Data)
            ->setPropose_Compensation_Sub_Process($propose_Compensation_Sub_Process)
            ->setRequest_One_Time_Payment_Sub_Process($request_One_Time_Payment_Sub_Process)
            ->setRequest_Stock_Grant_Sub_Process($request_Stock_Grant_Sub_Process)
            ->setPre_Hire_Probation_Period_Sub_Process($pre_Hire_Probation_Period_Sub_Process)
            ->setPre_Hire_Contract_Details_Sub_Process($pre_Hire_Contract_Details_Sub_Process)
            ->setPre_Hire_Collective_Agreement_Sub_Process($pre_Hire_Collective_Agreement_Sub_Process)
            ->setPre_Hire_Edit_Notice_Period_Sub_Process($pre_Hire_Edit_Notice_Period_Sub_Process);
    }
    /**
     * Get Job_Application_Event_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getJob_Application_Event_Reference()
    {
        return isset($this->Job_Application_Event_Reference) ? $this->Job_Application_Event_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setJob_Application_Event_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Application_Event_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateJob_Application_Event_ReferenceForChoiceConstraintsFromSetJob_Application_Event_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Job_Application_Reference',
            'Candidate_Criteria_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Job_Application_Event_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Job_Application_Event_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Job_Application_Event_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $job_Application_Event_Reference
     * @return \StructType\Employment_Agreement_DataType
     */
    public function setJob_Application_Event_Reference(\StructType\Unique_IdentifierObjectType $job_Application_Event_Reference = null)
    {
        // validation for constraint: choice(Job_Application_Event_Reference, Job_Application_Reference, Candidate_Criteria_Data)
        if ('' !== ($job_Application_Event_ReferenceChoiceErrorMessage = self::validateJob_Application_Event_ReferenceForChoiceConstraintsFromSetJob_Application_Event_Reference($job_Application_Event_Reference))) {
            throw new \InvalidArgumentException($job_Application_Event_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($job_Application_Event_Reference) || (is_array($job_Application_Event_Reference) && empty($job_Application_Event_Reference))) {
            unset($this->Job_Application_Event_Reference);
        } else {
            $this->Job_Application_Event_Reference = $job_Application_Event_Reference;
        }
        return $this;
    }
    /**
     * Get Job_Application_Reference value
     * @return \StructType\Job_ApplicationObjectType|null
     */
    public function getJob_Application_Reference()
    {
        return isset($this->Job_Application_Reference) ? $this->Job_Application_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setJob_Application_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Application_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateJob_Application_ReferenceForChoiceConstraintsFromSetJob_Application_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Job_Application_Event_Reference',
            'Candidate_Criteria_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Job_Application_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Job_Application_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Job_Application_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @return \StructType\Employment_Agreement_DataType
     */
    public function setJob_Application_Reference(\StructType\Job_ApplicationObjectType $job_Application_Reference = null)
    {
        // validation for constraint: choice(Job_Application_Event_Reference, Job_Application_Reference, Candidate_Criteria_Data)
        if ('' !== ($job_Application_ReferenceChoiceErrorMessage = self::validateJob_Application_ReferenceForChoiceConstraintsFromSetJob_Application_Reference($job_Application_Reference))) {
            throw new \InvalidArgumentException($job_Application_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($job_Application_Reference) || (is_array($job_Application_Reference) && empty($job_Application_Reference))) {
            unset($this->Job_Application_Reference);
        } else {
            $this->Job_Application_Reference = $job_Application_Reference;
        }
        return $this;
    }
    /**
     * Get Candidate_Criteria_Data value
     * @return \StructType\Move_Candidate_CriteriaType|null
     */
    public function getCandidate_Criteria_Data()
    {
        return isset($this->Candidate_Criteria_Data) ? $this->Candidate_Criteria_Data : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCandidate_Criteria_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCandidate_Criteria_Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCandidate_Criteria_DataForChoiceConstraintsFromSetCandidate_Criteria_Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Job_Application_Event_Reference',
            'Job_Application_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Candidate_Criteria_Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Candidate_Criteria_Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Candidate_Criteria_Data value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Move_Candidate_CriteriaType $candidate_Criteria_Data
     * @return \StructType\Employment_Agreement_DataType
     */
    public function setCandidate_Criteria_Data(\StructType\Move_Candidate_CriteriaType $candidate_Criteria_Data = null)
    {
        // validation for constraint: choice(Job_Application_Event_Reference, Job_Application_Reference, Candidate_Criteria_Data)
        if ('' !== ($candidate_Criteria_DataChoiceErrorMessage = self::validateCandidate_Criteria_DataForChoiceConstraintsFromSetCandidate_Criteria_Data($candidate_Criteria_Data))) {
            throw new \InvalidArgumentException($candidate_Criteria_DataChoiceErrorMessage, __LINE__);
        }
        if (is_null($candidate_Criteria_Data) || (is_array($candidate_Criteria_Data) && empty($candidate_Criteria_Data))) {
            unset($this->Candidate_Criteria_Data);
        } else {
            $this->Candidate_Criteria_Data = $candidate_Criteria_Data;
        }
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Employment_Agreement_DataType
     */
    public function setBusiness_Process_Parameters(\StructType\Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Employment_Agreement_Event_Data value
     * @return \StructType\Offer_Event_DataType|null
     */
    public function getEmployment_Agreement_Event_Data()
    {
        return $this->Employment_Agreement_Event_Data;
    }
    /**
     * Set Employment_Agreement_Event_Data value
     * @param \StructType\Offer_Event_DataType $employment_Agreement_Event_Data
     * @return \StructType\Employment_Agreement_DataType
     */
    public function setEmployment_Agreement_Event_Data(\StructType\Offer_Event_DataType $employment_Agreement_Event_Data = null)
    {
        $this->Employment_Agreement_Event_Data = $employment_Agreement_Event_Data;
        return $this;
    }
    /**
     * Get Propose_Compensation_Sub_Process value
     * @return \StructType\Propose_Compensation_For_Employment_Sub_Business_ProcessType|null
     */
    public function getPropose_Compensation_Sub_Process()
    {
        return $this->Propose_Compensation_Sub_Process;
    }
    /**
     * Set Propose_Compensation_Sub_Process value
     * @param \StructType\Propose_Compensation_For_Employment_Sub_Business_ProcessType $propose_Compensation_Sub_Process
     * @return \StructType\Employment_Agreement_DataType
     */
    public function setPropose_Compensation_Sub_Process(\StructType\Propose_Compensation_For_Employment_Sub_Business_ProcessType $propose_Compensation_Sub_Process = null)
    {
        $this->Propose_Compensation_Sub_Process = $propose_Compensation_Sub_Process;
        return $this;
    }
    /**
     * Get Request_One_Time_Payment_Sub_Process value
     * @return \StructType\Request_One_Time_Payment_Sub_Business_ProcessType|null
     */
    public function getRequest_One_Time_Payment_Sub_Process()
    {
        return $this->Request_One_Time_Payment_Sub_Process;
    }
    /**
     * Set Request_One_Time_Payment_Sub_Process value
     * @param \StructType\Request_One_Time_Payment_Sub_Business_ProcessType $request_One_Time_Payment_Sub_Process
     * @return \StructType\Employment_Agreement_DataType
     */
    public function setRequest_One_Time_Payment_Sub_Process(\StructType\Request_One_Time_Payment_Sub_Business_ProcessType $request_One_Time_Payment_Sub_Process = null)
    {
        $this->Request_One_Time_Payment_Sub_Process = $request_One_Time_Payment_Sub_Process;
        return $this;
    }
    /**
     * Get Request_Stock_Grant_Sub_Process value
     * @return \StructType\Request_Stock_Offer_Sub_Business_ProcessType|null
     */
    public function getRequest_Stock_Grant_Sub_Process()
    {
        return $this->Request_Stock_Grant_Sub_Process;
    }
    /**
     * Set Request_Stock_Grant_Sub_Process value
     * @param \StructType\Request_Stock_Offer_Sub_Business_ProcessType $request_Stock_Grant_Sub_Process
     * @return \StructType\Employment_Agreement_DataType
     */
    public function setRequest_Stock_Grant_Sub_Process(\StructType\Request_Stock_Offer_Sub_Business_ProcessType $request_Stock_Grant_Sub_Process = null)
    {
        $this->Request_Stock_Grant_Sub_Process = $request_Stock_Grant_Sub_Process;
        return $this;
    }
    /**
     * Get Pre_Hire_Probation_Period_Sub_Process value
     * @return \StructType\Pre_Hire_Probation_Period_Sub_Business_ProcessType|null
     */
    public function getPre_Hire_Probation_Period_Sub_Process()
    {
        return $this->{'Pre-Hire_Probation_Period_Sub_Process'};
    }
    /**
     * Set Pre_Hire_Probation_Period_Sub_Process value
     * @param \StructType\Pre_Hire_Probation_Period_Sub_Business_ProcessType $pre_Hire_Probation_Period_Sub_Process
     * @return \StructType\Employment_Agreement_DataType
     */
    public function setPre_Hire_Probation_Period_Sub_Process(\StructType\Pre_Hire_Probation_Period_Sub_Business_ProcessType $pre_Hire_Probation_Period_Sub_Process = null)
    {
        $this->Pre_Hire_Probation_Period_Sub_Process = $this->{'Pre-Hire_Probation_Period_Sub_Process'} = $pre_Hire_Probation_Period_Sub_Process;
        return $this;
    }
    /**
     * Get Pre_Hire_Contract_Details_Sub_Process value
     * @return \StructType\Pre_Hire_Contract_Details_Sub_Business_ProcessType|null
     */
    public function getPre_Hire_Contract_Details_Sub_Process()
    {
        return $this->{'Pre-Hire_Contract_Details_Sub_Process'};
    }
    /**
     * Set Pre_Hire_Contract_Details_Sub_Process value
     * @param \StructType\Pre_Hire_Contract_Details_Sub_Business_ProcessType $pre_Hire_Contract_Details_Sub_Process
     * @return \StructType\Employment_Agreement_DataType
     */
    public function setPre_Hire_Contract_Details_Sub_Process(\StructType\Pre_Hire_Contract_Details_Sub_Business_ProcessType $pre_Hire_Contract_Details_Sub_Process = null)
    {
        $this->Pre_Hire_Contract_Details_Sub_Process = $this->{'Pre-Hire_Contract_Details_Sub_Process'} = $pre_Hire_Contract_Details_Sub_Process;
        return $this;
    }
    /**
     * Get Pre_Hire_Collective_Agreement_Sub_Process value
     * @return \StructType\Assign_Employee_Collective_Agreement_Sub_Business_ProcessType|null
     */
    public function getPre_Hire_Collective_Agreement_Sub_Process()
    {
        return $this->{'Pre-Hire_Collective_Agreement_Sub_Process'};
    }
    /**
     * Set Pre_Hire_Collective_Agreement_Sub_Process value
     * @param \StructType\Assign_Employee_Collective_Agreement_Sub_Business_ProcessType $pre_Hire_Collective_Agreement_Sub_Process
     * @return \StructType\Employment_Agreement_DataType
     */
    public function setPre_Hire_Collective_Agreement_Sub_Process(\StructType\Assign_Employee_Collective_Agreement_Sub_Business_ProcessType $pre_Hire_Collective_Agreement_Sub_Process = null)
    {
        $this->Pre_Hire_Collective_Agreement_Sub_Process = $this->{'Pre-Hire_Collective_Agreement_Sub_Process'} = $pre_Hire_Collective_Agreement_Sub_Process;
        return $this;
    }
    /**
     * Get Pre_Hire_Edit_Notice_Period_Sub_Process value
     * @return \StructType\Edit_Notice_Periods_Sub_Business_ProcessType|null
     */
    public function getPre_Hire_Edit_Notice_Period_Sub_Process()
    {
        return $this->{'Pre-Hire_Edit_Notice_Period_Sub_Process'};
    }
    /**
     * Set Pre_Hire_Edit_Notice_Period_Sub_Process value
     * @param \StructType\Edit_Notice_Periods_Sub_Business_ProcessType $pre_Hire_Edit_Notice_Period_Sub_Process
     * @return \StructType\Employment_Agreement_DataType
     */
    public function setPre_Hire_Edit_Notice_Period_Sub_Process(\StructType\Edit_Notice_Periods_Sub_Business_ProcessType $pre_Hire_Edit_Notice_Period_Sub_Process = null)
    {
        $this->Pre_Hire_Edit_Notice_Period_Sub_Process = $this->{'Pre-Hire_Edit_Notice_Period_Sub_Process'} = $pre_Hire_Edit_Notice_Period_Sub_Process;
        return $this;
    }
}
