<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Edit_Job_Requisition_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper for Edit Job Requisition Reason, Data, and Sub Processes
 * @subpackage Structs
 */
class Edit_Job_Requisition_DataType extends AbstractStructBase
{
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contains information about the candidate and their photo.
     * @var \StructType\Job_RequisitionObjectType
     */
    public $Job_Requisition_Reference;
    /**
     * The Edit_Job_Requisition_Event_Data
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element for the Edit Job Requisition Event and the related Job Requisition.
     * - minOccurs: 0
     * @var \StructType\Edit_Job_Requisition_Event_DataType
     */
    public $Edit_Job_Requisition_Event_Data;
    /**
     * The Check_Position_Budget_Sub_Process
     * Meta information extracted from the WSDL
     * - documentation: Run the Check Position Budget Sub Business Process to calculate any commitments and obligations for the outbound and/or inbound positions on this event to enable budget checking.
     * - minOccurs: 0
     * @var \StructType\Check_Position_Budget_Sub_Business_ProcessType
     */
    public $Check_Position_Budget_Sub_Process;
    /**
     * The Unpost_Job_Sub_Business_Process
     * Meta information extracted from the WSDL
     * - documentation: Run the Update Job Posting sub business process to unpost the job postings associated with this Job Requisition. To use, Unpost Job must be enabled in the workflow definition for Edit Job Requisition.
     * - minOccurs: 0
     * @var \StructType\Unpost_Job_Sub_Business_ProcessType
     */
    public $Unpost_Job_Sub_Business_Process;
    /**
     * The Post_Job_Sub_Business_Process
     * Meta information extracted from the WSDL
     * - documentation: Run the Post Job Sub Business Process to post this job requisition to one or more Job Posting Sites. To use, Post Job must be enabled in the workflow definition for Edit Job Requisition.
     * - minOccurs: 0
     * @var \StructType\Post_Job_Sub_Business_ProcessType
     */
    public $Post_Job_Sub_Business_Process;
    /**
     * The Assign_Organization_Roles_Sub_Process
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Assign_Organization_Roles_Sub_Business_ProcessType
     */
    public $Assign_Organization_Roles_Sub_Process;
    /**
     * The Request_Requisition_Compensation_Sub_Process
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Request_Requisition_Compensation_Sub_ProcessType
     */
    public $Request_Requisition_Compensation_Sub_Process;
    /**
     * Constructor method for Edit_Job_Requisition_DataType
     * @uses Edit_Job_Requisition_DataType::setJob_Requisition_Reference()
     * @uses Edit_Job_Requisition_DataType::setEdit_Job_Requisition_Event_Data()
     * @uses Edit_Job_Requisition_DataType::setCheck_Position_Budget_Sub_Process()
     * @uses Edit_Job_Requisition_DataType::setUnpost_Job_Sub_Business_Process()
     * @uses Edit_Job_Requisition_DataType::setPost_Job_Sub_Business_Process()
     * @uses Edit_Job_Requisition_DataType::setAssign_Organization_Roles_Sub_Process()
     * @uses Edit_Job_Requisition_DataType::setRequest_Requisition_Compensation_Sub_Process()
     * @param \StructType\Job_RequisitionObjectType $job_Requisition_Reference
     * @param \StructType\Edit_Job_Requisition_Event_DataType $edit_Job_Requisition_Event_Data
     * @param \StructType\Check_Position_Budget_Sub_Business_ProcessType $check_Position_Budget_Sub_Process
     * @param \StructType\Unpost_Job_Sub_Business_ProcessType $unpost_Job_Sub_Business_Process
     * @param \StructType\Post_Job_Sub_Business_ProcessType $post_Job_Sub_Business_Process
     * @param \StructType\Assign_Organization_Roles_Sub_Business_ProcessType $assign_Organization_Roles_Sub_Process
     * @param \StructType\Request_Requisition_Compensation_Sub_ProcessType $request_Requisition_Compensation_Sub_Process
     */
    public function __construct(\StructType\Job_RequisitionObjectType $job_Requisition_Reference = null, \StructType\Edit_Job_Requisition_Event_DataType $edit_Job_Requisition_Event_Data = null, \StructType\Check_Position_Budget_Sub_Business_ProcessType $check_Position_Budget_Sub_Process = null, \StructType\Unpost_Job_Sub_Business_ProcessType $unpost_Job_Sub_Business_Process = null, \StructType\Post_Job_Sub_Business_ProcessType $post_Job_Sub_Business_Process = null, \StructType\Assign_Organization_Roles_Sub_Business_ProcessType $assign_Organization_Roles_Sub_Process = null, \StructType\Request_Requisition_Compensation_Sub_ProcessType $request_Requisition_Compensation_Sub_Process = null)
    {
        $this
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setEdit_Job_Requisition_Event_Data($edit_Job_Requisition_Event_Data)
            ->setCheck_Position_Budget_Sub_Process($check_Position_Budget_Sub_Process)
            ->setUnpost_Job_Sub_Business_Process($unpost_Job_Sub_Business_Process)
            ->setPost_Job_Sub_Business_Process($post_Job_Sub_Business_Process)
            ->setAssign_Organization_Roles_Sub_Process($assign_Organization_Roles_Sub_Process)
            ->setRequest_Requisition_Compensation_Sub_Process($request_Requisition_Compensation_Sub_Process);
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_RequisitionObjectType|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * Set Job_Requisition_Reference value
     * @param \StructType\Job_RequisitionObjectType $job_Requisition_Reference
     * @return \StructType\Edit_Job_Requisition_DataType
     */
    public function setJob_Requisition_Reference(\StructType\Job_RequisitionObjectType $job_Requisition_Reference = null)
    {
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Get Edit_Job_Requisition_Event_Data value
     * @return \StructType\Edit_Job_Requisition_Event_DataType|null
     */
    public function getEdit_Job_Requisition_Event_Data()
    {
        return $this->Edit_Job_Requisition_Event_Data;
    }
    /**
     * Set Edit_Job_Requisition_Event_Data value
     * @param \StructType\Edit_Job_Requisition_Event_DataType $edit_Job_Requisition_Event_Data
     * @return \StructType\Edit_Job_Requisition_DataType
     */
    public function setEdit_Job_Requisition_Event_Data(\StructType\Edit_Job_Requisition_Event_DataType $edit_Job_Requisition_Event_Data = null)
    {
        $this->Edit_Job_Requisition_Event_Data = $edit_Job_Requisition_Event_Data;
        return $this;
    }
    /**
     * Get Check_Position_Budget_Sub_Process value
     * @return \StructType\Check_Position_Budget_Sub_Business_ProcessType|null
     */
    public function getCheck_Position_Budget_Sub_Process()
    {
        return $this->Check_Position_Budget_Sub_Process;
    }
    /**
     * Set Check_Position_Budget_Sub_Process value
     * @param \StructType\Check_Position_Budget_Sub_Business_ProcessType $check_Position_Budget_Sub_Process
     * @return \StructType\Edit_Job_Requisition_DataType
     */
    public function setCheck_Position_Budget_Sub_Process(\StructType\Check_Position_Budget_Sub_Business_ProcessType $check_Position_Budget_Sub_Process = null)
    {
        $this->Check_Position_Budget_Sub_Process = $check_Position_Budget_Sub_Process;
        return $this;
    }
    /**
     * Get Unpost_Job_Sub_Business_Process value
     * @return \StructType\Unpost_Job_Sub_Business_ProcessType|null
     */
    public function getUnpost_Job_Sub_Business_Process()
    {
        return $this->Unpost_Job_Sub_Business_Process;
    }
    /**
     * Set Unpost_Job_Sub_Business_Process value
     * @param \StructType\Unpost_Job_Sub_Business_ProcessType $unpost_Job_Sub_Business_Process
     * @return \StructType\Edit_Job_Requisition_DataType
     */
    public function setUnpost_Job_Sub_Business_Process(\StructType\Unpost_Job_Sub_Business_ProcessType $unpost_Job_Sub_Business_Process = null)
    {
        $this->Unpost_Job_Sub_Business_Process = $unpost_Job_Sub_Business_Process;
        return $this;
    }
    /**
     * Get Post_Job_Sub_Business_Process value
     * @return \StructType\Post_Job_Sub_Business_ProcessType|null
     */
    public function getPost_Job_Sub_Business_Process()
    {
        return $this->Post_Job_Sub_Business_Process;
    }
    /**
     * Set Post_Job_Sub_Business_Process value
     * @param \StructType\Post_Job_Sub_Business_ProcessType $post_Job_Sub_Business_Process
     * @return \StructType\Edit_Job_Requisition_DataType
     */
    public function setPost_Job_Sub_Business_Process(\StructType\Post_Job_Sub_Business_ProcessType $post_Job_Sub_Business_Process = null)
    {
        $this->Post_Job_Sub_Business_Process = $post_Job_Sub_Business_Process;
        return $this;
    }
    /**
     * Get Assign_Organization_Roles_Sub_Process value
     * @return \StructType\Assign_Organization_Roles_Sub_Business_ProcessType|null
     */
    public function getAssign_Organization_Roles_Sub_Process()
    {
        return $this->Assign_Organization_Roles_Sub_Process;
    }
    /**
     * Set Assign_Organization_Roles_Sub_Process value
     * @param \StructType\Assign_Organization_Roles_Sub_Business_ProcessType $assign_Organization_Roles_Sub_Process
     * @return \StructType\Edit_Job_Requisition_DataType
     */
    public function setAssign_Organization_Roles_Sub_Process(\StructType\Assign_Organization_Roles_Sub_Business_ProcessType $assign_Organization_Roles_Sub_Process = null)
    {
        $this->Assign_Organization_Roles_Sub_Process = $assign_Organization_Roles_Sub_Process;
        return $this;
    }
    /**
     * Get Request_Requisition_Compensation_Sub_Process value
     * @return \StructType\Request_Requisition_Compensation_Sub_ProcessType|null
     */
    public function getRequest_Requisition_Compensation_Sub_Process()
    {
        return $this->Request_Requisition_Compensation_Sub_Process;
    }
    /**
     * Set Request_Requisition_Compensation_Sub_Process value
     * @param \StructType\Request_Requisition_Compensation_Sub_ProcessType $request_Requisition_Compensation_Sub_Process
     * @return \StructType\Edit_Job_Requisition_DataType
     */
    public function setRequest_Requisition_Compensation_Sub_Process(\StructType\Request_Requisition_Compensation_Sub_ProcessType $request_Requisition_Compensation_Sub_Process = null)
    {
        $this->Request_Requisition_Compensation_Sub_Process = $request_Requisition_Compensation_Sub_Process;
        return $this;
    }
}
