<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Edit_Evergreen_Requisition_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Top-level response element for Edit Evergreen Requisition operation.
 * @subpackage Structs
 */
class Edit_Evergreen_Requisition_ResponseType extends AbstractStructBase
{
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for the Evergreen Job Requisition that was edited.
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_EnabledObjectType
     */
    public $Job_Requisition_Reference;
    /**
     * The Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for the Edit Evergreen Job Requisition Event that was performed.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Event_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Edit_Evergreen_Requisition_ResponseType
     * @uses Edit_Evergreen_Requisition_ResponseType::setJob_Requisition_Reference()
     * @uses Edit_Evergreen_Requisition_ResponseType::setEvent_Reference()
     * @uses Edit_Evergreen_Requisition_ResponseType::setVersion()
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @param \StructType\Unique_IdentifierObjectType $event_Reference
     * @param string $version
     */
    public function __construct(\StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null, \StructType\Unique_IdentifierObjectType $event_Reference = null, $version = null)
    {
        $this
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setEvent_Reference($event_Reference)
            ->setVersion($version);
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_Requisition_EnabledObjectType|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * Set Job_Requisition_Reference value
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @return \StructType\Edit_Evergreen_Requisition_ResponseType
     */
    public function setJob_Requisition_Reference(\StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null)
    {
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Get Event_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getEvent_Reference()
    {
        return $this->Event_Reference;
    }
    /**
     * Set Event_Reference value
     * @param \StructType\Unique_IdentifierObjectType $event_Reference
     * @return \StructType\Edit_Evergreen_Requisition_ResponseType
     */
    public function setEvent_Reference(\StructType\Unique_IdentifierObjectType $event_Reference = null)
    {
        $this->Event_Reference = $event_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Edit_Evergreen_Requisition_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
