<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Edit_Evergreen_Requisition_Event_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for reference to evergreen job requisition and evergreen job requisition data element.
 * @subpackage Structs
 */
class Edit_Evergreen_Requisition_Event_DataType extends AbstractStructBase
{
    /**
     * The Supervisory_Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Supervisory Organization this requisition is being created for. The position must be in a job management organization, and the tenant must have evergreen requisitions enabled for job management.
     * - minOccurs: 0
     * @var \StructType\Supervisory_OrganizationObjectType
     */
    public $Supervisory_Organization_Reference;
    /**
     * The Edit_Evergreen_Requisition_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for a Reason for the Edit Evergreen Requisition Business Process.
     * @var \StructType\Event_Classification_SubcategoryObjectType
     */
    public $Edit_Evergreen_Requisition_Reason_Reference;
    /**
     * The Evergreen_Requisition_Data
     * Meta information extracted from the WSDL
     * - documentation: The Evergreen Job Requisition Data for Create and Edit sub-element.
     * - maxOccurs: unbounded
     * @var \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType[]
     */
    public $Evergreen_Requisition_Data;
    /**
     * Constructor method for Edit_Evergreen_Requisition_Event_DataType
     * @uses Edit_Evergreen_Requisition_Event_DataType::setSupervisory_Organization_Reference()
     * @uses Edit_Evergreen_Requisition_Event_DataType::setEdit_Evergreen_Requisition_Reason_Reference()
     * @uses Edit_Evergreen_Requisition_Event_DataType::setEvergreen_Requisition_Data()
     * @param \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference
     * @param \StructType\Event_Classification_SubcategoryObjectType $edit_Evergreen_Requisition_Reason_Reference
     * @param \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType[] $evergreen_Requisition_Data
     */
    public function __construct(\StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference = null, \StructType\Event_Classification_SubcategoryObjectType $edit_Evergreen_Requisition_Reason_Reference = null, array $evergreen_Requisition_Data = array())
    {
        $this
            ->setSupervisory_Organization_Reference($supervisory_Organization_Reference)
            ->setEdit_Evergreen_Requisition_Reason_Reference($edit_Evergreen_Requisition_Reason_Reference)
            ->setEvergreen_Requisition_Data($evergreen_Requisition_Data);
    }
    /**
     * Get Supervisory_Organization_Reference value
     * @return \StructType\Supervisory_OrganizationObjectType|null
     */
    public function getSupervisory_Organization_Reference()
    {
        return $this->Supervisory_Organization_Reference;
    }
    /**
     * Set Supervisory_Organization_Reference value
     * @param \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference
     * @return \StructType\Edit_Evergreen_Requisition_Event_DataType
     */
    public function setSupervisory_Organization_Reference(\StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference = null)
    {
        $this->Supervisory_Organization_Reference = $supervisory_Organization_Reference;
        return $this;
    }
    /**
     * Get Edit_Evergreen_Requisition_Reason_Reference value
     * @return \StructType\Event_Classification_SubcategoryObjectType|null
     */
    public function getEdit_Evergreen_Requisition_Reason_Reference()
    {
        return $this->Edit_Evergreen_Requisition_Reason_Reference;
    }
    /**
     * Set Edit_Evergreen_Requisition_Reason_Reference value
     * @param \StructType\Event_Classification_SubcategoryObjectType $edit_Evergreen_Requisition_Reason_Reference
     * @return \StructType\Edit_Evergreen_Requisition_Event_DataType
     */
    public function setEdit_Evergreen_Requisition_Reason_Reference(\StructType\Event_Classification_SubcategoryObjectType $edit_Evergreen_Requisition_Reason_Reference = null)
    {
        $this->Edit_Evergreen_Requisition_Reason_Reference = $edit_Evergreen_Requisition_Reason_Reference;
        return $this;
    }
    /**
     * Get Evergreen_Requisition_Data value
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType[]|null
     */
    public function getEvergreen_Requisition_Data()
    {
        return $this->Evergreen_Requisition_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setEvergreen_Requisition_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEvergreen_Requisition_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEvergreen_Requisition_DataForArrayConstraintsFromSetEvergreen_Requisition_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $edit_Evergreen_Requisition_Event_DataTypeEvergreen_Requisition_DataItem) {
            // validation for constraint: itemType
            if (!$edit_Evergreen_Requisition_Event_DataTypeEvergreen_Requisition_DataItem instanceof \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType) {
                $invalidValues[] = is_object($edit_Evergreen_Requisition_Event_DataTypeEvergreen_Requisition_DataItem) ? get_class($edit_Evergreen_Requisition_Event_DataTypeEvergreen_Requisition_DataItem) : sprintf('%s(%s)', gettype($edit_Evergreen_Requisition_Event_DataTypeEvergreen_Requisition_DataItem), var_export($edit_Evergreen_Requisition_Event_DataTypeEvergreen_Requisition_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Evergreen_Requisition_Data property can only contain items of type \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Evergreen_Requisition_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType[] $evergreen_Requisition_Data
     * @return \StructType\Edit_Evergreen_Requisition_Event_DataType
     */
    public function setEvergreen_Requisition_Data(array $evergreen_Requisition_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($evergreen_Requisition_DataArrayErrorMessage = self::validateEvergreen_Requisition_DataForArrayConstraintsFromSetEvergreen_Requisition_Data($evergreen_Requisition_Data))) {
            throw new \InvalidArgumentException($evergreen_Requisition_DataArrayErrorMessage, __LINE__);
        }
        $this->Evergreen_Requisition_Data = $evergreen_Requisition_Data;
        return $this;
    }
    /**
     * Add item to Evergreen_Requisition_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType $item
     * @return \StructType\Edit_Evergreen_Requisition_Event_DataType
     */
    public function addToEvergreen_Requisition_Data(\StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType) {
            throw new \InvalidArgumentException(sprintf('The Evergreen_Requisition_Data property can only contain items of type \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Evergreen_Requisition_Data[] = $item;
        return $this;
    }
}
