<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Edit_Assign_Position_Organization_Sub_Business_ProcessType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for the Assign Organizations to Position sub business process.If this element is submitted (Auto or Manual) as part of a Staffing event and the Position_Organization_Assignment wrapper is not submitted, then the
 * position's organization assignments will default from the supervisory organization.
 * @subpackage Structs
 */
class Edit_Assign_Position_Organization_Sub_Business_ProcessType extends AbstractStructBase
{
    /**
     * The Business_Sub_Process_Parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Business_Sub_Process_ParametersType
     */
    public $Business_Sub_Process_Parameters;
    /**
     * The Position_Organization_Assignments_Data
     * Meta information extracted from the WSDL
     * - documentation: Organization Assignments to a filled Position.The existing organization assignment will be retained if the element is not submitted.
     * - minOccurs: 0
     * @var \StructType\Assign_Position_Organization_Event_DataType
     */
    public $Position_Organization_Assignments_Data;
    /**
     * Constructor method for
     * Edit_Assign_Position_Organization_Sub_Business_ProcessType
     * @uses Edit_Assign_Position_Organization_Sub_Business_ProcessType::setBusiness_Sub_Process_Parameters()
     * @uses Edit_Assign_Position_Organization_Sub_Business_ProcessType::setPosition_Organization_Assignments_Data()
     * @param \StructType\Business_Sub_Process_ParametersType $business_Sub_Process_Parameters
     * @param \StructType\Assign_Position_Organization_Event_DataType $position_Organization_Assignments_Data
     */
    public function __construct(\StructType\Business_Sub_Process_ParametersType $business_Sub_Process_Parameters = null, \StructType\Assign_Position_Organization_Event_DataType $position_Organization_Assignments_Data = null)
    {
        $this
            ->setBusiness_Sub_Process_Parameters($business_Sub_Process_Parameters)
            ->setPosition_Organization_Assignments_Data($position_Organization_Assignments_Data);
    }
    /**
     * Get Business_Sub_Process_Parameters value
     * @return \StructType\Business_Sub_Process_ParametersType|null
     */
    public function getBusiness_Sub_Process_Parameters()
    {
        return $this->Business_Sub_Process_Parameters;
    }
    /**
     * Set Business_Sub_Process_Parameters value
     * @param \StructType\Business_Sub_Process_ParametersType $business_Sub_Process_Parameters
     * @return \StructType\Edit_Assign_Position_Organization_Sub_Business_ProcessType
     */
    public function setBusiness_Sub_Process_Parameters(\StructType\Business_Sub_Process_ParametersType $business_Sub_Process_Parameters = null)
    {
        $this->Business_Sub_Process_Parameters = $business_Sub_Process_Parameters;
        return $this;
    }
    /**
     * Get Position_Organization_Assignments_Data value
     * @return \StructType\Assign_Position_Organization_Event_DataType|null
     */
    public function getPosition_Organization_Assignments_Data()
    {
        return $this->Position_Organization_Assignments_Data;
    }
    /**
     * Set Position_Organization_Assignments_Data value
     * @param \StructType\Assign_Position_Organization_Event_DataType $position_Organization_Assignments_Data
     * @return \StructType\Edit_Assign_Position_Organization_Sub_Business_ProcessType
     */
    public function setPosition_Organization_Assignments_Data(\StructType\Assign_Position_Organization_Event_DataType $position_Organization_Assignments_Data = null)
    {
        $this->Position_Organization_Assignments_Data = $position_Organization_Assignments_Data;
        return $this;
    }
}
