<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Country_Personal_Information_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specify a social benefits locality value that is available for the selected country. This value isn't available for the selected country. | Specify an ethnicity visual survey value that is available for the selected country. This
 * value isn't available for the selected country. | Specify a marital status value that is available for the selected country. This value isn't available for the selected country. | Specify an ethnicity details value that is available for the selected
 * country. This value isn't available for the selected country. | Hispanic Latino Visual Survey is only supported for United States | Local Hukou is only tracked in China | Specify a political affiliation value that is available for the selected
 * country. This value isn't available for the selected country. | Hispanic Latino is only supported for United States | Specify an ethnicity value that is available for the selected country. This value isn't available for the selected country. |
 * Specify an LGBT identification value that is available for the selected country. This value isn't available for the selected country. | Specify a religion value that is available for the selected country. This value isn't available for the selected
 * country. | Specify a gender value that is available for the selected country. This value isn't available for the selected country. | The Race/Ethnicity Details value doesn't exist for the country of the worker's primary position. To configure
 * Race/Ethnicity Details values for the country of the position, use the Maintain Race/Ethnicity Details task. | Race/Ethnicity Details doesn't exist for the country of the worker's primary position. To enable Race/Ethnicity Details for the country of
 * the position, use the Maintain Localization Settings task. | Gender is not tracked for the specified Location Context. The Location Context is derived from the Country of the Location for the Position. | The Political Affiliation is not tracked for
 * the specified Location Context. The Location Context is derived from the Country of the Location. | Hukou Subregion is only tracked in China. | The field Race/Ethnicity is not tracked for the specified Location Context. The Location Context is
 * derived from the Country of the Location for the Position. | The Marital Status is not tracked for the specified Location Context. The Location Context is derived from the Country of the Location. | The field Marital Status is required and must have
 * a value if a Marital Status Date is entered. | Hukou Postal Code is only tracked for China. | Native Region is only tracked in China. | Personnel File Agency is only tracked in China. | Hukou Region is only tracked for China. | Native Region
 * Descriptor is only tracked in China. | The social benefits locality does not exist in the specified Location Context. The Location Context is derived from the Country of the Location specified for the Position. Currently, the Social Benefits Locality
 * values are ignored for Puts involving applicants since a Social Benefits Locality value is associated with workers and not applicants. | The Political Affiliation does not exist in the specified Location Context. The Location Context is derived from
 * the Country of the Location specified for the Position. | The social benefits locality data has not been activated for this location via the Maintain Localization Settings task. | Hukou Locality is only tracked for China. | Hukou Type is only tracked
 * in China. | The religion is not valid for the specified Location Context. The Location Context is derived from the Country of the Location for the Position. | The Religion is not tracked for the specified Location Context. The Location Context is
 * derived from the Country of the Location. | Hispanic or Latino is not tracked for the specified Location Context. The Location Context is derived from the Country of the Location. | The ethnicity does not exist in the specified Location Context. The
 * Location Context is derived from the Country of the Location of the Position | The marital status does not exist in the specified Location Context. The Location Context is derived from the Country of the Location specified for the Position. | Country
 * Specific Personal Information
 * @subpackage Structs
 */
class Country_Personal_Information_DataType extends AbstractStructBase
{
    /**
     * The Marital_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Marital Status
     * - minOccurs: 0
     * @var \StructType\Marital_StatusObjectType
     */
    public $Marital_Status_Reference;
    /**
     * The Marital_Status_Date
     * Meta information extracted from the WSDL
     * - documentation: Marital Status date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Marital_Status_Date;
    /**
     * The Religion_Reference
     * Meta information extracted from the WSDL
     * - documentation: Religion
     * - minOccurs: 0
     * @var \StructType\ReligionObjectType
     */
    public $Religion_Reference;
    /**
     * The Disability_Status_Data
     * Meta information extracted from the WSDL
     * - documentation: Disability
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Person_Disability_Status_DataType[]
     */
    public $Disability_Status_Data;
    /**
     * The Ethnicity_Reference
     * Meta information extracted from the WSDL
     * - documentation: Ethnicity
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EthnicityObjectType[]
     */
    public $Ethnicity_Reference;
    /**
     * The Race_Ethnicity_Details_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for the person's Race/Ethnicity Details.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Ethnicity_DetailsObjectType[]
     */
    public $Race_Ethnicity_Details_Reference;
    /**
     * The Ethnicity_Visual_Survey_Reference
     * Meta information extracted from the WSDL
     * - documentation: Race/Ethnicity Visual Survey
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EthnicityObjectType[]
     */
    public $Ethnicity_Visual_Survey_Reference;
    /**
     * The Hispanic_or_Latino
     * Meta information extracted from the WSDL
     * - documentation: Hispanic or Latino
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Hispanic_or_Latino;
    /**
     * The Hispanic_or_Latino_Visual_Survey
     * Meta information extracted from the WSDL
     * - documentation: Hispanic Latino Visual Survey
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Hispanic_or_Latino_Visual_Survey;
    /**
     * The Aboriginal_Indigenous_Identification_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for a person's Aboriginal/Indigenous Identification.
     * - minOccurs: 0
     * @var \StructType\Aboriginal_Indigenous_Identification_SelectionObjectType
     */
    public $Aboriginal_Indigenous_Identification_Reference;
    /**
     * The Aboriginal_Indigenous_Identification_Details_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for a person's Aboriginal/Indigenous Identification Details.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Aboriginal_Indigenous_DetailsObjectType[]
     */
    public $Aboriginal_Indigenous_Identification_Details_Reference;
    /**
     * The Hukou_Region_Reference
     * Meta information extracted from the WSDL
     * - documentation: Hukou Region
     * - minOccurs: 0
     * @var \StructType\Country_RegionObjectType
     */
    public $Hukou_Region_Reference;
    /**
     * The Hukou_Subregion_Reference
     * Meta information extracted from the WSDL
     * - documentation: Hukou Subregion
     * - minOccurs: 0
     * @var \StructType\Country_SubregionObjectType
     */
    public $Hukou_Subregion_Reference;
    /**
     * The Hukou_Locality
     * Meta information extracted from the WSDL
     * - documentation: Hukou Locality
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Hukou_Locality;
    /**
     * The Hukou_Postal_Code
     * Meta information extracted from the WSDL
     * - documentation: Hukou Postal Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Hukou_Postal_Code;
    /**
     * The Hukou_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Hukou Type
     * - minOccurs: 0
     * @var \StructType\Hukou_TypeObjectType
     */
    public $Hukou_Type_Reference;
    /**
     * The Local_Hukou
     * Meta information extracted from the WSDL
     * - documentation: Local Hukou
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Local_Hukou;
    /**
     * The Native_Region_Reference
     * Meta information extracted from the WSDL
     * - documentation: Hukou Native Region
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Country_RegionObjectType[]
     */
    public $Native_Region_Reference;
    /**
     * The Native_Region_Descriptor
     * Meta information extracted from the WSDL
     * - documentation: Native Region Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Native_Region_Descriptor;
    /**
     * The Personnel_File_Agency_for_Person
     * Meta information extracted from the WSDL
     * - documentation: Personnel File Agency
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Personnel_File_Agency_for_Person;
    /**
     * The Political_Affiliation_Reference
     * Meta information extracted from the WSDL
     * - documentation: Political Affiliation
     * - minOccurs: 0
     * @var \StructType\Political_AffiliationObjectType
     */
    public $Political_Affiliation_Reference;
    /**
     * The Social_Benefits_Locality_Reference
     * Meta information extracted from the WSDL
     * - documentation: Social Benefits Locality
     * - minOccurs: 0
     * @var \StructType\Social_Benefits_LocalityObjectType
     */
    public $Social_Benefits_Locality_Reference;
    /**
     * The Relative_Name_Information_Data
     * Meta information extracted from the WSDL
     * - documentation: Relative Name Information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Relative_Name_DataType[]
     */
    public $Relative_Name_Information_Data;
    /**
     * The Sexual_Orientation_and_Gender_Identity_Reference
     * Meta information extracted from the WSDL
     * - documentation: Sexual Orientation & Gender Identity
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LGBT_IdentificationObjectType[]
     */
    public $Sexual_Orientation_and_Gender_Identity_Reference;
    /**
     * The Gender_Reference
     * Meta information extracted from the WSDL
     * - documentation: Gender
     * - minOccurs: 0
     * @var \StructType\GenderObjectType
     */
    public $Gender_Reference;
    /**
     * Constructor method for Country_Personal_Information_DataType
     * @uses Country_Personal_Information_DataType::setMarital_Status_Reference()
     * @uses Country_Personal_Information_DataType::setMarital_Status_Date()
     * @uses Country_Personal_Information_DataType::setReligion_Reference()
     * @uses Country_Personal_Information_DataType::setDisability_Status_Data()
     * @uses Country_Personal_Information_DataType::setEthnicity_Reference()
     * @uses Country_Personal_Information_DataType::setRace_Ethnicity_Details_Reference()
     * @uses Country_Personal_Information_DataType::setEthnicity_Visual_Survey_Reference()
     * @uses Country_Personal_Information_DataType::setHispanic_or_Latino()
     * @uses Country_Personal_Information_DataType::setHispanic_or_Latino_Visual_Survey()
     * @uses Country_Personal_Information_DataType::setAboriginal_Indigenous_Identification_Reference()
     * @uses Country_Personal_Information_DataType::setAboriginal_Indigenous_Identification_Details_Reference()
     * @uses Country_Personal_Information_DataType::setHukou_Region_Reference()
     * @uses Country_Personal_Information_DataType::setHukou_Subregion_Reference()
     * @uses Country_Personal_Information_DataType::setHukou_Locality()
     * @uses Country_Personal_Information_DataType::setHukou_Postal_Code()
     * @uses Country_Personal_Information_DataType::setHukou_Type_Reference()
     * @uses Country_Personal_Information_DataType::setLocal_Hukou()
     * @uses Country_Personal_Information_DataType::setNative_Region_Reference()
     * @uses Country_Personal_Information_DataType::setNative_Region_Descriptor()
     * @uses Country_Personal_Information_DataType::setPersonnel_File_Agency_for_Person()
     * @uses Country_Personal_Information_DataType::setPolitical_Affiliation_Reference()
     * @uses Country_Personal_Information_DataType::setSocial_Benefits_Locality_Reference()
     * @uses Country_Personal_Information_DataType::setRelative_Name_Information_Data()
     * @uses Country_Personal_Information_DataType::setSexual_Orientation_and_Gender_Identity_Reference()
     * @uses Country_Personal_Information_DataType::setGender_Reference()
     * @param \StructType\Marital_StatusObjectType $marital_Status_Reference
     * @param string $marital_Status_Date
     * @param \StructType\ReligionObjectType $religion_Reference
     * @param \StructType\Person_Disability_Status_DataType[] $disability_Status_Data
     * @param \StructType\EthnicityObjectType[] $ethnicity_Reference
     * @param \StructType\Ethnicity_DetailsObjectType[] $race_Ethnicity_Details_Reference
     * @param \StructType\EthnicityObjectType[] $ethnicity_Visual_Survey_Reference
     * @param bool $hispanic_or_Latino
     * @param bool $hispanic_or_Latino_Visual_Survey
     * @param \StructType\Aboriginal_Indigenous_Identification_SelectionObjectType $aboriginal_Indigenous_Identification_Reference
     * @param \StructType\Aboriginal_Indigenous_DetailsObjectType[] $aboriginal_Indigenous_Identification_Details_Reference
     * @param \StructType\Country_RegionObjectType $hukou_Region_Reference
     * @param \StructType\Country_SubregionObjectType $hukou_Subregion_Reference
     * @param string $hukou_Locality
     * @param string $hukou_Postal_Code
     * @param \StructType\Hukou_TypeObjectType $hukou_Type_Reference
     * @param bool $local_Hukou
     * @param \StructType\Country_RegionObjectType[] $native_Region_Reference
     * @param string $native_Region_Descriptor
     * @param string $personnel_File_Agency_for_Person
     * @param \StructType\Political_AffiliationObjectType $political_Affiliation_Reference
     * @param \StructType\Social_Benefits_LocalityObjectType $social_Benefits_Locality_Reference
     * @param \StructType\Relative_Name_DataType[] $relative_Name_Information_Data
     * @param \StructType\LGBT_IdentificationObjectType[] $sexual_Orientation_and_Gender_Identity_Reference
     * @param \StructType\GenderObjectType $gender_Reference
     */
    public function __construct(\StructType\Marital_StatusObjectType $marital_Status_Reference = null, $marital_Status_Date = null, \StructType\ReligionObjectType $religion_Reference = null, array $disability_Status_Data = array(), array $ethnicity_Reference = array(), array $race_Ethnicity_Details_Reference = array(), array $ethnicity_Visual_Survey_Reference = array(), $hispanic_or_Latino = null, $hispanic_or_Latino_Visual_Survey = null, \StructType\Aboriginal_Indigenous_Identification_SelectionObjectType $aboriginal_Indigenous_Identification_Reference = null, array $aboriginal_Indigenous_Identification_Details_Reference = array(), \StructType\Country_RegionObjectType $hukou_Region_Reference = null, \StructType\Country_SubregionObjectType $hukou_Subregion_Reference = null, $hukou_Locality = null, $hukou_Postal_Code = null, \StructType\Hukou_TypeObjectType $hukou_Type_Reference = null, $local_Hukou = null, array $native_Region_Reference = array(), $native_Region_Descriptor = null, $personnel_File_Agency_for_Person = null, \StructType\Political_AffiliationObjectType $political_Affiliation_Reference = null, \StructType\Social_Benefits_LocalityObjectType $social_Benefits_Locality_Reference = null, array $relative_Name_Information_Data = array(), array $sexual_Orientation_and_Gender_Identity_Reference = array(), \StructType\GenderObjectType $gender_Reference = null)
    {
        $this
            ->setMarital_Status_Reference($marital_Status_Reference)
            ->setMarital_Status_Date($marital_Status_Date)
            ->setReligion_Reference($religion_Reference)
            ->setDisability_Status_Data($disability_Status_Data)
            ->setEthnicity_Reference($ethnicity_Reference)
            ->setRace_Ethnicity_Details_Reference($race_Ethnicity_Details_Reference)
            ->setEthnicity_Visual_Survey_Reference($ethnicity_Visual_Survey_Reference)
            ->setHispanic_or_Latino($hispanic_or_Latino)
            ->setHispanic_or_Latino_Visual_Survey($hispanic_or_Latino_Visual_Survey)
            ->setAboriginal_Indigenous_Identification_Reference($aboriginal_Indigenous_Identification_Reference)
            ->setAboriginal_Indigenous_Identification_Details_Reference($aboriginal_Indigenous_Identification_Details_Reference)
            ->setHukou_Region_Reference($hukou_Region_Reference)
            ->setHukou_Subregion_Reference($hukou_Subregion_Reference)
            ->setHukou_Locality($hukou_Locality)
            ->setHukou_Postal_Code($hukou_Postal_Code)
            ->setHukou_Type_Reference($hukou_Type_Reference)
            ->setLocal_Hukou($local_Hukou)
            ->setNative_Region_Reference($native_Region_Reference)
            ->setNative_Region_Descriptor($native_Region_Descriptor)
            ->setPersonnel_File_Agency_for_Person($personnel_File_Agency_for_Person)
            ->setPolitical_Affiliation_Reference($political_Affiliation_Reference)
            ->setSocial_Benefits_Locality_Reference($social_Benefits_Locality_Reference)
            ->setRelative_Name_Information_Data($relative_Name_Information_Data)
            ->setSexual_Orientation_and_Gender_Identity_Reference($sexual_Orientation_and_Gender_Identity_Reference)
            ->setGender_Reference($gender_Reference);
    }
    /**
     * Get Marital_Status_Reference value
     * @return \StructType\Marital_StatusObjectType|null
     */
    public function getMarital_Status_Reference()
    {
        return $this->Marital_Status_Reference;
    }
    /**
     * Set Marital_Status_Reference value
     * @param \StructType\Marital_StatusObjectType $marital_Status_Reference
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setMarital_Status_Reference(\StructType\Marital_StatusObjectType $marital_Status_Reference = null)
    {
        $this->Marital_Status_Reference = $marital_Status_Reference;
        return $this;
    }
    /**
     * Get Marital_Status_Date value
     * @return string|null
     */
    public function getMarital_Status_Date()
    {
        return $this->Marital_Status_Date;
    }
    /**
     * Set Marital_Status_Date value
     * @param string $marital_Status_Date
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setMarital_Status_Date($marital_Status_Date = null)
    {
        // validation for constraint: string
        if (!is_null($marital_Status_Date) && !is_string($marital_Status_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marital_Status_Date, true), gettype($marital_Status_Date)), __LINE__);
        }
        $this->Marital_Status_Date = $marital_Status_Date;
        return $this;
    }
    /**
     * Get Religion_Reference value
     * @return \StructType\ReligionObjectType|null
     */
    public function getReligion_Reference()
    {
        return $this->Religion_Reference;
    }
    /**
     * Set Religion_Reference value
     * @param \StructType\ReligionObjectType $religion_Reference
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setReligion_Reference(\StructType\ReligionObjectType $religion_Reference = null)
    {
        $this->Religion_Reference = $religion_Reference;
        return $this;
    }
    /**
     * Get Disability_Status_Data value
     * @return \StructType\Person_Disability_Status_DataType[]|null
     */
    public function getDisability_Status_Data()
    {
        return $this->Disability_Status_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setDisability_Status_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDisability_Status_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDisability_Status_DataForArrayConstraintsFromSetDisability_Status_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $country_Personal_Information_DataTypeDisability_Status_DataItem) {
            // validation for constraint: itemType
            if (!$country_Personal_Information_DataTypeDisability_Status_DataItem instanceof \StructType\Person_Disability_Status_DataType) {
                $invalidValues[] = is_object($country_Personal_Information_DataTypeDisability_Status_DataItem) ? get_class($country_Personal_Information_DataTypeDisability_Status_DataItem) : sprintf('%s(%s)', gettype($country_Personal_Information_DataTypeDisability_Status_DataItem), var_export($country_Personal_Information_DataTypeDisability_Status_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Disability_Status_Data property can only contain items of type \StructType\Person_Disability_Status_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Disability_Status_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Person_Disability_Status_DataType[] $disability_Status_Data
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setDisability_Status_Data(array $disability_Status_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($disability_Status_DataArrayErrorMessage = self::validateDisability_Status_DataForArrayConstraintsFromSetDisability_Status_Data($disability_Status_Data))) {
            throw new \InvalidArgumentException($disability_Status_DataArrayErrorMessage, __LINE__);
        }
        $this->Disability_Status_Data = $disability_Status_Data;
        return $this;
    }
    /**
     * Add item to Disability_Status_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Person_Disability_Status_DataType $item
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function addToDisability_Status_Data(\StructType\Person_Disability_Status_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Person_Disability_Status_DataType) {
            throw new \InvalidArgumentException(sprintf('The Disability_Status_Data property can only contain items of type \StructType\Person_Disability_Status_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Disability_Status_Data[] = $item;
        return $this;
    }
    /**
     * Get Ethnicity_Reference value
     * @return \StructType\EthnicityObjectType[]|null
     */
    public function getEthnicity_Reference()
    {
        return $this->Ethnicity_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setEthnicity_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEthnicity_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEthnicity_ReferenceForArrayConstraintsFromSetEthnicity_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $country_Personal_Information_DataTypeEthnicity_ReferenceItem) {
            // validation for constraint: itemType
            if (!$country_Personal_Information_DataTypeEthnicity_ReferenceItem instanceof \StructType\EthnicityObjectType) {
                $invalidValues[] = is_object($country_Personal_Information_DataTypeEthnicity_ReferenceItem) ? get_class($country_Personal_Information_DataTypeEthnicity_ReferenceItem) : sprintf('%s(%s)', gettype($country_Personal_Information_DataTypeEthnicity_ReferenceItem), var_export($country_Personal_Information_DataTypeEthnicity_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Ethnicity_Reference property can only contain items of type \StructType\EthnicityObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Ethnicity_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\EthnicityObjectType[] $ethnicity_Reference
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setEthnicity_Reference(array $ethnicity_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($ethnicity_ReferenceArrayErrorMessage = self::validateEthnicity_ReferenceForArrayConstraintsFromSetEthnicity_Reference($ethnicity_Reference))) {
            throw new \InvalidArgumentException($ethnicity_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Ethnicity_Reference = $ethnicity_Reference;
        return $this;
    }
    /**
     * Add item to Ethnicity_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\EthnicityObjectType $item
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function addToEthnicity_Reference(\StructType\EthnicityObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EthnicityObjectType) {
            throw new \InvalidArgumentException(sprintf('The Ethnicity_Reference property can only contain items of type \StructType\EthnicityObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Ethnicity_Reference[] = $item;
        return $this;
    }
    /**
     * Get Race_Ethnicity_Details_Reference value
     * @return \StructType\Ethnicity_DetailsObjectType[]|null
     */
    public function getRace_Ethnicity_Details_Reference()
    {
        return $this->Race_Ethnicity_Details_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRace_Ethnicity_Details_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRace_Ethnicity_Details_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRace_Ethnicity_Details_ReferenceForArrayConstraintsFromSetRace_Ethnicity_Details_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $country_Personal_Information_DataTypeRace_Ethnicity_Details_ReferenceItem) {
            // validation for constraint: itemType
            if (!$country_Personal_Information_DataTypeRace_Ethnicity_Details_ReferenceItem instanceof \StructType\Ethnicity_DetailsObjectType) {
                $invalidValues[] = is_object($country_Personal_Information_DataTypeRace_Ethnicity_Details_ReferenceItem) ? get_class($country_Personal_Information_DataTypeRace_Ethnicity_Details_ReferenceItem) : sprintf('%s(%s)', gettype($country_Personal_Information_DataTypeRace_Ethnicity_Details_ReferenceItem), var_export($country_Personal_Information_DataTypeRace_Ethnicity_Details_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Race_Ethnicity_Details_Reference property can only contain items of type \StructType\Ethnicity_DetailsObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Race_Ethnicity_Details_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Ethnicity_DetailsObjectType[] $race_Ethnicity_Details_Reference
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setRace_Ethnicity_Details_Reference(array $race_Ethnicity_Details_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($race_Ethnicity_Details_ReferenceArrayErrorMessage = self::validateRace_Ethnicity_Details_ReferenceForArrayConstraintsFromSetRace_Ethnicity_Details_Reference($race_Ethnicity_Details_Reference))) {
            throw new \InvalidArgumentException($race_Ethnicity_Details_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Race_Ethnicity_Details_Reference = $race_Ethnicity_Details_Reference;
        return $this;
    }
    /**
     * Add item to Race_Ethnicity_Details_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Ethnicity_DetailsObjectType $item
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function addToRace_Ethnicity_Details_Reference(\StructType\Ethnicity_DetailsObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Ethnicity_DetailsObjectType) {
            throw new \InvalidArgumentException(sprintf('The Race_Ethnicity_Details_Reference property can only contain items of type \StructType\Ethnicity_DetailsObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Race_Ethnicity_Details_Reference[] = $item;
        return $this;
    }
    /**
     * Get Ethnicity_Visual_Survey_Reference value
     * @return \StructType\EthnicityObjectType[]|null
     */
    public function getEthnicity_Visual_Survey_Reference()
    {
        return $this->Ethnicity_Visual_Survey_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setEthnicity_Visual_Survey_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEthnicity_Visual_Survey_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEthnicity_Visual_Survey_ReferenceForArrayConstraintsFromSetEthnicity_Visual_Survey_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $country_Personal_Information_DataTypeEthnicity_Visual_Survey_ReferenceItem) {
            // validation for constraint: itemType
            if (!$country_Personal_Information_DataTypeEthnicity_Visual_Survey_ReferenceItem instanceof \StructType\EthnicityObjectType) {
                $invalidValues[] = is_object($country_Personal_Information_DataTypeEthnicity_Visual_Survey_ReferenceItem) ? get_class($country_Personal_Information_DataTypeEthnicity_Visual_Survey_ReferenceItem) : sprintf('%s(%s)', gettype($country_Personal_Information_DataTypeEthnicity_Visual_Survey_ReferenceItem), var_export($country_Personal_Information_DataTypeEthnicity_Visual_Survey_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Ethnicity_Visual_Survey_Reference property can only contain items of type \StructType\EthnicityObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Ethnicity_Visual_Survey_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\EthnicityObjectType[] $ethnicity_Visual_Survey_Reference
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setEthnicity_Visual_Survey_Reference(array $ethnicity_Visual_Survey_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($ethnicity_Visual_Survey_ReferenceArrayErrorMessage = self::validateEthnicity_Visual_Survey_ReferenceForArrayConstraintsFromSetEthnicity_Visual_Survey_Reference($ethnicity_Visual_Survey_Reference))) {
            throw new \InvalidArgumentException($ethnicity_Visual_Survey_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Ethnicity_Visual_Survey_Reference = $ethnicity_Visual_Survey_Reference;
        return $this;
    }
    /**
     * Add item to Ethnicity_Visual_Survey_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\EthnicityObjectType $item
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function addToEthnicity_Visual_Survey_Reference(\StructType\EthnicityObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EthnicityObjectType) {
            throw new \InvalidArgumentException(sprintf('The Ethnicity_Visual_Survey_Reference property can only contain items of type \StructType\EthnicityObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Ethnicity_Visual_Survey_Reference[] = $item;
        return $this;
    }
    /**
     * Get Hispanic_or_Latino value
     * @return bool|null
     */
    public function getHispanic_or_Latino()
    {
        return $this->Hispanic_or_Latino;
    }
    /**
     * Set Hispanic_or_Latino value
     * @param bool $hispanic_or_Latino
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setHispanic_or_Latino($hispanic_or_Latino = null)
    {
        // validation for constraint: boolean
        if (!is_null($hispanic_or_Latino) && !is_bool($hispanic_or_Latino)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hispanic_or_Latino, true), gettype($hispanic_or_Latino)), __LINE__);
        }
        $this->Hispanic_or_Latino = $hispanic_or_Latino;
        return $this;
    }
    /**
     * Get Hispanic_or_Latino_Visual_Survey value
     * @return bool|null
     */
    public function getHispanic_or_Latino_Visual_Survey()
    {
        return $this->Hispanic_or_Latino_Visual_Survey;
    }
    /**
     * Set Hispanic_or_Latino_Visual_Survey value
     * @param bool $hispanic_or_Latino_Visual_Survey
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setHispanic_or_Latino_Visual_Survey($hispanic_or_Latino_Visual_Survey = null)
    {
        // validation for constraint: boolean
        if (!is_null($hispanic_or_Latino_Visual_Survey) && !is_bool($hispanic_or_Latino_Visual_Survey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hispanic_or_Latino_Visual_Survey, true), gettype($hispanic_or_Latino_Visual_Survey)), __LINE__);
        }
        $this->Hispanic_or_Latino_Visual_Survey = $hispanic_or_Latino_Visual_Survey;
        return $this;
    }
    /**
     * Get Aboriginal_Indigenous_Identification_Reference value
     * @return \StructType\Aboriginal_Indigenous_Identification_SelectionObjectType|null
     */
    public function getAboriginal_Indigenous_Identification_Reference()
    {
        return $this->Aboriginal_Indigenous_Identification_Reference;
    }
    /**
     * Set Aboriginal_Indigenous_Identification_Reference value
     * @param \StructType\Aboriginal_Indigenous_Identification_SelectionObjectType $aboriginal_Indigenous_Identification_Reference
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setAboriginal_Indigenous_Identification_Reference(\StructType\Aboriginal_Indigenous_Identification_SelectionObjectType $aboriginal_Indigenous_Identification_Reference = null)
    {
        $this->Aboriginal_Indigenous_Identification_Reference = $aboriginal_Indigenous_Identification_Reference;
        return $this;
    }
    /**
     * Get Aboriginal_Indigenous_Identification_Details_Reference value
     * @return \StructType\Aboriginal_Indigenous_DetailsObjectType[]|null
     */
    public function getAboriginal_Indigenous_Identification_Details_Reference()
    {
        return $this->Aboriginal_Indigenous_Identification_Details_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAboriginal_Indigenous_Identification_Details_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAboriginal_Indigenous_Identification_Details_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAboriginal_Indigenous_Identification_Details_ReferenceForArrayConstraintsFromSetAboriginal_Indigenous_Identification_Details_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $country_Personal_Information_DataTypeAboriginal_Indigenous_Identification_Details_ReferenceItem) {
            // validation for constraint: itemType
            if (!$country_Personal_Information_DataTypeAboriginal_Indigenous_Identification_Details_ReferenceItem instanceof \StructType\Aboriginal_Indigenous_DetailsObjectType) {
                $invalidValues[] = is_object($country_Personal_Information_DataTypeAboriginal_Indigenous_Identification_Details_ReferenceItem) ? get_class($country_Personal_Information_DataTypeAboriginal_Indigenous_Identification_Details_ReferenceItem) : sprintf('%s(%s)', gettype($country_Personal_Information_DataTypeAboriginal_Indigenous_Identification_Details_ReferenceItem), var_export($country_Personal_Information_DataTypeAboriginal_Indigenous_Identification_Details_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Aboriginal_Indigenous_Identification_Details_Reference property can only contain items of type \StructType\Aboriginal_Indigenous_DetailsObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Aboriginal_Indigenous_Identification_Details_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Aboriginal_Indigenous_DetailsObjectType[] $aboriginal_Indigenous_Identification_Details_Reference
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setAboriginal_Indigenous_Identification_Details_Reference(array $aboriginal_Indigenous_Identification_Details_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($aboriginal_Indigenous_Identification_Details_ReferenceArrayErrorMessage = self::validateAboriginal_Indigenous_Identification_Details_ReferenceForArrayConstraintsFromSetAboriginal_Indigenous_Identification_Details_Reference($aboriginal_Indigenous_Identification_Details_Reference))) {
            throw new \InvalidArgumentException($aboriginal_Indigenous_Identification_Details_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Aboriginal_Indigenous_Identification_Details_Reference = $aboriginal_Indigenous_Identification_Details_Reference;
        return $this;
    }
    /**
     * Add item to Aboriginal_Indigenous_Identification_Details_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Aboriginal_Indigenous_DetailsObjectType $item
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function addToAboriginal_Indigenous_Identification_Details_Reference(\StructType\Aboriginal_Indigenous_DetailsObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Aboriginal_Indigenous_DetailsObjectType) {
            throw new \InvalidArgumentException(sprintf('The Aboriginal_Indigenous_Identification_Details_Reference property can only contain items of type \StructType\Aboriginal_Indigenous_DetailsObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Aboriginal_Indigenous_Identification_Details_Reference[] = $item;
        return $this;
    }
    /**
     * Get Hukou_Region_Reference value
     * @return \StructType\Country_RegionObjectType|null
     */
    public function getHukou_Region_Reference()
    {
        return $this->Hukou_Region_Reference;
    }
    /**
     * Set Hukou_Region_Reference value
     * @param \StructType\Country_RegionObjectType $hukou_Region_Reference
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setHukou_Region_Reference(\StructType\Country_RegionObjectType $hukou_Region_Reference = null)
    {
        $this->Hukou_Region_Reference = $hukou_Region_Reference;
        return $this;
    }
    /**
     * Get Hukou_Subregion_Reference value
     * @return \StructType\Country_SubregionObjectType|null
     */
    public function getHukou_Subregion_Reference()
    {
        return $this->Hukou_Subregion_Reference;
    }
    /**
     * Set Hukou_Subregion_Reference value
     * @param \StructType\Country_SubregionObjectType $hukou_Subregion_Reference
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setHukou_Subregion_Reference(\StructType\Country_SubregionObjectType $hukou_Subregion_Reference = null)
    {
        $this->Hukou_Subregion_Reference = $hukou_Subregion_Reference;
        return $this;
    }
    /**
     * Get Hukou_Locality value
     * @return string|null
     */
    public function getHukou_Locality()
    {
        return $this->Hukou_Locality;
    }
    /**
     * Set Hukou_Locality value
     * @param string $hukou_Locality
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setHukou_Locality($hukou_Locality = null)
    {
        // validation for constraint: string
        if (!is_null($hukou_Locality) && !is_string($hukou_Locality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hukou_Locality, true), gettype($hukou_Locality)), __LINE__);
        }
        $this->Hukou_Locality = $hukou_Locality;
        return $this;
    }
    /**
     * Get Hukou_Postal_Code value
     * @return string|null
     */
    public function getHukou_Postal_Code()
    {
        return $this->Hukou_Postal_Code;
    }
    /**
     * Set Hukou_Postal_Code value
     * @param string $hukou_Postal_Code
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setHukou_Postal_Code($hukou_Postal_Code = null)
    {
        // validation for constraint: string
        if (!is_null($hukou_Postal_Code) && !is_string($hukou_Postal_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hukou_Postal_Code, true), gettype($hukou_Postal_Code)), __LINE__);
        }
        $this->Hukou_Postal_Code = $hukou_Postal_Code;
        return $this;
    }
    /**
     * Get Hukou_Type_Reference value
     * @return \StructType\Hukou_TypeObjectType|null
     */
    public function getHukou_Type_Reference()
    {
        return $this->Hukou_Type_Reference;
    }
    /**
     * Set Hukou_Type_Reference value
     * @param \StructType\Hukou_TypeObjectType $hukou_Type_Reference
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setHukou_Type_Reference(\StructType\Hukou_TypeObjectType $hukou_Type_Reference = null)
    {
        $this->Hukou_Type_Reference = $hukou_Type_Reference;
        return $this;
    }
    /**
     * Get Local_Hukou value
     * @return bool|null
     */
    public function getLocal_Hukou()
    {
        return $this->Local_Hukou;
    }
    /**
     * Set Local_Hukou value
     * @param bool $local_Hukou
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setLocal_Hukou($local_Hukou = null)
    {
        // validation for constraint: boolean
        if (!is_null($local_Hukou) && !is_bool($local_Hukou)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($local_Hukou, true), gettype($local_Hukou)), __LINE__);
        }
        $this->Local_Hukou = $local_Hukou;
        return $this;
    }
    /**
     * Get Native_Region_Reference value
     * @return \StructType\Country_RegionObjectType[]|null
     */
    public function getNative_Region_Reference()
    {
        return $this->Native_Region_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setNative_Region_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNative_Region_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNative_Region_ReferenceForArrayConstraintsFromSetNative_Region_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $country_Personal_Information_DataTypeNative_Region_ReferenceItem) {
            // validation for constraint: itemType
            if (!$country_Personal_Information_DataTypeNative_Region_ReferenceItem instanceof \StructType\Country_RegionObjectType) {
                $invalidValues[] = is_object($country_Personal_Information_DataTypeNative_Region_ReferenceItem) ? get_class($country_Personal_Information_DataTypeNative_Region_ReferenceItem) : sprintf('%s(%s)', gettype($country_Personal_Information_DataTypeNative_Region_ReferenceItem), var_export($country_Personal_Information_DataTypeNative_Region_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Native_Region_Reference property can only contain items of type \StructType\Country_RegionObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Native_Region_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Country_RegionObjectType[] $native_Region_Reference
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setNative_Region_Reference(array $native_Region_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($native_Region_ReferenceArrayErrorMessage = self::validateNative_Region_ReferenceForArrayConstraintsFromSetNative_Region_Reference($native_Region_Reference))) {
            throw new \InvalidArgumentException($native_Region_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Native_Region_Reference = $native_Region_Reference;
        return $this;
    }
    /**
     * Add item to Native_Region_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Country_RegionObjectType $item
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function addToNative_Region_Reference(\StructType\Country_RegionObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Country_RegionObjectType) {
            throw new \InvalidArgumentException(sprintf('The Native_Region_Reference property can only contain items of type \StructType\Country_RegionObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Native_Region_Reference[] = $item;
        return $this;
    }
    /**
     * Get Native_Region_Descriptor value
     * @return string|null
     */
    public function getNative_Region_Descriptor()
    {
        return $this->Native_Region_Descriptor;
    }
    /**
     * Set Native_Region_Descriptor value
     * @param string $native_Region_Descriptor
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setNative_Region_Descriptor($native_Region_Descriptor = null)
    {
        // validation for constraint: string
        if (!is_null($native_Region_Descriptor) && !is_string($native_Region_Descriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($native_Region_Descriptor, true), gettype($native_Region_Descriptor)), __LINE__);
        }
        $this->Native_Region_Descriptor = $native_Region_Descriptor;
        return $this;
    }
    /**
     * Get Personnel_File_Agency_for_Person value
     * @return string|null
     */
    public function getPersonnel_File_Agency_for_Person()
    {
        return $this->Personnel_File_Agency_for_Person;
    }
    /**
     * Set Personnel_File_Agency_for_Person value
     * @param string $personnel_File_Agency_for_Person
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setPersonnel_File_Agency_for_Person($personnel_File_Agency_for_Person = null)
    {
        // validation for constraint: string
        if (!is_null($personnel_File_Agency_for_Person) && !is_string($personnel_File_Agency_for_Person)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personnel_File_Agency_for_Person, true), gettype($personnel_File_Agency_for_Person)), __LINE__);
        }
        $this->Personnel_File_Agency_for_Person = $personnel_File_Agency_for_Person;
        return $this;
    }
    /**
     * Get Political_Affiliation_Reference value
     * @return \StructType\Political_AffiliationObjectType|null
     */
    public function getPolitical_Affiliation_Reference()
    {
        return $this->Political_Affiliation_Reference;
    }
    /**
     * Set Political_Affiliation_Reference value
     * @param \StructType\Political_AffiliationObjectType $political_Affiliation_Reference
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setPolitical_Affiliation_Reference(\StructType\Political_AffiliationObjectType $political_Affiliation_Reference = null)
    {
        $this->Political_Affiliation_Reference = $political_Affiliation_Reference;
        return $this;
    }
    /**
     * Get Social_Benefits_Locality_Reference value
     * @return \StructType\Social_Benefits_LocalityObjectType|null
     */
    public function getSocial_Benefits_Locality_Reference()
    {
        return $this->Social_Benefits_Locality_Reference;
    }
    /**
     * Set Social_Benefits_Locality_Reference value
     * @param \StructType\Social_Benefits_LocalityObjectType $social_Benefits_Locality_Reference
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setSocial_Benefits_Locality_Reference(\StructType\Social_Benefits_LocalityObjectType $social_Benefits_Locality_Reference = null)
    {
        $this->Social_Benefits_Locality_Reference = $social_Benefits_Locality_Reference;
        return $this;
    }
    /**
     * Get Relative_Name_Information_Data value
     * @return \StructType\Relative_Name_DataType[]|null
     */
    public function getRelative_Name_Information_Data()
    {
        return $this->Relative_Name_Information_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRelative_Name_Information_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelative_Name_Information_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelative_Name_Information_DataForArrayConstraintsFromSetRelative_Name_Information_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $country_Personal_Information_DataTypeRelative_Name_Information_DataItem) {
            // validation for constraint: itemType
            if (!$country_Personal_Information_DataTypeRelative_Name_Information_DataItem instanceof \StructType\Relative_Name_DataType) {
                $invalidValues[] = is_object($country_Personal_Information_DataTypeRelative_Name_Information_DataItem) ? get_class($country_Personal_Information_DataTypeRelative_Name_Information_DataItem) : sprintf('%s(%s)', gettype($country_Personal_Information_DataTypeRelative_Name_Information_DataItem), var_export($country_Personal_Information_DataTypeRelative_Name_Information_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Relative_Name_Information_Data property can only contain items of type \StructType\Relative_Name_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Relative_Name_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Relative_Name_DataType[] $relative_Name_Information_Data
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setRelative_Name_Information_Data(array $relative_Name_Information_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($relative_Name_Information_DataArrayErrorMessage = self::validateRelative_Name_Information_DataForArrayConstraintsFromSetRelative_Name_Information_Data($relative_Name_Information_Data))) {
            throw new \InvalidArgumentException($relative_Name_Information_DataArrayErrorMessage, __LINE__);
        }
        $this->Relative_Name_Information_Data = $relative_Name_Information_Data;
        return $this;
    }
    /**
     * Add item to Relative_Name_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Relative_Name_DataType $item
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function addToRelative_Name_Information_Data(\StructType\Relative_Name_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Relative_Name_DataType) {
            throw new \InvalidArgumentException(sprintf('The Relative_Name_Information_Data property can only contain items of type \StructType\Relative_Name_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Relative_Name_Information_Data[] = $item;
        return $this;
    }
    /**
     * Get Sexual_Orientation_and_Gender_Identity_Reference value
     * @return \StructType\LGBT_IdentificationObjectType[]|null
     */
    public function getSexual_Orientation_and_Gender_Identity_Reference()
    {
        return $this->Sexual_Orientation_and_Gender_Identity_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSexual_Orientation_and_Gender_Identity_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSexual_Orientation_and_Gender_Identity_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSexual_Orientation_and_Gender_Identity_ReferenceForArrayConstraintsFromSetSexual_Orientation_and_Gender_Identity_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $country_Personal_Information_DataTypeSexual_Orientation_and_Gender_Identity_ReferenceItem) {
            // validation for constraint: itemType
            if (!$country_Personal_Information_DataTypeSexual_Orientation_and_Gender_Identity_ReferenceItem instanceof \StructType\LGBT_IdentificationObjectType) {
                $invalidValues[] = is_object($country_Personal_Information_DataTypeSexual_Orientation_and_Gender_Identity_ReferenceItem) ? get_class($country_Personal_Information_DataTypeSexual_Orientation_and_Gender_Identity_ReferenceItem) : sprintf('%s(%s)', gettype($country_Personal_Information_DataTypeSexual_Orientation_and_Gender_Identity_ReferenceItem), var_export($country_Personal_Information_DataTypeSexual_Orientation_and_Gender_Identity_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Sexual_Orientation_and_Gender_Identity_Reference property can only contain items of type \StructType\LGBT_IdentificationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Sexual_Orientation_and_Gender_Identity_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LGBT_IdentificationObjectType[] $sexual_Orientation_and_Gender_Identity_Reference
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setSexual_Orientation_and_Gender_Identity_Reference(array $sexual_Orientation_and_Gender_Identity_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($sexual_Orientation_and_Gender_Identity_ReferenceArrayErrorMessage = self::validateSexual_Orientation_and_Gender_Identity_ReferenceForArrayConstraintsFromSetSexual_Orientation_and_Gender_Identity_Reference($sexual_Orientation_and_Gender_Identity_Reference))) {
            throw new \InvalidArgumentException($sexual_Orientation_and_Gender_Identity_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Sexual_Orientation_and_Gender_Identity_Reference = $sexual_Orientation_and_Gender_Identity_Reference;
        return $this;
    }
    /**
     * Add item to Sexual_Orientation_and_Gender_Identity_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LGBT_IdentificationObjectType $item
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function addToSexual_Orientation_and_Gender_Identity_Reference(\StructType\LGBT_IdentificationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LGBT_IdentificationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Sexual_Orientation_and_Gender_Identity_Reference property can only contain items of type \StructType\LGBT_IdentificationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Sexual_Orientation_and_Gender_Identity_Reference[] = $item;
        return $this;
    }
    /**
     * Get Gender_Reference value
     * @return \StructType\GenderObjectType|null
     */
    public function getGender_Reference()
    {
        return $this->Gender_Reference;
    }
    /**
     * Set Gender_Reference value
     * @param \StructType\GenderObjectType $gender_Reference
     * @return \StructType\Country_Personal_Information_DataType
     */
    public function setGender_Reference(\StructType\GenderObjectType $gender_Reference = null)
    {
        $this->Gender_Reference = $gender_Reference;
        return $this;
    }
}
