<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Competency_Assessment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Competency rating and comments.
 * @subpackage Structs
 */
class Competency_Assessment_DataType extends AbstractStructBase
{
    /**
     * The Competency_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the competency the interviewer will rate on.
     * - minOccurs: 0
     * @var \StructType\CompetencyObjectType
     */
    public $Competency_Reference;
    /**
     * The Proficiency_Rating_Reference
     * Meta information extracted from the WSDL
     * - documentation: The proficiency rating reference for the competency
     * @var \StructType\Proficiency_RatingObjectType
     */
    public $Proficiency_Rating_Reference;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: A comment about the proficiency of the candidate for this competency.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for Competency_Assessment_DataType
     * @uses Competency_Assessment_DataType::setCompetency_Reference()
     * @uses Competency_Assessment_DataType::setProficiency_Rating_Reference()
     * @uses Competency_Assessment_DataType::setComment()
     * @param \StructType\CompetencyObjectType $competency_Reference
     * @param \StructType\Proficiency_RatingObjectType $proficiency_Rating_Reference
     * @param string $comment
     */
    public function __construct(\StructType\CompetencyObjectType $competency_Reference = null, \StructType\Proficiency_RatingObjectType $proficiency_Rating_Reference = null, $comment = null)
    {
        $this
            ->setCompetency_Reference($competency_Reference)
            ->setProficiency_Rating_Reference($proficiency_Rating_Reference)
            ->setComment($comment);
    }
    /**
     * Get Competency_Reference value
     * @return \StructType\CompetencyObjectType|null
     */
    public function getCompetency_Reference()
    {
        return $this->Competency_Reference;
    }
    /**
     * Set Competency_Reference value
     * @param \StructType\CompetencyObjectType $competency_Reference
     * @return \StructType\Competency_Assessment_DataType
     */
    public function setCompetency_Reference(\StructType\CompetencyObjectType $competency_Reference = null)
    {
        $this->Competency_Reference = $competency_Reference;
        return $this;
    }
    /**
     * Get Proficiency_Rating_Reference value
     * @return \StructType\Proficiency_RatingObjectType|null
     */
    public function getProficiency_Rating_Reference()
    {
        return $this->Proficiency_Rating_Reference;
    }
    /**
     * Set Proficiency_Rating_Reference value
     * @param \StructType\Proficiency_RatingObjectType $proficiency_Rating_Reference
     * @return \StructType\Competency_Assessment_DataType
     */
    public function setProficiency_Rating_Reference(\StructType\Proficiency_RatingObjectType $proficiency_Rating_Reference = null)
    {
        $this->Proficiency_Rating_Reference = $proficiency_Rating_Reference;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Competency_Assessment_DataType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
}
