<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Compensation_Proposed_For_Employment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Primary Compensation Basis amount has to be greater than zero. If you do not wish to use Primary Compensation Basis, leave the field blank. | Data element for the Propose Compensation for Hire business process.
 * @subpackage Structs
 */
class Compensation_Proposed_For_Employment_DataType extends AbstractStructBase
{
    /**
     * The Primary_Compensation_Basis
     * Meta information extracted from the WSDL
     * - documentation: Sum of the worker's plan assignments as defined by their primary compensation basis. | Sum of the employee's plan assignments as defined by their primary compensation basis.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Primary_Compensation_Basis;
    /**
     * The Compensation_Guidelines_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Compensatable_Guidelines_DataType
     */
    public $Compensation_Guidelines_Data;
    /**
     * The Pay_Plan_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Proposed_Base_Pay_Plan_Job_Assignment_Container_DataType
     */
    public $Pay_Plan_Data;
    /**
     * The Unit_Salary_Plan_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Proposed_Salary_Unit_Plan_Assignment_Container_DataType
     */
    public $Unit_Salary_Plan_Data;
    /**
     * The Allowance_Plan_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Proposed_Allowance_Plan_Assignment_Container_DataType
     */
    public $Allowance_Plan_Data;
    /**
     * The Unit_Allowance_Plan_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Proposed_Allowance_Unit_Plan_Assignment_Container_DataType
     */
    public $Unit_Allowance_Plan_Data;
    /**
     * The Bonus_Plan_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Proposed_Bonus_Plan_Assignment_Container_DataType
     */
    public $Bonus_Plan_Data;
    /**
     * The Merit_Plan_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Proposed_Merit_Plan_Assignment_Container_DataType
     */
    public $Merit_Plan_Data;
    /**
     * The Commission_Plan_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Proposed_Commission_Plan_Assignment_Container_DataType
     */
    public $Commission_Plan_Data;
    /**
     * The Stock_Plan_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Proposed_Stock_Plan_Assignment_Container_DataType
     */
    public $Stock_Plan_Data;
    /**
     * The Period_Salary_Plan_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Proposed_Period_Salary_Plan_Assignment_Container_DataType
     */
    public $Period_Salary_Plan_Data;
    /**
     * The Calculated_Plan_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Proposed_Calculated_Plan_Assignment_Container_DataType
     */
    public $Calculated_Plan_Data;
    /**
     * Constructor method for Compensation_Proposed_For_Employment_DataType
     * @uses Compensation_Proposed_For_Employment_DataType::setPrimary_Compensation_Basis()
     * @uses Compensation_Proposed_For_Employment_DataType::setCompensation_Guidelines_Data()
     * @uses Compensation_Proposed_For_Employment_DataType::setPay_Plan_Data()
     * @uses Compensation_Proposed_For_Employment_DataType::setUnit_Salary_Plan_Data()
     * @uses Compensation_Proposed_For_Employment_DataType::setAllowance_Plan_Data()
     * @uses Compensation_Proposed_For_Employment_DataType::setUnit_Allowance_Plan_Data()
     * @uses Compensation_Proposed_For_Employment_DataType::setBonus_Plan_Data()
     * @uses Compensation_Proposed_For_Employment_DataType::setMerit_Plan_Data()
     * @uses Compensation_Proposed_For_Employment_DataType::setCommission_Plan_Data()
     * @uses Compensation_Proposed_For_Employment_DataType::setStock_Plan_Data()
     * @uses Compensation_Proposed_For_Employment_DataType::setPeriod_Salary_Plan_Data()
     * @uses Compensation_Proposed_For_Employment_DataType::setCalculated_Plan_Data()
     * @param float $primary_Compensation_Basis
     * @param \StructType\Compensatable_Guidelines_DataType $compensation_Guidelines_Data
     * @param \StructType\Proposed_Base_Pay_Plan_Job_Assignment_Container_DataType $pay_Plan_Data
     * @param \StructType\Proposed_Salary_Unit_Plan_Assignment_Container_DataType $unit_Salary_Plan_Data
     * @param \StructType\Proposed_Allowance_Plan_Assignment_Container_DataType $allowance_Plan_Data
     * @param \StructType\Proposed_Allowance_Unit_Plan_Assignment_Container_DataType $unit_Allowance_Plan_Data
     * @param \StructType\Proposed_Bonus_Plan_Assignment_Container_DataType $bonus_Plan_Data
     * @param \StructType\Proposed_Merit_Plan_Assignment_Container_DataType $merit_Plan_Data
     * @param \StructType\Proposed_Commission_Plan_Assignment_Container_DataType $commission_Plan_Data
     * @param \StructType\Proposed_Stock_Plan_Assignment_Container_DataType $stock_Plan_Data
     * @param \StructType\Proposed_Period_Salary_Plan_Assignment_Container_DataType $period_Salary_Plan_Data
     * @param \StructType\Proposed_Calculated_Plan_Assignment_Container_DataType $calculated_Plan_Data
     */
    public function __construct($primary_Compensation_Basis = null, \StructType\Compensatable_Guidelines_DataType $compensation_Guidelines_Data = null, \StructType\Proposed_Base_Pay_Plan_Job_Assignment_Container_DataType $pay_Plan_Data = null, \StructType\Proposed_Salary_Unit_Plan_Assignment_Container_DataType $unit_Salary_Plan_Data = null, \StructType\Proposed_Allowance_Plan_Assignment_Container_DataType $allowance_Plan_Data = null, \StructType\Proposed_Allowance_Unit_Plan_Assignment_Container_DataType $unit_Allowance_Plan_Data = null, \StructType\Proposed_Bonus_Plan_Assignment_Container_DataType $bonus_Plan_Data = null, \StructType\Proposed_Merit_Plan_Assignment_Container_DataType $merit_Plan_Data = null, \StructType\Proposed_Commission_Plan_Assignment_Container_DataType $commission_Plan_Data = null, \StructType\Proposed_Stock_Plan_Assignment_Container_DataType $stock_Plan_Data = null, \StructType\Proposed_Period_Salary_Plan_Assignment_Container_DataType $period_Salary_Plan_Data = null, \StructType\Proposed_Calculated_Plan_Assignment_Container_DataType $calculated_Plan_Data = null)
    {
        $this
            ->setPrimary_Compensation_Basis($primary_Compensation_Basis)
            ->setCompensation_Guidelines_Data($compensation_Guidelines_Data)
            ->setPay_Plan_Data($pay_Plan_Data)
            ->setUnit_Salary_Plan_Data($unit_Salary_Plan_Data)
            ->setAllowance_Plan_Data($allowance_Plan_Data)
            ->setUnit_Allowance_Plan_Data($unit_Allowance_Plan_Data)
            ->setBonus_Plan_Data($bonus_Plan_Data)
            ->setMerit_Plan_Data($merit_Plan_Data)
            ->setCommission_Plan_Data($commission_Plan_Data)
            ->setStock_Plan_Data($stock_Plan_Data)
            ->setPeriod_Salary_Plan_Data($period_Salary_Plan_Data)
            ->setCalculated_Plan_Data($calculated_Plan_Data);
    }
    /**
     * Get Primary_Compensation_Basis value
     * @return float|null
     */
    public function getPrimary_Compensation_Basis()
    {
        return $this->Primary_Compensation_Basis;
    }
    /**
     * Set Primary_Compensation_Basis value
     * @param float $primary_Compensation_Basis
     * @return \StructType\Compensation_Proposed_For_Employment_DataType
     */
    public function setPrimary_Compensation_Basis($primary_Compensation_Basis = null)
    {
        // validation for constraint: float
        if (!is_null($primary_Compensation_Basis) && !(is_float($primary_Compensation_Basis) || is_numeric($primary_Compensation_Basis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($primary_Compensation_Basis, true), gettype($primary_Compensation_Basis)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($primary_Compensation_Basis) && mb_strlen(mb_substr($primary_Compensation_Basis, false !== mb_strpos($primary_Compensation_Basis, '.') ? mb_strpos($primary_Compensation_Basis, '.') + 1 : mb_strlen($primary_Compensation_Basis))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($primary_Compensation_Basis, true), mb_strlen(mb_substr($primary_Compensation_Basis, mb_strpos($primary_Compensation_Basis, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($primary_Compensation_Basis) && mb_strlen(preg_replace('/(\D)/', '', $primary_Compensation_Basis)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($primary_Compensation_Basis, true), mb_strlen(preg_replace('/(\D)/', '', $primary_Compensation_Basis))), __LINE__);
        }
        $this->Primary_Compensation_Basis = $primary_Compensation_Basis;
        return $this;
    }
    /**
     * Get Compensation_Guidelines_Data value
     * @return \StructType\Compensatable_Guidelines_DataType|null
     */
    public function getCompensation_Guidelines_Data()
    {
        return $this->Compensation_Guidelines_Data;
    }
    /**
     * Set Compensation_Guidelines_Data value
     * @param \StructType\Compensatable_Guidelines_DataType $compensation_Guidelines_Data
     * @return \StructType\Compensation_Proposed_For_Employment_DataType
     */
    public function setCompensation_Guidelines_Data(\StructType\Compensatable_Guidelines_DataType $compensation_Guidelines_Data = null)
    {
        $this->Compensation_Guidelines_Data = $compensation_Guidelines_Data;
        return $this;
    }
    /**
     * Get Pay_Plan_Data value
     * @return \StructType\Proposed_Base_Pay_Plan_Job_Assignment_Container_DataType|null
     */
    public function getPay_Plan_Data()
    {
        return $this->Pay_Plan_Data;
    }
    /**
     * Set Pay_Plan_Data value
     * @param \StructType\Proposed_Base_Pay_Plan_Job_Assignment_Container_DataType $pay_Plan_Data
     * @return \StructType\Compensation_Proposed_For_Employment_DataType
     */
    public function setPay_Plan_Data(\StructType\Proposed_Base_Pay_Plan_Job_Assignment_Container_DataType $pay_Plan_Data = null)
    {
        $this->Pay_Plan_Data = $pay_Plan_Data;
        return $this;
    }
    /**
     * Get Unit_Salary_Plan_Data value
     * @return \StructType\Proposed_Salary_Unit_Plan_Assignment_Container_DataType|null
     */
    public function getUnit_Salary_Plan_Data()
    {
        return $this->Unit_Salary_Plan_Data;
    }
    /**
     * Set Unit_Salary_Plan_Data value
     * @param \StructType\Proposed_Salary_Unit_Plan_Assignment_Container_DataType $unit_Salary_Plan_Data
     * @return \StructType\Compensation_Proposed_For_Employment_DataType
     */
    public function setUnit_Salary_Plan_Data(\StructType\Proposed_Salary_Unit_Plan_Assignment_Container_DataType $unit_Salary_Plan_Data = null)
    {
        $this->Unit_Salary_Plan_Data = $unit_Salary_Plan_Data;
        return $this;
    }
    /**
     * Get Allowance_Plan_Data value
     * @return \StructType\Proposed_Allowance_Plan_Assignment_Container_DataType|null
     */
    public function getAllowance_Plan_Data()
    {
        return $this->Allowance_Plan_Data;
    }
    /**
     * Set Allowance_Plan_Data value
     * @param \StructType\Proposed_Allowance_Plan_Assignment_Container_DataType $allowance_Plan_Data
     * @return \StructType\Compensation_Proposed_For_Employment_DataType
     */
    public function setAllowance_Plan_Data(\StructType\Proposed_Allowance_Plan_Assignment_Container_DataType $allowance_Plan_Data = null)
    {
        $this->Allowance_Plan_Data = $allowance_Plan_Data;
        return $this;
    }
    /**
     * Get Unit_Allowance_Plan_Data value
     * @return \StructType\Proposed_Allowance_Unit_Plan_Assignment_Container_DataType|null
     */
    public function getUnit_Allowance_Plan_Data()
    {
        return $this->Unit_Allowance_Plan_Data;
    }
    /**
     * Set Unit_Allowance_Plan_Data value
     * @param \StructType\Proposed_Allowance_Unit_Plan_Assignment_Container_DataType $unit_Allowance_Plan_Data
     * @return \StructType\Compensation_Proposed_For_Employment_DataType
     */
    public function setUnit_Allowance_Plan_Data(\StructType\Proposed_Allowance_Unit_Plan_Assignment_Container_DataType $unit_Allowance_Plan_Data = null)
    {
        $this->Unit_Allowance_Plan_Data = $unit_Allowance_Plan_Data;
        return $this;
    }
    /**
     * Get Bonus_Plan_Data value
     * @return \StructType\Proposed_Bonus_Plan_Assignment_Container_DataType|null
     */
    public function getBonus_Plan_Data()
    {
        return $this->Bonus_Plan_Data;
    }
    /**
     * Set Bonus_Plan_Data value
     * @param \StructType\Proposed_Bonus_Plan_Assignment_Container_DataType $bonus_Plan_Data
     * @return \StructType\Compensation_Proposed_For_Employment_DataType
     */
    public function setBonus_Plan_Data(\StructType\Proposed_Bonus_Plan_Assignment_Container_DataType $bonus_Plan_Data = null)
    {
        $this->Bonus_Plan_Data = $bonus_Plan_Data;
        return $this;
    }
    /**
     * Get Merit_Plan_Data value
     * @return \StructType\Proposed_Merit_Plan_Assignment_Container_DataType|null
     */
    public function getMerit_Plan_Data()
    {
        return $this->Merit_Plan_Data;
    }
    /**
     * Set Merit_Plan_Data value
     * @param \StructType\Proposed_Merit_Plan_Assignment_Container_DataType $merit_Plan_Data
     * @return \StructType\Compensation_Proposed_For_Employment_DataType
     */
    public function setMerit_Plan_Data(\StructType\Proposed_Merit_Plan_Assignment_Container_DataType $merit_Plan_Data = null)
    {
        $this->Merit_Plan_Data = $merit_Plan_Data;
        return $this;
    }
    /**
     * Get Commission_Plan_Data value
     * @return \StructType\Proposed_Commission_Plan_Assignment_Container_DataType|null
     */
    public function getCommission_Plan_Data()
    {
        return $this->Commission_Plan_Data;
    }
    /**
     * Set Commission_Plan_Data value
     * @param \StructType\Proposed_Commission_Plan_Assignment_Container_DataType $commission_Plan_Data
     * @return \StructType\Compensation_Proposed_For_Employment_DataType
     */
    public function setCommission_Plan_Data(\StructType\Proposed_Commission_Plan_Assignment_Container_DataType $commission_Plan_Data = null)
    {
        $this->Commission_Plan_Data = $commission_Plan_Data;
        return $this;
    }
    /**
     * Get Stock_Plan_Data value
     * @return \StructType\Proposed_Stock_Plan_Assignment_Container_DataType|null
     */
    public function getStock_Plan_Data()
    {
        return $this->Stock_Plan_Data;
    }
    /**
     * Set Stock_Plan_Data value
     * @param \StructType\Proposed_Stock_Plan_Assignment_Container_DataType $stock_Plan_Data
     * @return \StructType\Compensation_Proposed_For_Employment_DataType
     */
    public function setStock_Plan_Data(\StructType\Proposed_Stock_Plan_Assignment_Container_DataType $stock_Plan_Data = null)
    {
        $this->Stock_Plan_Data = $stock_Plan_Data;
        return $this;
    }
    /**
     * Get Period_Salary_Plan_Data value
     * @return \StructType\Proposed_Period_Salary_Plan_Assignment_Container_DataType|null
     */
    public function getPeriod_Salary_Plan_Data()
    {
        return $this->Period_Salary_Plan_Data;
    }
    /**
     * Set Period_Salary_Plan_Data value
     * @param \StructType\Proposed_Period_Salary_Plan_Assignment_Container_DataType $period_Salary_Plan_Data
     * @return \StructType\Compensation_Proposed_For_Employment_DataType
     */
    public function setPeriod_Salary_Plan_Data(\StructType\Proposed_Period_Salary_Plan_Assignment_Container_DataType $period_Salary_Plan_Data = null)
    {
        $this->Period_Salary_Plan_Data = $period_Salary_Plan_Data;
        return $this;
    }
    /**
     * Get Calculated_Plan_Data value
     * @return \StructType\Proposed_Calculated_Plan_Assignment_Container_DataType|null
     */
    public function getCalculated_Plan_Data()
    {
        return $this->Calculated_Plan_Data;
    }
    /**
     * Set Calculated_Plan_Data value
     * @param \StructType\Proposed_Calculated_Plan_Assignment_Container_DataType $calculated_Plan_Data
     * @return \StructType\Compensation_Proposed_For_Employment_DataType
     */
    public function setCalculated_Plan_Data(\StructType\Proposed_Calculated_Plan_Assignment_Container_DataType $calculated_Plan_Data = null)
    {
        $this->Calculated_Plan_Data = $calculated_Plan_Data;
        return $this;
    }
}
