<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Close_Evergreen_Requisition_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for the closing of an Evergreen Requisition
 * @subpackage Structs
 */
class Close_Evergreen_Requisition_DataType extends AbstractStructBase
{
    /**
     * The Evergreen_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the evergreen requisition to be closed.
     * @var \StructType\Evergreen_Job_RequisitionObjectType
     */
    public $Evergreen_Requisition_Reference;
    /**
     * The Close_Evergreen_Requisition_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the reason the evergreen requisition is being closed.
     * @var \StructType\Event_Classification_SubcategoryObjectType
     */
    public $Close_Evergreen_Requisition_Reason_Reference;
    /**
     * The Evergreen_Requisition_Close_Date
     * Meta information extracted from the WSDL
     * - documentation: The date the requisition will be closed.
     * - maxOccurs: 1
     * @var string
     */
    public $Evergreen_Requisition_Close_Date;
    /**
     * The Unpost_Job_Sub_Business_Process
     * Meta information extracted from the WSDL
     * - documentation: Run the Update Job Posting sub business process to unpost the job postings associated with this Job Requisition. To use, Unpost Job must be enabled on the Workflow Definition for Close Job Requisition.
     * - minOccurs: 0
     * @var \StructType\Unpost_Job_Sub_Business_ProcessType
     */
    public $Unpost_Job_Sub_Business_Process;
    /**
     * Constructor method for Close_Evergreen_Requisition_DataType
     * @uses Close_Evergreen_Requisition_DataType::setEvergreen_Requisition_Reference()
     * @uses Close_Evergreen_Requisition_DataType::setClose_Evergreen_Requisition_Reason_Reference()
     * @uses Close_Evergreen_Requisition_DataType::setEvergreen_Requisition_Close_Date()
     * @uses Close_Evergreen_Requisition_DataType::setUnpost_Job_Sub_Business_Process()
     * @param \StructType\Evergreen_Job_RequisitionObjectType $evergreen_Requisition_Reference
     * @param \StructType\Event_Classification_SubcategoryObjectType $close_Evergreen_Requisition_Reason_Reference
     * @param string $evergreen_Requisition_Close_Date
     * @param \StructType\Unpost_Job_Sub_Business_ProcessType $unpost_Job_Sub_Business_Process
     */
    public function __construct(\StructType\Evergreen_Job_RequisitionObjectType $evergreen_Requisition_Reference = null, \StructType\Event_Classification_SubcategoryObjectType $close_Evergreen_Requisition_Reason_Reference = null, $evergreen_Requisition_Close_Date = null, \StructType\Unpost_Job_Sub_Business_ProcessType $unpost_Job_Sub_Business_Process = null)
    {
        $this
            ->setEvergreen_Requisition_Reference($evergreen_Requisition_Reference)
            ->setClose_Evergreen_Requisition_Reason_Reference($close_Evergreen_Requisition_Reason_Reference)
            ->setEvergreen_Requisition_Close_Date($evergreen_Requisition_Close_Date)
            ->setUnpost_Job_Sub_Business_Process($unpost_Job_Sub_Business_Process);
    }
    /**
     * Get Evergreen_Requisition_Reference value
     * @return \StructType\Evergreen_Job_RequisitionObjectType|null
     */
    public function getEvergreen_Requisition_Reference()
    {
        return $this->Evergreen_Requisition_Reference;
    }
    /**
     * Set Evergreen_Requisition_Reference value
     * @param \StructType\Evergreen_Job_RequisitionObjectType $evergreen_Requisition_Reference
     * @return \StructType\Close_Evergreen_Requisition_DataType
     */
    public function setEvergreen_Requisition_Reference(\StructType\Evergreen_Job_RequisitionObjectType $evergreen_Requisition_Reference = null)
    {
        $this->Evergreen_Requisition_Reference = $evergreen_Requisition_Reference;
        return $this;
    }
    /**
     * Get Close_Evergreen_Requisition_Reason_Reference value
     * @return \StructType\Event_Classification_SubcategoryObjectType|null
     */
    public function getClose_Evergreen_Requisition_Reason_Reference()
    {
        return $this->Close_Evergreen_Requisition_Reason_Reference;
    }
    /**
     * Set Close_Evergreen_Requisition_Reason_Reference value
     * @param \StructType\Event_Classification_SubcategoryObjectType $close_Evergreen_Requisition_Reason_Reference
     * @return \StructType\Close_Evergreen_Requisition_DataType
     */
    public function setClose_Evergreen_Requisition_Reason_Reference(\StructType\Event_Classification_SubcategoryObjectType $close_Evergreen_Requisition_Reason_Reference = null)
    {
        $this->Close_Evergreen_Requisition_Reason_Reference = $close_Evergreen_Requisition_Reason_Reference;
        return $this;
    }
    /**
     * Get Evergreen_Requisition_Close_Date value
     * @return string|null
     */
    public function getEvergreen_Requisition_Close_Date()
    {
        return $this->Evergreen_Requisition_Close_Date;
    }
    /**
     * Set Evergreen_Requisition_Close_Date value
     * @param string $evergreen_Requisition_Close_Date
     * @return \StructType\Close_Evergreen_Requisition_DataType
     */
    public function setEvergreen_Requisition_Close_Date($evergreen_Requisition_Close_Date = null)
    {
        // validation for constraint: string
        if (!is_null($evergreen_Requisition_Close_Date) && !is_string($evergreen_Requisition_Close_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evergreen_Requisition_Close_Date, true), gettype($evergreen_Requisition_Close_Date)), __LINE__);
        }
        $this->Evergreen_Requisition_Close_Date = $evergreen_Requisition_Close_Date;
        return $this;
    }
    /**
     * Get Unpost_Job_Sub_Business_Process value
     * @return \StructType\Unpost_Job_Sub_Business_ProcessType|null
     */
    public function getUnpost_Job_Sub_Business_Process()
    {
        return $this->Unpost_Job_Sub_Business_Process;
    }
    /**
     * Set Unpost_Job_Sub_Business_Process value
     * @param \StructType\Unpost_Job_Sub_Business_ProcessType $unpost_Job_Sub_Business_Process
     * @return \StructType\Close_Evergreen_Requisition_DataType
     */
    public function setUnpost_Job_Sub_Business_Process(\StructType\Unpost_Job_Sub_Business_ProcessType $unpost_Job_Sub_Business_Process = null)
    {
        $this->Unpost_Job_Sub_Business_Process = $unpost_Job_Sub_Business_Process;
        return $this;
    }
}
