<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Skill_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains skill items for the candidate.
 * @subpackage Structs
 */
class Candidate_Skill_DataType extends AbstractStructBase
{
    /**
     * The Skill_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to a Skill Item.
     * - minOccurs: 0
     * @var \StructType\Maintained_SkillObjectType
     */
    public $Skill_Reference;
    /**
     * The Skill_Name
     * Meta information extracted from the WSDL
     * - documentation: The name of the Skill Item.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Skill_Name;
    /**
     * Constructor method for Candidate_Skill_DataType
     * @uses Candidate_Skill_DataType::setSkill_Reference()
     * @uses Candidate_Skill_DataType::setSkill_Name()
     * @param \StructType\Maintained_SkillObjectType $skill_Reference
     * @param string $skill_Name
     */
    public function __construct(\StructType\Maintained_SkillObjectType $skill_Reference = null, $skill_Name = null)
    {
        $this
            ->setSkill_Reference($skill_Reference)
            ->setSkill_Name($skill_Name);
    }
    /**
     * Get Skill_Reference value
     * @return \StructType\Maintained_SkillObjectType|null
     */
    public function getSkill_Reference()
    {
        return $this->Skill_Reference;
    }
    /**
     * Set Skill_Reference value
     * @param \StructType\Maintained_SkillObjectType $skill_Reference
     * @return \StructType\Candidate_Skill_DataType
     */
    public function setSkill_Reference(\StructType\Maintained_SkillObjectType $skill_Reference = null)
    {
        $this->Skill_Reference = $skill_Reference;
        return $this;
    }
    /**
     * Get Skill_Name value
     * @return string|null
     */
    public function getSkill_Name()
    {
        return $this->Skill_Name;
    }
    /**
     * Set Skill_Name value
     * @param string $skill_Name
     * @return \StructType\Candidate_Skill_DataType
     */
    public function setSkill_Name($skill_Name = null)
    {
        // validation for constraint: string
        if (!is_null($skill_Name) && !is_string($skill_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($skill_Name, true), gettype($skill_Name)), __LINE__);
        }
        $this->Skill_Name = $skill_Name;
        return $this;
    }
}
