<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Response_GroupType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Candidate response grouping options
 * @subpackage Structs
 */
class Candidate_Response_GroupType extends AbstractStructBase
{
    /**
     * The Include_Reference
     * Meta information extracted from the WSDL
     * - documentation: Include Reference
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Reference;
    /**
     * The Exclude_All_Attachments
     * Meta information extracted from the WSDL
     * - documentation: Exclude job application and prospect attachments in the response if true.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Exclude_All_Attachments;
    /**
     * Constructor method for Candidate_Response_GroupType
     * @uses Candidate_Response_GroupType::setInclude_Reference()
     * @uses Candidate_Response_GroupType::setExclude_All_Attachments()
     * @param bool $include_Reference
     * @param bool $exclude_All_Attachments
     */
    public function __construct($include_Reference = null, $exclude_All_Attachments = null)
    {
        $this
            ->setInclude_Reference($include_Reference)
            ->setExclude_All_Attachments($exclude_All_Attachments);
    }
    /**
     * Get Include_Reference value
     * @return bool|null
     */
    public function getInclude_Reference()
    {
        return $this->Include_Reference;
    }
    /**
     * Set Include_Reference value
     * @param bool $include_Reference
     * @return \StructType\Candidate_Response_GroupType
     */
    public function setInclude_Reference($include_Reference = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Reference) && !is_bool($include_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Reference, true), gettype($include_Reference)), __LINE__);
        }
        $this->Include_Reference = $include_Reference;
        return $this;
    }
    /**
     * Get Exclude_All_Attachments value
     * @return bool|null
     */
    public function getExclude_All_Attachments()
    {
        return $this->Exclude_All_Attachments;
    }
    /**
     * Set Exclude_All_Attachments value
     * @param bool $exclude_All_Attachments
     * @return \StructType\Candidate_Response_GroupType
     */
    public function setExclude_All_Attachments($exclude_All_Attachments = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclude_All_Attachments) && !is_bool($exclude_All_Attachments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclude_All_Attachments, true), gettype($exclude_All_Attachments)), __LINE__);
        }
        $this->Exclude_All_Attachments = $exclude_All_Attachments;
        return $this;
    }
}
