<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Preferred_Name_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the preferred name for a candidate.
 * @subpackage Structs
 */
class Candidate_Preferred_Name_DataType extends AbstractStructBase
{
    /**
     * The Delete_Preferred_Name_Data
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating that the worker's legal name should be used as preferred. If this flag is set, Name Data is not allowed (otherwise it is required).
     * - choice: Delete_Preferred_Name_Data | Name_Detail_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Delete_Preferred_Name_Data;
    /**
     * The Name_Detail_Data
     * Meta information extracted from the WSDL
     * - choice: Delete_Preferred_Name_Data | Name_Detail_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Candidate_Name_Detail_DataType
     */
    public $Name_Detail_Data;
    /**
     * Constructor method for Candidate_Preferred_Name_DataType
     * @uses Candidate_Preferred_Name_DataType::setDelete_Preferred_Name_Data()
     * @uses Candidate_Preferred_Name_DataType::setName_Detail_Data()
     * @param bool $delete_Preferred_Name_Data
     * @param \StructType\Candidate_Name_Detail_DataType $name_Detail_Data
     */
    public function __construct($delete_Preferred_Name_Data = null, \StructType\Candidate_Name_Detail_DataType $name_Detail_Data = null)
    {
        $this
            ->setDelete_Preferred_Name_Data($delete_Preferred_Name_Data)
            ->setName_Detail_Data($name_Detail_Data);
    }
    /**
     * Get Delete_Preferred_Name_Data value
     * @return bool|null
     */
    public function getDelete_Preferred_Name_Data()
    {
        return isset($this->Delete_Preferred_Name_Data) ? $this->Delete_Preferred_Name_Data : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDelete_Preferred_Name_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDelete_Preferred_Name_Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDelete_Preferred_Name_DataForChoiceConstraintsFromSetDelete_Preferred_Name_Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Name_Detail_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Delete_Preferred_Name_Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Delete_Preferred_Name_Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Delete_Preferred_Name_Data value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $delete_Preferred_Name_Data
     * @return \StructType\Candidate_Preferred_Name_DataType
     */
    public function setDelete_Preferred_Name_Data($delete_Preferred_Name_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete_Preferred_Name_Data) && !is_bool($delete_Preferred_Name_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete_Preferred_Name_Data, true), gettype($delete_Preferred_Name_Data)), __LINE__);
        }
        // validation for constraint: choice(Delete_Preferred_Name_Data, Name_Detail_Data)
        if ('' !== ($delete_Preferred_Name_DataChoiceErrorMessage = self::validateDelete_Preferred_Name_DataForChoiceConstraintsFromSetDelete_Preferred_Name_Data($delete_Preferred_Name_Data))) {
            throw new \InvalidArgumentException($delete_Preferred_Name_DataChoiceErrorMessage, __LINE__);
        }
        if (is_null($delete_Preferred_Name_Data) || (is_array($delete_Preferred_Name_Data) && empty($delete_Preferred_Name_Data))) {
            unset($this->Delete_Preferred_Name_Data);
        } else {
            $this->Delete_Preferred_Name_Data = $delete_Preferred_Name_Data;
        }
        return $this;
    }
    /**
     * Get Name_Detail_Data value
     * @return \StructType\Candidate_Name_Detail_DataType|null
     */
    public function getName_Detail_Data()
    {
        return isset($this->Name_Detail_Data) ? $this->Name_Detail_Data : null;
    }
    /**
     * This method is responsible for validating the value passed to the setName_Detail_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setName_Detail_Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateName_Detail_DataForChoiceConstraintsFromSetName_Detail_Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Delete_Preferred_Name_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Name_Detail_Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Name_Detail_Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Name_Detail_Data value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Name_Detail_DataType $name_Detail_Data
     * @return \StructType\Candidate_Preferred_Name_DataType
     */
    public function setName_Detail_Data(\StructType\Candidate_Name_Detail_DataType $name_Detail_Data = null)
    {
        // validation for constraint: choice(Delete_Preferred_Name_Data, Name_Detail_Data)
        if ('' !== ($name_Detail_DataChoiceErrorMessage = self::validateName_Detail_DataForChoiceConstraintsFromSetName_Detail_Data($name_Detail_Data))) {
            throw new \InvalidArgumentException($name_Detail_DataChoiceErrorMessage, __LINE__);
        }
        if (is_null($name_Detail_Data) || (is_array($name_Detail_Data) && empty($name_Detail_Data))) {
            unset($this->Name_Detail_Data);
        } else {
            $this->Name_Detail_Data = $name_Detail_Data;
        }
        return $this;
    }
}
