<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Local_Name_Detail_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains localized name data for a candidate
 * @subpackage Structs
 */
class Candidate_Local_Name_Detail_DataType extends AbstractStructBase
{
    /**
     * The First_Name___Local
     * Meta information extracted from the WSDL
     * - documentation: The local first name for the candidate.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $First_Name___Local;
    /**
     * The Middle_Name___Local
     * Meta information extracted from the WSDL
     * - documentation: Contains Middle Name in local script for supporting Countries.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Middle_Name___Local;
    /**
     * The Last_Name___Local
     * Meta information extracted from the WSDL
     * - documentation: The local primary name for the candidate.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Last_Name___Local;
    /**
     * The Secondary_Last_Name___Local
     * Meta information extracted from the WSDL
     * - documentation: Contains Secondary Last Name in local script, which is generally configured as Maternal Family Name, for supporting Countries.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Secondary_Last_Name___Local;
    /**
     * The First_Name_2___Local
     * Meta information extracted from the WSDL
     * - documentation: The local first name 2 for the candidate
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $First_Name_2___Local;
    /**
     * The Last_Name_2___Local
     * Meta information extracted from the WSDL
     * - documentation: The local primary name 2 for the candidate.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Last_Name_2___Local;
    /**
     * Constructor method for Candidate_Local_Name_Detail_DataType
     * @uses Candidate_Local_Name_Detail_DataType::setFirst_Name___Local()
     * @uses Candidate_Local_Name_Detail_DataType::setMiddle_Name___Local()
     * @uses Candidate_Local_Name_Detail_DataType::setLast_Name___Local()
     * @uses Candidate_Local_Name_Detail_DataType::setSecondary_Last_Name___Local()
     * @uses Candidate_Local_Name_Detail_DataType::setFirst_Name_2___Local()
     * @uses Candidate_Local_Name_Detail_DataType::setLast_Name_2___Local()
     * @param string $first_Name___Local
     * @param string $middle_Name___Local
     * @param string $last_Name___Local
     * @param string $secondary_Last_Name___Local
     * @param string $first_Name_2___Local
     * @param string $last_Name_2___Local
     */
    public function __construct($first_Name___Local = null, $middle_Name___Local = null, $last_Name___Local = null, $secondary_Last_Name___Local = null, $first_Name_2___Local = null, $last_Name_2___Local = null)
    {
        $this
            ->setFirst_Name___Local($first_Name___Local)
            ->setMiddle_Name___Local($middle_Name___Local)
            ->setLast_Name___Local($last_Name___Local)
            ->setSecondary_Last_Name___Local($secondary_Last_Name___Local)
            ->setFirst_Name_2___Local($first_Name_2___Local)
            ->setLast_Name_2___Local($last_Name_2___Local);
    }
    /**
     * Get First_Name___Local value
     * @return string|null
     */
    public function getFirst_Name___Local()
    {
        return $this->{'First_Name_-_Local'};
    }
    /**
     * Set First_Name___Local value
     * @param string $first_Name___Local
     * @return \StructType\Candidate_Local_Name_Detail_DataType
     */
    public function setFirst_Name___Local($first_Name___Local = null)
    {
        // validation for constraint: string
        if (!is_null($first_Name___Local) && !is_string($first_Name___Local)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($first_Name___Local, true), gettype($first_Name___Local)), __LINE__);
        }
        $this->First_Name___Local = $this->{'First_Name_-_Local'} = $first_Name___Local;
        return $this;
    }
    /**
     * Get Middle_Name___Local value
     * @return string|null
     */
    public function getMiddle_Name___Local()
    {
        return $this->{'Middle_Name_-_Local'};
    }
    /**
     * Set Middle_Name___Local value
     * @param string $middle_Name___Local
     * @return \StructType\Candidate_Local_Name_Detail_DataType
     */
    public function setMiddle_Name___Local($middle_Name___Local = null)
    {
        // validation for constraint: string
        if (!is_null($middle_Name___Local) && !is_string($middle_Name___Local)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middle_Name___Local, true), gettype($middle_Name___Local)), __LINE__);
        }
        $this->Middle_Name___Local = $this->{'Middle_Name_-_Local'} = $middle_Name___Local;
        return $this;
    }
    /**
     * Get Last_Name___Local value
     * @return string|null
     */
    public function getLast_Name___Local()
    {
        return $this->{'Last_Name_-_Local'};
    }
    /**
     * Set Last_Name___Local value
     * @param string $last_Name___Local
     * @return \StructType\Candidate_Local_Name_Detail_DataType
     */
    public function setLast_Name___Local($last_Name___Local = null)
    {
        // validation for constraint: string
        if (!is_null($last_Name___Local) && !is_string($last_Name___Local)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_Name___Local, true), gettype($last_Name___Local)), __LINE__);
        }
        $this->Last_Name___Local = $this->{'Last_Name_-_Local'} = $last_Name___Local;
        return $this;
    }
    /**
     * Get Secondary_Last_Name___Local value
     * @return string|null
     */
    public function getSecondary_Last_Name___Local()
    {
        return $this->{'Secondary_Last_Name_-_Local'};
    }
    /**
     * Set Secondary_Last_Name___Local value
     * @param string $secondary_Last_Name___Local
     * @return \StructType\Candidate_Local_Name_Detail_DataType
     */
    public function setSecondary_Last_Name___Local($secondary_Last_Name___Local = null)
    {
        // validation for constraint: string
        if (!is_null($secondary_Last_Name___Local) && !is_string($secondary_Last_Name___Local)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondary_Last_Name___Local, true), gettype($secondary_Last_Name___Local)), __LINE__);
        }
        $this->Secondary_Last_Name___Local = $this->{'Secondary_Last_Name_-_Local'} = $secondary_Last_Name___Local;
        return $this;
    }
    /**
     * Get First_Name___Local value
     * @return string|null
     */
    public function getFirst_Name_2___Local()
    {
        return $this->{'First_Name_2_-_Local'};
    }
    /**
     * Set First_Name___Local value
     * @param string $first_Name___Local
     * @return \StructType\Candidate_Local_Name_Detail_DataType
     */
    public function setFirst_Name_2___Local($first_Name_2___Local = null)
    {
        // validation for constraint: string
        if (!is_null($first_Name_2___Local) && !is_string($first_Name_2___Local)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($first_Name_2___Local, true), gettype($first_Name_2___Local)), __LINE__);
        }
        $this->First_Name_2___Local = $this->{'First_Name_2_-_Local'} = $first_Name_2___Local;
        return $this;
    }
    /**
     * Get Last_Name___Local value
     * @return string|null
     */
    public function getLast_Name_2___Local()
    {
        return $this->{'Last_Name_2_-_Local'};
    }
    /**
     * Set Last_Name___Local value
     * @param string $last_Name___Local
     * @return \StructType\Candidate_Local_Name_Detail_DataType
     */
    public function setLast_Name_2___Local($last_Name_2___Local = null)
    {
        // validation for constraint: string
        if (!is_null($last_Name_2___Local) && !is_string($last_Name_2___Local)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_Name_2___Local, true), gettype($last_Name_2___Local)), __LINE__);
        }
        $this->Last_Name_2___Local = $this->{'Last_Name_2_-_Local'} = $last_Name_2___Local;
        return $this;
    }
}
