<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Education_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains education details for the candidate.
 * @subpackage Structs
 */
class Candidate_Education_DataType extends AbstractStructBase
{
    /**
     * The School_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Reference of the School where the education was received. The Schools report returns all of the schools that can be referenced.
     * - minOccurs: 0
     * @var \StructType\SchoolObjectType
     */
    public $School_Reference;
    /**
     * The School_Name
     * Meta information extracted from the WSDL
     * - documentation: The name of the school.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $School_Name;
    /**
     * The First_Year_Attended
     * Meta information extracted from the WSDL
     * - documentation: The first year of attendance. This field should be in YYYY-MM-DD format, however the month and day will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var float
     */
    public $First_Year_Attended;
    /**
     * The Last_Year_Attended
     * Meta information extracted from the WSDL
     * - documentation: The last year of attendance. Should be displayed in YYYY-MM-DD format, but the month and day will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var float
     */
    public $Last_Year_Attended;
    /**
     * The Degree_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference to the degree completed.
     * - minOccurs: 0
     * @var \StructType\DegreeObjectType
     */
    public $Degree_Reference;
    /**
     * The Field_of_Study_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference to the field of study for the degree.
     * - minOccurs: 0
     * @var \StructType\Field_of_StudyObjectType
     */
    public $Field_of_Study_Reference;
    /**
     * The Grade_Average
     * Meta information extracted from the WSDL
     * - documentation: The grade point average.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Grade_Average;
    /**
     * Constructor method for Candidate_Education_DataType
     * @uses Candidate_Education_DataType::setSchool_Reference()
     * @uses Candidate_Education_DataType::setSchool_Name()
     * @uses Candidate_Education_DataType::setFirst_Year_Attended()
     * @uses Candidate_Education_DataType::setLast_Year_Attended()
     * @uses Candidate_Education_DataType::setDegree_Reference()
     * @uses Candidate_Education_DataType::setField_of_Study_Reference()
     * @uses Candidate_Education_DataType::setGrade_Average()
     * @param \StructType\SchoolObjectType $school_Reference
     * @param string $school_Name
     * @param float $first_Year_Attended
     * @param float $last_Year_Attended
     * @param \StructType\DegreeObjectType $degree_Reference
     * @param \StructType\Field_of_StudyObjectType $field_of_Study_Reference
     * @param string $grade_Average
     */
    public function __construct(\StructType\SchoolObjectType $school_Reference = null, $school_Name = null, $first_Year_Attended = null, $last_Year_Attended = null, \StructType\DegreeObjectType $degree_Reference = null, \StructType\Field_of_StudyObjectType $field_of_Study_Reference = null, $grade_Average = null)
    {
        $this
            ->setSchool_Reference($school_Reference)
            ->setSchool_Name($school_Name)
            ->setFirst_Year_Attended($first_Year_Attended)
            ->setLast_Year_Attended($last_Year_Attended)
            ->setDegree_Reference($degree_Reference)
            ->setField_of_Study_Reference($field_of_Study_Reference)
            ->setGrade_Average($grade_Average);
    }
    /**
     * Get School_Reference value
     * @return \StructType\SchoolObjectType|null
     */
    public function getSchool_Reference()
    {
        return $this->School_Reference;
    }
    /**
     * Set School_Reference value
     * @param \StructType\SchoolObjectType $school_Reference
     * @return \StructType\Candidate_Education_DataType
     */
    public function setSchool_Reference(\StructType\SchoolObjectType $school_Reference = null)
    {
        $this->School_Reference = $school_Reference;
        return $this;
    }
    /**
     * Get School_Name value
     * @return string|null
     */
    public function getSchool_Name()
    {
        return $this->School_Name;
    }
    /**
     * Set School_Name value
     * @param string $school_Name
     * @return \StructType\Candidate_Education_DataType
     */
    public function setSchool_Name($school_Name = null)
    {
        // validation for constraint: string
        if (!is_null($school_Name) && !is_string($school_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($school_Name, true), gettype($school_Name)), __LINE__);
        }
        $this->School_Name = $school_Name;
        return $this;
    }
    /**
     * Get First_Year_Attended value
     * @return float|null
     */
    public function getFirst_Year_Attended()
    {
        return $this->First_Year_Attended;
    }
    /**
     * Set First_Year_Attended value
     * @param float $first_Year_Attended
     * @return \StructType\Candidate_Education_DataType
     */
    public function setFirst_Year_Attended($first_Year_Attended = null)
    {
        // validation for constraint: float
        if (!is_null($first_Year_Attended) && !(is_float($first_Year_Attended) || is_numeric($first_Year_Attended))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($first_Year_Attended, true), gettype($first_Year_Attended)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($first_Year_Attended) && mb_strlen(mb_substr($first_Year_Attended, false !== mb_strpos($first_Year_Attended, '.') ? mb_strpos($first_Year_Attended, '.') + 1 : mb_strlen($first_Year_Attended))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($first_Year_Attended, true), mb_strlen(mb_substr($first_Year_Attended, mb_strpos($first_Year_Attended, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($first_Year_Attended) && $first_Year_Attended < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($first_Year_Attended, true)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($first_Year_Attended) && mb_strlen(preg_replace('/(\D)/', '', $first_Year_Attended)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($first_Year_Attended, true), mb_strlen(preg_replace('/(\D)/', '', $first_Year_Attended))), __LINE__);
        }
        $this->First_Year_Attended = $first_Year_Attended;
        return $this;
    }
    /**
     * Get Last_Year_Attended value
     * @return float|null
     */
    public function getLast_Year_Attended()
    {
        return $this->Last_Year_Attended;
    }
    /**
     * Set Last_Year_Attended value
     * @param float $last_Year_Attended
     * @return \StructType\Candidate_Education_DataType
     */
    public function setLast_Year_Attended($last_Year_Attended = null)
    {
        // validation for constraint: float
        if (!is_null($last_Year_Attended) && !(is_float($last_Year_Attended) || is_numeric($last_Year_Attended))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($last_Year_Attended, true), gettype($last_Year_Attended)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($last_Year_Attended) && mb_strlen(mb_substr($last_Year_Attended, false !== mb_strpos($last_Year_Attended, '.') ? mb_strpos($last_Year_Attended, '.') + 1 : mb_strlen($last_Year_Attended))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($last_Year_Attended, true), mb_strlen(mb_substr($last_Year_Attended, mb_strpos($last_Year_Attended, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($last_Year_Attended) && $last_Year_Attended < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($last_Year_Attended, true)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($last_Year_Attended) && mb_strlen(preg_replace('/(\D)/', '', $last_Year_Attended)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($last_Year_Attended, true), mb_strlen(preg_replace('/(\D)/', '', $last_Year_Attended))), __LINE__);
        }
        $this->Last_Year_Attended = $last_Year_Attended;
        return $this;
    }
    /**
     * Get Degree_Reference value
     * @return \StructType\DegreeObjectType|null
     */
    public function getDegree_Reference()
    {
        return $this->Degree_Reference;
    }
    /**
     * Set Degree_Reference value
     * @param \StructType\DegreeObjectType $degree_Reference
     * @return \StructType\Candidate_Education_DataType
     */
    public function setDegree_Reference(\StructType\DegreeObjectType $degree_Reference = null)
    {
        $this->Degree_Reference = $degree_Reference;
        return $this;
    }
    /**
     * Get Field_of_Study_Reference value
     * @return \StructType\Field_of_StudyObjectType|null
     */
    public function getField_of_Study_Reference()
    {
        return $this->Field_of_Study_Reference;
    }
    /**
     * Set Field_of_Study_Reference value
     * @param \StructType\Field_of_StudyObjectType $field_of_Study_Reference
     * @return \StructType\Candidate_Education_DataType
     */
    public function setField_of_Study_Reference(\StructType\Field_of_StudyObjectType $field_of_Study_Reference = null)
    {
        $this->Field_of_Study_Reference = $field_of_Study_Reference;
        return $this;
    }
    /**
     * Get Grade_Average value
     * @return string|null
     */
    public function getGrade_Average()
    {
        return $this->Grade_Average;
    }
    /**
     * Set Grade_Average value
     * @param string $grade_Average
     * @return \StructType\Candidate_Education_DataType
     */
    public function setGrade_Average($grade_Average = null)
    {
        // validation for constraint: string
        if (!is_null($grade_Average) && !is_string($grade_Average)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grade_Average, true), gettype($grade_Average)), __LINE__);
        }
        $this->Grade_Average = $grade_Average;
        return $this;
    }
}
