<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Brand_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains Site Brand data.
 * @subpackage Structs
 */
class Brand_Response_DataType extends AbstractStructBase
{
    /**
     * The Brand
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BrandType[]
     */
    public $Brand;
    /**
     * Constructor method for Brand_Response_DataType
     * @uses Brand_Response_DataType::setBrand()
     * @param \StructType\BrandType[] $brand
     */
    public function __construct(array $brand = array())
    {
        $this
            ->setBrand($brand);
    }
    /**
     * Get Brand value
     * @return \StructType\BrandType[]|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * This method is responsible for validating the values passed to the setBrand method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBrand method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBrandForArrayConstraintsFromSetBrand(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $brand_Response_DataTypeBrandItem) {
            // validation for constraint: itemType
            if (!$brand_Response_DataTypeBrandItem instanceof \StructType\BrandType) {
                $invalidValues[] = is_object($brand_Response_DataTypeBrandItem) ? get_class($brand_Response_DataTypeBrandItem) : sprintf('%s(%s)', gettype($brand_Response_DataTypeBrandItem), var_export($brand_Response_DataTypeBrandItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Brand property can only contain items of type \StructType\BrandType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Brand value
     * @throws \InvalidArgumentException
     * @param \StructType\BrandType[] $brand
     * @return \StructType\Brand_Response_DataType
     */
    public function setBrand(array $brand = array())
    {
        // validation for constraint: array
        if ('' !== ($brandArrayErrorMessage = self::validateBrandForArrayConstraintsFromSetBrand($brand))) {
            throw new \InvalidArgumentException($brandArrayErrorMessage, __LINE__);
        }
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Add item to Brand value
     * @throws \InvalidArgumentException
     * @param \StructType\BrandType $item
     * @return \StructType\Brand_Response_DataType
     */
    public function addToBrand(\StructType\BrandType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BrandType) {
            throw new \InvalidArgumentException(sprintf('The Brand property can only contain items of type \StructType\BrandType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Brand[] = $item;
        return $this;
    }
}
