<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Brand_Image_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The file type you entered isn't supported. Enter 1 of these image file types: JPEG, GIF, PNG, BMP, SVG. | Fill out all of these fields: File Name, File, and Mime Type. | Element container for image of brand.
 * @subpackage Structs
 */
class Brand_Image_DataType extends AbstractStructBase
{
    /**
     * The File_Name
     * Meta information extracted from the WSDL
     * - documentation: Specify a file name. | Text attribute identifying Filename of the Attachment. | Filename for the attachment.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $File_Name;
    /**
     * The File
     * Meta information extracted from the WSDL
     * - documentation: File content in binary format.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $File;
    /**
     * The Mime_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Mime Type Reference
     * - minOccurs: 0
     * @var \StructType\Mime_TypeObjectType
     */
    public $Mime_Type_Reference;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - documentation: Height of Image.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 6
     * @var float
     */
    public $Height;
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - documentation: Width of Image.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 6
     * @var float
     */
    public $Width;
    /**
     * Constructor method for Brand_Image_DataType
     * @uses Brand_Image_DataType::setFile_Name()
     * @uses Brand_Image_DataType::setFile()
     * @uses Brand_Image_DataType::setMime_Type_Reference()
     * @uses Brand_Image_DataType::setHeight()
     * @uses Brand_Image_DataType::setWidth()
     * @param string $file_Name
     * @param string $file
     * @param \StructType\Mime_TypeObjectType $mime_Type_Reference
     * @param float $height
     * @param float $width
     */
    public function __construct($file_Name = null, $file = null, \StructType\Mime_TypeObjectType $mime_Type_Reference = null, $height = null, $width = null)
    {
        $this
            ->setFile_Name($file_Name)
            ->setFile($file)
            ->setMime_Type_Reference($mime_Type_Reference)
            ->setHeight($height)
            ->setWidth($width);
    }
    /**
     * Get File_Name value
     * @return string|null
     */
    public function getFile_Name()
    {
        return $this->File_Name;
    }
    /**
     * Set File_Name value
     * @param string $file_Name
     * @return \StructType\Brand_Image_DataType
     */
    public function setFile_Name($file_Name = null)
    {
        // validation for constraint: string
        if (!is_null($file_Name) && !is_string($file_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($file_Name, true), gettype($file_Name)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($file_Name) && mb_strlen($file_Name) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($file_Name)), __LINE__);
        }
        $this->File_Name = $file_Name;
        return $this;
    }
    /**
     * Get File value
     * @return string|null
     */
    public function getFile()
    {
        return $this->File;
    }
    /**
     * Set File value
     * @param string $file
     * @return \StructType\Brand_Image_DataType
     */
    public function setFile($file = null)
    {
        // validation for constraint: string
        if (!is_null($file) && !is_string($file)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($file, true), gettype($file)), __LINE__);
        }
        $this->File = $file;
        return $this;
    }
    /**
     * Get Mime_Type_Reference value
     * @return \StructType\Mime_TypeObjectType|null
     */
    public function getMime_Type_Reference()
    {
        return $this->Mime_Type_Reference;
    }
    /**
     * Set Mime_Type_Reference value
     * @param \StructType\Mime_TypeObjectType $mime_Type_Reference
     * @return \StructType\Brand_Image_DataType
     */
    public function setMime_Type_Reference(\StructType\Mime_TypeObjectType $mime_Type_Reference = null)
    {
        $this->Mime_Type_Reference = $mime_Type_Reference;
        return $this;
    }
    /**
     * Get Height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param float $height
     * @return \StructType\Brand_Image_DataType
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($height) && mb_strlen(mb_substr($height, false !== mb_strpos($height, '.') ? mb_strpos($height, '.') + 1 : mb_strlen($height))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($height, true), mb_strlen(mb_substr($height, mb_strpos($height, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($height) && $height < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($height, true)), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($height) && mb_strlen(preg_replace('/(\D)/', '', $height)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($height, true), mb_strlen(preg_replace('/(\D)/', '', $height))), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
    /**
     * Get Width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param float $width
     * @return \StructType\Brand_Image_DataType
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($width) && mb_strlen(mb_substr($width, false !== mb_strpos($width, '.') ? mb_strpos($width, '.') + 1 : mb_strlen($width))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($width, true), mb_strlen(mb_substr($width, mb_strpos($width, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($width) && $width < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($width, true)), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($width) && mb_strlen(preg_replace('/(\D)/', '', $width)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($width, true), mb_strlen(preg_replace('/(\D)/', '', $width))), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
}
