<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Background_Check_Package_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element containing Background Check Package Response Data for requested references or criteria and for requested response group.
 * @subpackage Structs
 */
class Background_Check_Package_Response_DataType extends AbstractStructBase
{
    /**
     * The Background_Check_Package
     * Meta information extracted from the WSDL
     * - documentation: Contains Background Check Package details.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Background_Check_PackageType[]
     */
    public $Background_Check_Package;
    /**
     * Constructor method for Background_Check_Package_Response_DataType
     * @uses Background_Check_Package_Response_DataType::setBackground_Check_Package()
     * @param \StructType\Background_Check_PackageType[] $background_Check_Package
     */
    public function __construct(array $background_Check_Package = array())
    {
        $this
            ->setBackground_Check_Package($background_Check_Package);
    }
    /**
     * Get Background_Check_Package value
     * @return \StructType\Background_Check_PackageType[]|null
     */
    public function getBackground_Check_Package()
    {
        return $this->Background_Check_Package;
    }
    /**
     * This method is responsible for validating the values passed to the setBackground_Check_Package method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBackground_Check_Package method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBackground_Check_PackageForArrayConstraintsFromSetBackground_Check_Package(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $background_Check_Package_Response_DataTypeBackground_Check_PackageItem) {
            // validation for constraint: itemType
            if (!$background_Check_Package_Response_DataTypeBackground_Check_PackageItem instanceof \StructType\Background_Check_PackageType) {
                $invalidValues[] = is_object($background_Check_Package_Response_DataTypeBackground_Check_PackageItem) ? get_class($background_Check_Package_Response_DataTypeBackground_Check_PackageItem) : sprintf('%s(%s)', gettype($background_Check_Package_Response_DataTypeBackground_Check_PackageItem), var_export($background_Check_Package_Response_DataTypeBackground_Check_PackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Background_Check_Package property can only contain items of type \StructType\Background_Check_PackageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Background_Check_Package value
     * @throws \InvalidArgumentException
     * @param \StructType\Background_Check_PackageType[] $background_Check_Package
     * @return \StructType\Background_Check_Package_Response_DataType
     */
    public function setBackground_Check_Package(array $background_Check_Package = array())
    {
        // validation for constraint: array
        if ('' !== ($background_Check_PackageArrayErrorMessage = self::validateBackground_Check_PackageForArrayConstraintsFromSetBackground_Check_Package($background_Check_Package))) {
            throw new \InvalidArgumentException($background_Check_PackageArrayErrorMessage, __LINE__);
        }
        $this->Background_Check_Package = $background_Check_Package;
        return $this;
    }
    /**
     * Add item to Background_Check_Package value
     * @throws \InvalidArgumentException
     * @param \StructType\Background_Check_PackageType $item
     * @return \StructType\Background_Check_Package_Response_DataType
     */
    public function addToBackground_Check_Package(\StructType\Background_Check_PackageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Background_Check_PackageType) {
            throw new \InvalidArgumentException(sprintf('The Background_Check_Package property can only contain items of type \StructType\Background_Check_PackageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Background_Check_Package[] = $item;
        return $this;
    }
}
