<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Background_Check_EventType StructType
 * Meta information extracted from the WSDL
 * - documentation: Details for a Background Check Event
 * @subpackage Structs
 */
class Background_Check_EventType extends AbstractStructBase
{
    /**
     * The Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Background Check Event.
     * - minOccurs: 0
     * @var \StructType\Background_Check_EventObjectType
     */
    public $Event_Reference;
    /**
     * The Recruiting_Sub_Process
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether this Background Check is a sub-process of the Recruiting process.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Recruiting_Sub_Process;
    /**
     * The Requester_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the background check submitter.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Requester_Reference;
    /**
     * The Recipient_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the screening recipient.
     * - minOccurs: 0
     * @var \StructType\RoleObjectType
     */
    public $Recipient_Reference;
    /**
     * The Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the job this test is for.
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_EnabledObjectType
     */
    public $Requisition_Reference;
    /**
     * The Submission_Date
     * Meta information extracted from the WSDL
     * - documentation: Date the background check event was initiated.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Submission_Date;
    /**
     * The Background_Check_Status_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Background_Check_Overall_Status_DataType
     */
    public $Background_Check_Status_Data;
    /**
     * The Workflow_State_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference to the State of the Event.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Workflow_State_Reference;
    /**
     * The Package_Reference_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Package_Reference_DataType[]
     */
    public $Package_Reference_Data;
    /**
     * The Test_Reference_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Test_Reference_DataType[]
     */
    public $Test_Reference_Data;
    /**
     * The Document_Field_Result_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_Field_Result_DataType[]
     */
    public $Document_Field_Result_Data;
    /**
     * Constructor method for Background_Check_EventType
     * @uses Background_Check_EventType::setEvent_Reference()
     * @uses Background_Check_EventType::setRecruiting_Sub_Process()
     * @uses Background_Check_EventType::setRequester_Reference()
     * @uses Background_Check_EventType::setRecipient_Reference()
     * @uses Background_Check_EventType::setRequisition_Reference()
     * @uses Background_Check_EventType::setSubmission_Date()
     * @uses Background_Check_EventType::setBackground_Check_Status_Data()
     * @uses Background_Check_EventType::setWorkflow_State_Reference()
     * @uses Background_Check_EventType::setPackage_Reference_Data()
     * @uses Background_Check_EventType::setTest_Reference_Data()
     * @uses Background_Check_EventType::setDocument_Field_Result_Data()
     * @param \StructType\Background_Check_EventObjectType $event_Reference
     * @param bool $recruiting_Sub_Process
     * @param \StructType\WorkerObjectType $requester_Reference
     * @param \StructType\RoleObjectType $recipient_Reference
     * @param \StructType\Job_Requisition_EnabledObjectType $requisition_Reference
     * @param string $submission_Date
     * @param \StructType\Background_Check_Overall_Status_DataType $background_Check_Status_Data
     * @param \StructType\Unique_IdentifierObjectType $workflow_State_Reference
     * @param \StructType\Package_Reference_DataType[] $package_Reference_Data
     * @param \StructType\Test_Reference_DataType[] $test_Reference_Data
     * @param \StructType\Document_Field_Result_DataType[] $document_Field_Result_Data
     */
    public function __construct(\StructType\Background_Check_EventObjectType $event_Reference = null, $recruiting_Sub_Process = null, \StructType\WorkerObjectType $requester_Reference = null, \StructType\RoleObjectType $recipient_Reference = null, \StructType\Job_Requisition_EnabledObjectType $requisition_Reference = null, $submission_Date = null, \StructType\Background_Check_Overall_Status_DataType $background_Check_Status_Data = null, \StructType\Unique_IdentifierObjectType $workflow_State_Reference = null, array $package_Reference_Data = array(), array $test_Reference_Data = array(), array $document_Field_Result_Data = array())
    {
        $this
            ->setEvent_Reference($event_Reference)
            ->setRecruiting_Sub_Process($recruiting_Sub_Process)
            ->setRequester_Reference($requester_Reference)
            ->setRecipient_Reference($recipient_Reference)
            ->setRequisition_Reference($requisition_Reference)
            ->setSubmission_Date($submission_Date)
            ->setBackground_Check_Status_Data($background_Check_Status_Data)
            ->setWorkflow_State_Reference($workflow_State_Reference)
            ->setPackage_Reference_Data($package_Reference_Data)
            ->setTest_Reference_Data($test_Reference_Data)
            ->setDocument_Field_Result_Data($document_Field_Result_Data);
    }
    /**
     * Get Event_Reference value
     * @return \StructType\Background_Check_EventObjectType|null
     */
    public function getEvent_Reference()
    {
        return $this->Event_Reference;
    }
    /**
     * Set Event_Reference value
     * @param \StructType\Background_Check_EventObjectType $event_Reference
     * @return \StructType\Background_Check_EventType
     */
    public function setEvent_Reference(\StructType\Background_Check_EventObjectType $event_Reference = null)
    {
        $this->Event_Reference = $event_Reference;
        return $this;
    }
    /**
     * Get Recruiting_Sub_Process value
     * @return bool|null
     */
    public function getRecruiting_Sub_Process()
    {
        return $this->Recruiting_Sub_Process;
    }
    /**
     * Set Recruiting_Sub_Process value
     * @param bool $recruiting_Sub_Process
     * @return \StructType\Background_Check_EventType
     */
    public function setRecruiting_Sub_Process($recruiting_Sub_Process = null)
    {
        // validation for constraint: boolean
        if (!is_null($recruiting_Sub_Process) && !is_bool($recruiting_Sub_Process)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recruiting_Sub_Process, true), gettype($recruiting_Sub_Process)), __LINE__);
        }
        $this->Recruiting_Sub_Process = $recruiting_Sub_Process;
        return $this;
    }
    /**
     * Get Requester_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getRequester_Reference()
    {
        return $this->Requester_Reference;
    }
    /**
     * Set Requester_Reference value
     * @param \StructType\WorkerObjectType $requester_Reference
     * @return \StructType\Background_Check_EventType
     */
    public function setRequester_Reference(\StructType\WorkerObjectType $requester_Reference = null)
    {
        $this->Requester_Reference = $requester_Reference;
        return $this;
    }
    /**
     * Get Recipient_Reference value
     * @return \StructType\RoleObjectType|null
     */
    public function getRecipient_Reference()
    {
        return $this->Recipient_Reference;
    }
    /**
     * Set Recipient_Reference value
     * @param \StructType\RoleObjectType $recipient_Reference
     * @return \StructType\Background_Check_EventType
     */
    public function setRecipient_Reference(\StructType\RoleObjectType $recipient_Reference = null)
    {
        $this->Recipient_Reference = $recipient_Reference;
        return $this;
    }
    /**
     * Get Requisition_Reference value
     * @return \StructType\Job_Requisition_EnabledObjectType|null
     */
    public function getRequisition_Reference()
    {
        return $this->Requisition_Reference;
    }
    /**
     * Set Requisition_Reference value
     * @param \StructType\Job_Requisition_EnabledObjectType $requisition_Reference
     * @return \StructType\Background_Check_EventType
     */
    public function setRequisition_Reference(\StructType\Job_Requisition_EnabledObjectType $requisition_Reference = null)
    {
        $this->Requisition_Reference = $requisition_Reference;
        return $this;
    }
    /**
     * Get Submission_Date value
     * @return string|null
     */
    public function getSubmission_Date()
    {
        return $this->Submission_Date;
    }
    /**
     * Set Submission_Date value
     * @param string $submission_Date
     * @return \StructType\Background_Check_EventType
     */
    public function setSubmission_Date($submission_Date = null)
    {
        // validation for constraint: string
        if (!is_null($submission_Date) && !is_string($submission_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($submission_Date, true), gettype($submission_Date)), __LINE__);
        }
        $this->Submission_Date = $submission_Date;
        return $this;
    }
    /**
     * Get Background_Check_Status_Data value
     * @return \StructType\Background_Check_Overall_Status_DataType|null
     */
    public function getBackground_Check_Status_Data()
    {
        return $this->Background_Check_Status_Data;
    }
    /**
     * Set Background_Check_Status_Data value
     * @param \StructType\Background_Check_Overall_Status_DataType $background_Check_Status_Data
     * @return \StructType\Background_Check_EventType
     */
    public function setBackground_Check_Status_Data(\StructType\Background_Check_Overall_Status_DataType $background_Check_Status_Data = null)
    {
        $this->Background_Check_Status_Data = $background_Check_Status_Data;
        return $this;
    }
    /**
     * Get Workflow_State_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getWorkflow_State_Reference()
    {
        return $this->Workflow_State_Reference;
    }
    /**
     * Set Workflow_State_Reference value
     * @param \StructType\Unique_IdentifierObjectType $workflow_State_Reference
     * @return \StructType\Background_Check_EventType
     */
    public function setWorkflow_State_Reference(\StructType\Unique_IdentifierObjectType $workflow_State_Reference = null)
    {
        $this->Workflow_State_Reference = $workflow_State_Reference;
        return $this;
    }
    /**
     * Get Package_Reference_Data value
     * @return \StructType\Package_Reference_DataType[]|null
     */
    public function getPackage_Reference_Data()
    {
        return $this->Package_Reference_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPackage_Reference_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackage_Reference_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackage_Reference_DataForArrayConstraintsFromSetPackage_Reference_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $background_Check_EventTypePackage_Reference_DataItem) {
            // validation for constraint: itemType
            if (!$background_Check_EventTypePackage_Reference_DataItem instanceof \StructType\Package_Reference_DataType) {
                $invalidValues[] = is_object($background_Check_EventTypePackage_Reference_DataItem) ? get_class($background_Check_EventTypePackage_Reference_DataItem) : sprintf('%s(%s)', gettype($background_Check_EventTypePackage_Reference_DataItem), var_export($background_Check_EventTypePackage_Reference_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Package_Reference_Data property can only contain items of type \StructType\Package_Reference_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Package_Reference_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Package_Reference_DataType[] $package_Reference_Data
     * @return \StructType\Background_Check_EventType
     */
    public function setPackage_Reference_Data(array $package_Reference_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($package_Reference_DataArrayErrorMessage = self::validatePackage_Reference_DataForArrayConstraintsFromSetPackage_Reference_Data($package_Reference_Data))) {
            throw new \InvalidArgumentException($package_Reference_DataArrayErrorMessage, __LINE__);
        }
        $this->Package_Reference_Data = $package_Reference_Data;
        return $this;
    }
    /**
     * Add item to Package_Reference_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Package_Reference_DataType $item
     * @return \StructType\Background_Check_EventType
     */
    public function addToPackage_Reference_Data(\StructType\Package_Reference_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Package_Reference_DataType) {
            throw new \InvalidArgumentException(sprintf('The Package_Reference_Data property can only contain items of type \StructType\Package_Reference_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Package_Reference_Data[] = $item;
        return $this;
    }
    /**
     * Get Test_Reference_Data value
     * @return \StructType\Test_Reference_DataType[]|null
     */
    public function getTest_Reference_Data()
    {
        return $this->Test_Reference_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTest_Reference_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTest_Reference_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTest_Reference_DataForArrayConstraintsFromSetTest_Reference_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $background_Check_EventTypeTest_Reference_DataItem) {
            // validation for constraint: itemType
            if (!$background_Check_EventTypeTest_Reference_DataItem instanceof \StructType\Test_Reference_DataType) {
                $invalidValues[] = is_object($background_Check_EventTypeTest_Reference_DataItem) ? get_class($background_Check_EventTypeTest_Reference_DataItem) : sprintf('%s(%s)', gettype($background_Check_EventTypeTest_Reference_DataItem), var_export($background_Check_EventTypeTest_Reference_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Test_Reference_Data property can only contain items of type \StructType\Test_Reference_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Test_Reference_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Test_Reference_DataType[] $test_Reference_Data
     * @return \StructType\Background_Check_EventType
     */
    public function setTest_Reference_Data(array $test_Reference_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($test_Reference_DataArrayErrorMessage = self::validateTest_Reference_DataForArrayConstraintsFromSetTest_Reference_Data($test_Reference_Data))) {
            throw new \InvalidArgumentException($test_Reference_DataArrayErrorMessage, __LINE__);
        }
        $this->Test_Reference_Data = $test_Reference_Data;
        return $this;
    }
    /**
     * Add item to Test_Reference_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Test_Reference_DataType $item
     * @return \StructType\Background_Check_EventType
     */
    public function addToTest_Reference_Data(\StructType\Test_Reference_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Test_Reference_DataType) {
            throw new \InvalidArgumentException(sprintf('The Test_Reference_Data property can only contain items of type \StructType\Test_Reference_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Test_Reference_Data[] = $item;
        return $this;
    }
    /**
     * Get Document_Field_Result_Data value
     * @return \StructType\Document_Field_Result_DataType[]|null
     */
    public function getDocument_Field_Result_Data()
    {
        return $this->Document_Field_Result_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument_Field_Result_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument_Field_Result_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocument_Field_Result_DataForArrayConstraintsFromSetDocument_Field_Result_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $background_Check_EventTypeDocument_Field_Result_DataItem) {
            // validation for constraint: itemType
            if (!$background_Check_EventTypeDocument_Field_Result_DataItem instanceof \StructType\Document_Field_Result_DataType) {
                $invalidValues[] = is_object($background_Check_EventTypeDocument_Field_Result_DataItem) ? get_class($background_Check_EventTypeDocument_Field_Result_DataItem) : sprintf('%s(%s)', gettype($background_Check_EventTypeDocument_Field_Result_DataItem), var_export($background_Check_EventTypeDocument_Field_Result_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Document_Field_Result_Data property can only contain items of type \StructType\Document_Field_Result_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Document_Field_Result_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_Field_Result_DataType[] $document_Field_Result_Data
     * @return \StructType\Background_Check_EventType
     */
    public function setDocument_Field_Result_Data(array $document_Field_Result_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($document_Field_Result_DataArrayErrorMessage = self::validateDocument_Field_Result_DataForArrayConstraintsFromSetDocument_Field_Result_Data($document_Field_Result_Data))) {
            throw new \InvalidArgumentException($document_Field_Result_DataArrayErrorMessage, __LINE__);
        }
        $this->Document_Field_Result_Data = $document_Field_Result_Data;
        return $this;
    }
    /**
     * Add item to Document_Field_Result_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_Field_Result_DataType $item
     * @return \StructType\Background_Check_EventType
     */
    public function addToDocument_Field_Result_Data(\StructType\Document_Field_Result_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_Field_Result_DataType) {
            throw new \InvalidArgumentException(sprintf('The Document_Field_Result_Data property can only contain items of type \StructType\Document_Field_Result_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Document_Field_Result_Data[] = $item;
        return $this;
    }
}
