<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Assign_Position_Organization_Event_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for Assign Position Organization business process.
 * @subpackage Structs
 */
class Assign_Position_Organization_Event_DataType extends AbstractStructBase
{
    /**
     * The Company_Assignments_Reference
     * Meta information extracted from the WSDL
     * - documentation: The companies assigned to the position. If empty, Workday will use the existing assignments.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType[]
     */
    public $Company_Assignments_Reference;
    /**
     * The Cost_Center_Assignments_Reference
     * Meta information extracted from the WSDL
     * - documentation: The cost centers assigned to the position. If empty, Workday will use the existing assignments.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Cost_CenterObjectType[]
     */
    public $Cost_Center_Assignments_Reference;
    /**
     * The Region_Assignments_Reference
     * Meta information extracted from the WSDL
     * - documentation: The regions assigned to the position. If empty, Workday will use the existing assignments.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RegionObjectType[]
     */
    public $Region_Assignments_Reference;
    /**
     * The Custom_Organization_Assignment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Custom_Organization_Assignment_DataType[]
     */
    public $Custom_Organization_Assignment_Data;
    /**
     * The Fund_Assignments_Reference
     * Meta information extracted from the WSDL
     * - documentation: The funds assigned to the position. If empty, Workday will use the existing assignment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FundObjectType[]
     */
    public $Fund_Assignments_Reference;
    /**
     * The Grant_Assignments_Reference
     * Meta information extracted from the WSDL
     * - documentation: The grants assigned to the position. If empty, Workday will use the existing assignment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GrantObjectType[]
     */
    public $Grant_Assignments_Reference;
    /**
     * The Program_Assignments_Reference
     * Meta information extracted from the WSDL
     * - documentation: The programs assigned to the position. If empty, Workday will use the existing assignment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProgramObjectType[]
     */
    public $Program_Assignments_Reference;
    /**
     * The Business_Unit_Assignments_Reference
     * Meta information extracted from the WSDL
     * - documentation: The business units assigned to the position. If empty, Workday will use the existing assignment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_UnitObjectType[]
     */
    public $Business_Unit_Assignments_Reference;
    /**
     * The Gift_Assignments_Reference
     * Meta information extracted from the WSDL
     * - documentation: The gifts assigned to the position. If empty, Workday will use the existing assignment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GiftObjectType[]
     */
    public $Gift_Assignments_Reference;
    /**
     * Constructor method for Assign_Position_Organization_Event_DataType
     * @uses Assign_Position_Organization_Event_DataType::setCompany_Assignments_Reference()
     * @uses Assign_Position_Organization_Event_DataType::setCost_Center_Assignments_Reference()
     * @uses Assign_Position_Organization_Event_DataType::setRegion_Assignments_Reference()
     * @uses Assign_Position_Organization_Event_DataType::setCustom_Organization_Assignment_Data()
     * @uses Assign_Position_Organization_Event_DataType::setFund_Assignments_Reference()
     * @uses Assign_Position_Organization_Event_DataType::setGrant_Assignments_Reference()
     * @uses Assign_Position_Organization_Event_DataType::setProgram_Assignments_Reference()
     * @uses Assign_Position_Organization_Event_DataType::setBusiness_Unit_Assignments_Reference()
     * @uses Assign_Position_Organization_Event_DataType::setGift_Assignments_Reference()
     * @param \StructType\CompanyObjectType[] $company_Assignments_Reference
     * @param \StructType\Cost_CenterObjectType[] $cost_Center_Assignments_Reference
     * @param \StructType\RegionObjectType[] $region_Assignments_Reference
     * @param \StructType\Custom_Organization_Assignment_DataType[] $custom_Organization_Assignment_Data
     * @param \StructType\FundObjectType[] $fund_Assignments_Reference
     * @param \StructType\GrantObjectType[] $grant_Assignments_Reference
     * @param \StructType\ProgramObjectType[] $program_Assignments_Reference
     * @param \StructType\Business_UnitObjectType[] $business_Unit_Assignments_Reference
     * @param \StructType\GiftObjectType[] $gift_Assignments_Reference
     */
    public function __construct(array $company_Assignments_Reference = array(), array $cost_Center_Assignments_Reference = array(), array $region_Assignments_Reference = array(), array $custom_Organization_Assignment_Data = array(), array $fund_Assignments_Reference = array(), array $grant_Assignments_Reference = array(), array $program_Assignments_Reference = array(), array $business_Unit_Assignments_Reference = array(), array $gift_Assignments_Reference = array())
    {
        $this
            ->setCompany_Assignments_Reference($company_Assignments_Reference)
            ->setCost_Center_Assignments_Reference($cost_Center_Assignments_Reference)
            ->setRegion_Assignments_Reference($region_Assignments_Reference)
            ->setCustom_Organization_Assignment_Data($custom_Organization_Assignment_Data)
            ->setFund_Assignments_Reference($fund_Assignments_Reference)
            ->setGrant_Assignments_Reference($grant_Assignments_Reference)
            ->setProgram_Assignments_Reference($program_Assignments_Reference)
            ->setBusiness_Unit_Assignments_Reference($business_Unit_Assignments_Reference)
            ->setGift_Assignments_Reference($gift_Assignments_Reference);
    }
    /**
     * Get Company_Assignments_Reference value
     * @return \StructType\CompanyObjectType[]|null
     */
    public function getCompany_Assignments_Reference()
    {
        return $this->Company_Assignments_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Assignments_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Assignments_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_Assignments_ReferenceForArrayConstraintsFromSetCompany_Assignments_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $assign_Position_Organization_Event_DataTypeCompany_Assignments_ReferenceItem) {
            // validation for constraint: itemType
            if (!$assign_Position_Organization_Event_DataTypeCompany_Assignments_ReferenceItem instanceof \StructType\CompanyObjectType) {
                $invalidValues[] = is_object($assign_Position_Organization_Event_DataTypeCompany_Assignments_ReferenceItem) ? get_class($assign_Position_Organization_Event_DataTypeCompany_Assignments_ReferenceItem) : sprintf('%s(%s)', gettype($assign_Position_Organization_Event_DataTypeCompany_Assignments_ReferenceItem), var_export($assign_Position_Organization_Event_DataTypeCompany_Assignments_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Assignments_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType[] $company_Assignments_Reference
     * @return \StructType\Assign_Position_Organization_Event_DataType
     */
    public function setCompany_Assignments_Reference(array $company_Assignments_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_Assignments_ReferenceArrayErrorMessage = self::validateCompany_Assignments_ReferenceForArrayConstraintsFromSetCompany_Assignments_Reference($company_Assignments_Reference))) {
            throw new \InvalidArgumentException($company_Assignments_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Assignments_Reference = $company_Assignments_Reference;
        return $this;
    }
    /**
     * Add item to Company_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType $item
     * @return \StructType\Assign_Position_Organization_Event_DataType
     */
    public function addToCompany_Assignments_Reference(\StructType\CompanyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Assignments_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Assignments_Reference[] = $item;
        return $this;
    }
    /**
     * Get Cost_Center_Assignments_Reference value
     * @return \StructType\Cost_CenterObjectType[]|null
     */
    public function getCost_Center_Assignments_Reference()
    {
        return $this->Cost_Center_Assignments_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCost_Center_Assignments_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCost_Center_Assignments_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCost_Center_Assignments_ReferenceForArrayConstraintsFromSetCost_Center_Assignments_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $assign_Position_Organization_Event_DataTypeCost_Center_Assignments_ReferenceItem) {
            // validation for constraint: itemType
            if (!$assign_Position_Organization_Event_DataTypeCost_Center_Assignments_ReferenceItem instanceof \StructType\Cost_CenterObjectType) {
                $invalidValues[] = is_object($assign_Position_Organization_Event_DataTypeCost_Center_Assignments_ReferenceItem) ? get_class($assign_Position_Organization_Event_DataTypeCost_Center_Assignments_ReferenceItem) : sprintf('%s(%s)', gettype($assign_Position_Organization_Event_DataTypeCost_Center_Assignments_ReferenceItem), var_export($assign_Position_Organization_Event_DataTypeCost_Center_Assignments_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Cost_Center_Assignments_Reference property can only contain items of type \StructType\Cost_CenterObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Cost_Center_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Cost_CenterObjectType[] $cost_Center_Assignments_Reference
     * @return \StructType\Assign_Position_Organization_Event_DataType
     */
    public function setCost_Center_Assignments_Reference(array $cost_Center_Assignments_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($cost_Center_Assignments_ReferenceArrayErrorMessage = self::validateCost_Center_Assignments_ReferenceForArrayConstraintsFromSetCost_Center_Assignments_Reference($cost_Center_Assignments_Reference))) {
            throw new \InvalidArgumentException($cost_Center_Assignments_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Cost_Center_Assignments_Reference = $cost_Center_Assignments_Reference;
        return $this;
    }
    /**
     * Add item to Cost_Center_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Cost_CenterObjectType $item
     * @return \StructType\Assign_Position_Organization_Event_DataType
     */
    public function addToCost_Center_Assignments_Reference(\StructType\Cost_CenterObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Cost_CenterObjectType) {
            throw new \InvalidArgumentException(sprintf('The Cost_Center_Assignments_Reference property can only contain items of type \StructType\Cost_CenterObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Cost_Center_Assignments_Reference[] = $item;
        return $this;
    }
    /**
     * Get Region_Assignments_Reference value
     * @return \StructType\RegionObjectType[]|null
     */
    public function getRegion_Assignments_Reference()
    {
        return $this->Region_Assignments_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRegion_Assignments_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRegion_Assignments_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRegion_Assignments_ReferenceForArrayConstraintsFromSetRegion_Assignments_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $assign_Position_Organization_Event_DataTypeRegion_Assignments_ReferenceItem) {
            // validation for constraint: itemType
            if (!$assign_Position_Organization_Event_DataTypeRegion_Assignments_ReferenceItem instanceof \StructType\RegionObjectType) {
                $invalidValues[] = is_object($assign_Position_Organization_Event_DataTypeRegion_Assignments_ReferenceItem) ? get_class($assign_Position_Organization_Event_DataTypeRegion_Assignments_ReferenceItem) : sprintf('%s(%s)', gettype($assign_Position_Organization_Event_DataTypeRegion_Assignments_ReferenceItem), var_export($assign_Position_Organization_Event_DataTypeRegion_Assignments_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Region_Assignments_Reference property can only contain items of type \StructType\RegionObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Region_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\RegionObjectType[] $region_Assignments_Reference
     * @return \StructType\Assign_Position_Organization_Event_DataType
     */
    public function setRegion_Assignments_Reference(array $region_Assignments_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($region_Assignments_ReferenceArrayErrorMessage = self::validateRegion_Assignments_ReferenceForArrayConstraintsFromSetRegion_Assignments_Reference($region_Assignments_Reference))) {
            throw new \InvalidArgumentException($region_Assignments_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Region_Assignments_Reference = $region_Assignments_Reference;
        return $this;
    }
    /**
     * Add item to Region_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\RegionObjectType $item
     * @return \StructType\Assign_Position_Organization_Event_DataType
     */
    public function addToRegion_Assignments_Reference(\StructType\RegionObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RegionObjectType) {
            throw new \InvalidArgumentException(sprintf('The Region_Assignments_Reference property can only contain items of type \StructType\RegionObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Region_Assignments_Reference[] = $item;
        return $this;
    }
    /**
     * Get Custom_Organization_Assignment_Data value
     * @return \StructType\Custom_Organization_Assignment_DataType[]|null
     */
    public function getCustom_Organization_Assignment_Data()
    {
        return $this->Custom_Organization_Assignment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCustom_Organization_Assignment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustom_Organization_Assignment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustom_Organization_Assignment_DataForArrayConstraintsFromSetCustom_Organization_Assignment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $assign_Position_Organization_Event_DataTypeCustom_Organization_Assignment_DataItem) {
            // validation for constraint: itemType
            if (!$assign_Position_Organization_Event_DataTypeCustom_Organization_Assignment_DataItem instanceof \StructType\Custom_Organization_Assignment_DataType) {
                $invalidValues[] = is_object($assign_Position_Organization_Event_DataTypeCustom_Organization_Assignment_DataItem) ? get_class($assign_Position_Organization_Event_DataTypeCustom_Organization_Assignment_DataItem) : sprintf('%s(%s)', gettype($assign_Position_Organization_Event_DataTypeCustom_Organization_Assignment_DataItem), var_export($assign_Position_Organization_Event_DataTypeCustom_Organization_Assignment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Custom_Organization_Assignment_Data property can only contain items of type \StructType\Custom_Organization_Assignment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Custom_Organization_Assignment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Custom_Organization_Assignment_DataType[] $custom_Organization_Assignment_Data
     * @return \StructType\Assign_Position_Organization_Event_DataType
     */
    public function setCustom_Organization_Assignment_Data(array $custom_Organization_Assignment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($custom_Organization_Assignment_DataArrayErrorMessage = self::validateCustom_Organization_Assignment_DataForArrayConstraintsFromSetCustom_Organization_Assignment_Data($custom_Organization_Assignment_Data))) {
            throw new \InvalidArgumentException($custom_Organization_Assignment_DataArrayErrorMessage, __LINE__);
        }
        $this->Custom_Organization_Assignment_Data = $custom_Organization_Assignment_Data;
        return $this;
    }
    /**
     * Add item to Custom_Organization_Assignment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Custom_Organization_Assignment_DataType $item
     * @return \StructType\Assign_Position_Organization_Event_DataType
     */
    public function addToCustom_Organization_Assignment_Data(\StructType\Custom_Organization_Assignment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Custom_Organization_Assignment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Custom_Organization_Assignment_Data property can only contain items of type \StructType\Custom_Organization_Assignment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Custom_Organization_Assignment_Data[] = $item;
        return $this;
    }
    /**
     * Get Fund_Assignments_Reference value
     * @return \StructType\FundObjectType[]|null
     */
    public function getFund_Assignments_Reference()
    {
        return $this->Fund_Assignments_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setFund_Assignments_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFund_Assignments_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFund_Assignments_ReferenceForArrayConstraintsFromSetFund_Assignments_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $assign_Position_Organization_Event_DataTypeFund_Assignments_ReferenceItem) {
            // validation for constraint: itemType
            if (!$assign_Position_Organization_Event_DataTypeFund_Assignments_ReferenceItem instanceof \StructType\FundObjectType) {
                $invalidValues[] = is_object($assign_Position_Organization_Event_DataTypeFund_Assignments_ReferenceItem) ? get_class($assign_Position_Organization_Event_DataTypeFund_Assignments_ReferenceItem) : sprintf('%s(%s)', gettype($assign_Position_Organization_Event_DataTypeFund_Assignments_ReferenceItem), var_export($assign_Position_Organization_Event_DataTypeFund_Assignments_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Fund_Assignments_Reference property can only contain items of type \StructType\FundObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Fund_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\FundObjectType[] $fund_Assignments_Reference
     * @return \StructType\Assign_Position_Organization_Event_DataType
     */
    public function setFund_Assignments_Reference(array $fund_Assignments_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($fund_Assignments_ReferenceArrayErrorMessage = self::validateFund_Assignments_ReferenceForArrayConstraintsFromSetFund_Assignments_Reference($fund_Assignments_Reference))) {
            throw new \InvalidArgumentException($fund_Assignments_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Fund_Assignments_Reference = $fund_Assignments_Reference;
        return $this;
    }
    /**
     * Add item to Fund_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\FundObjectType $item
     * @return \StructType\Assign_Position_Organization_Event_DataType
     */
    public function addToFund_Assignments_Reference(\StructType\FundObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FundObjectType) {
            throw new \InvalidArgumentException(sprintf('The Fund_Assignments_Reference property can only contain items of type \StructType\FundObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Fund_Assignments_Reference[] = $item;
        return $this;
    }
    /**
     * Get Grant_Assignments_Reference value
     * @return \StructType\GrantObjectType[]|null
     */
    public function getGrant_Assignments_Reference()
    {
        return $this->Grant_Assignments_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setGrant_Assignments_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGrant_Assignments_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGrant_Assignments_ReferenceForArrayConstraintsFromSetGrant_Assignments_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $assign_Position_Organization_Event_DataTypeGrant_Assignments_ReferenceItem) {
            // validation for constraint: itemType
            if (!$assign_Position_Organization_Event_DataTypeGrant_Assignments_ReferenceItem instanceof \StructType\GrantObjectType) {
                $invalidValues[] = is_object($assign_Position_Organization_Event_DataTypeGrant_Assignments_ReferenceItem) ? get_class($assign_Position_Organization_Event_DataTypeGrant_Assignments_ReferenceItem) : sprintf('%s(%s)', gettype($assign_Position_Organization_Event_DataTypeGrant_Assignments_ReferenceItem), var_export($assign_Position_Organization_Event_DataTypeGrant_Assignments_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Grant_Assignments_Reference property can only contain items of type \StructType\GrantObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Grant_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\GrantObjectType[] $grant_Assignments_Reference
     * @return \StructType\Assign_Position_Organization_Event_DataType
     */
    public function setGrant_Assignments_Reference(array $grant_Assignments_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($grant_Assignments_ReferenceArrayErrorMessage = self::validateGrant_Assignments_ReferenceForArrayConstraintsFromSetGrant_Assignments_Reference($grant_Assignments_Reference))) {
            throw new \InvalidArgumentException($grant_Assignments_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Grant_Assignments_Reference = $grant_Assignments_Reference;
        return $this;
    }
    /**
     * Add item to Grant_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\GrantObjectType $item
     * @return \StructType\Assign_Position_Organization_Event_DataType
     */
    public function addToGrant_Assignments_Reference(\StructType\GrantObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GrantObjectType) {
            throw new \InvalidArgumentException(sprintf('The Grant_Assignments_Reference property can only contain items of type \StructType\GrantObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Grant_Assignments_Reference[] = $item;
        return $this;
    }
    /**
     * Get Program_Assignments_Reference value
     * @return \StructType\ProgramObjectType[]|null
     */
    public function getProgram_Assignments_Reference()
    {
        return $this->Program_Assignments_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setProgram_Assignments_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProgram_Assignments_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProgram_Assignments_ReferenceForArrayConstraintsFromSetProgram_Assignments_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $assign_Position_Organization_Event_DataTypeProgram_Assignments_ReferenceItem) {
            // validation for constraint: itemType
            if (!$assign_Position_Organization_Event_DataTypeProgram_Assignments_ReferenceItem instanceof \StructType\ProgramObjectType) {
                $invalidValues[] = is_object($assign_Position_Organization_Event_DataTypeProgram_Assignments_ReferenceItem) ? get_class($assign_Position_Organization_Event_DataTypeProgram_Assignments_ReferenceItem) : sprintf('%s(%s)', gettype($assign_Position_Organization_Event_DataTypeProgram_Assignments_ReferenceItem), var_export($assign_Position_Organization_Event_DataTypeProgram_Assignments_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Program_Assignments_Reference property can only contain items of type \StructType\ProgramObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Program_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\ProgramObjectType[] $program_Assignments_Reference
     * @return \StructType\Assign_Position_Organization_Event_DataType
     */
    public function setProgram_Assignments_Reference(array $program_Assignments_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($program_Assignments_ReferenceArrayErrorMessage = self::validateProgram_Assignments_ReferenceForArrayConstraintsFromSetProgram_Assignments_Reference($program_Assignments_Reference))) {
            throw new \InvalidArgumentException($program_Assignments_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Program_Assignments_Reference = $program_Assignments_Reference;
        return $this;
    }
    /**
     * Add item to Program_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\ProgramObjectType $item
     * @return \StructType\Assign_Position_Organization_Event_DataType
     */
    public function addToProgram_Assignments_Reference(\StructType\ProgramObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProgramObjectType) {
            throw new \InvalidArgumentException(sprintf('The Program_Assignments_Reference property can only contain items of type \StructType\ProgramObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Program_Assignments_Reference[] = $item;
        return $this;
    }
    /**
     * Get Business_Unit_Assignments_Reference value
     * @return \StructType\Business_UnitObjectType[]|null
     */
    public function getBusiness_Unit_Assignments_Reference()
    {
        return $this->Business_Unit_Assignments_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Unit_Assignments_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Unit_Assignments_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Unit_Assignments_ReferenceForArrayConstraintsFromSetBusiness_Unit_Assignments_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $assign_Position_Organization_Event_DataTypeBusiness_Unit_Assignments_ReferenceItem) {
            // validation for constraint: itemType
            if (!$assign_Position_Organization_Event_DataTypeBusiness_Unit_Assignments_ReferenceItem instanceof \StructType\Business_UnitObjectType) {
                $invalidValues[] = is_object($assign_Position_Organization_Event_DataTypeBusiness_Unit_Assignments_ReferenceItem) ? get_class($assign_Position_Organization_Event_DataTypeBusiness_Unit_Assignments_ReferenceItem) : sprintf('%s(%s)', gettype($assign_Position_Organization_Event_DataTypeBusiness_Unit_Assignments_ReferenceItem), var_export($assign_Position_Organization_Event_DataTypeBusiness_Unit_Assignments_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Unit_Assignments_Reference property can only contain items of type \StructType\Business_UnitObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Unit_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_UnitObjectType[] $business_Unit_Assignments_Reference
     * @return \StructType\Assign_Position_Organization_Event_DataType
     */
    public function setBusiness_Unit_Assignments_Reference(array $business_Unit_Assignments_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Unit_Assignments_ReferenceArrayErrorMessage = self::validateBusiness_Unit_Assignments_ReferenceForArrayConstraintsFromSetBusiness_Unit_Assignments_Reference($business_Unit_Assignments_Reference))) {
            throw new \InvalidArgumentException($business_Unit_Assignments_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Business_Unit_Assignments_Reference = $business_Unit_Assignments_Reference;
        return $this;
    }
    /**
     * Add item to Business_Unit_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_UnitObjectType $item
     * @return \StructType\Assign_Position_Organization_Event_DataType
     */
    public function addToBusiness_Unit_Assignments_Reference(\StructType\Business_UnitObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_UnitObjectType) {
            throw new \InvalidArgumentException(sprintf('The Business_Unit_Assignments_Reference property can only contain items of type \StructType\Business_UnitObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Unit_Assignments_Reference[] = $item;
        return $this;
    }
    /**
     * Get Gift_Assignments_Reference value
     * @return \StructType\GiftObjectType[]|null
     */
    public function getGift_Assignments_Reference()
    {
        return $this->Gift_Assignments_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setGift_Assignments_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGift_Assignments_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGift_Assignments_ReferenceForArrayConstraintsFromSetGift_Assignments_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $assign_Position_Organization_Event_DataTypeGift_Assignments_ReferenceItem) {
            // validation for constraint: itemType
            if (!$assign_Position_Organization_Event_DataTypeGift_Assignments_ReferenceItem instanceof \StructType\GiftObjectType) {
                $invalidValues[] = is_object($assign_Position_Organization_Event_DataTypeGift_Assignments_ReferenceItem) ? get_class($assign_Position_Organization_Event_DataTypeGift_Assignments_ReferenceItem) : sprintf('%s(%s)', gettype($assign_Position_Organization_Event_DataTypeGift_Assignments_ReferenceItem), var_export($assign_Position_Organization_Event_DataTypeGift_Assignments_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Gift_Assignments_Reference property can only contain items of type \StructType\GiftObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Gift_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\GiftObjectType[] $gift_Assignments_Reference
     * @return \StructType\Assign_Position_Organization_Event_DataType
     */
    public function setGift_Assignments_Reference(array $gift_Assignments_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($gift_Assignments_ReferenceArrayErrorMessage = self::validateGift_Assignments_ReferenceForArrayConstraintsFromSetGift_Assignments_Reference($gift_Assignments_Reference))) {
            throw new \InvalidArgumentException($gift_Assignments_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Gift_Assignments_Reference = $gift_Assignments_Reference;
        return $this;
    }
    /**
     * Add item to Gift_Assignments_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\GiftObjectType $item
     * @return \StructType\Assign_Position_Organization_Event_DataType
     */
    public function addToGift_Assignments_Reference(\StructType\GiftObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GiftObjectType) {
            throw new \InvalidArgumentException(sprintf('The Gift_Assignments_Reference property can only contain items of type \StructType\GiftObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Gift_Assignments_Reference[] = $item;
        return $this;
    }
}
