<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Assign_Organization_Roles_Sub_Business_ProcessType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: The Assign Organization Roles Event Data element is required if Automatically Complete is True. | Wrapper to hold the business process configuration and organization role assignment details. For fields that accept worker, worker's
 * position as of specified effective date will be determined when event is submitted, not when it is completed. This means if worker is being assigned a new position and worker is specified, role will be assigned to their existing position and not
 * their new position. Workday recommends you use 'Assign_Roles_Subprocess' instead to reduce the risk of your role assignments being inadvertently reversed due to another role assignment event being processed at the same time or later-dated role
 * assignments.
 * @subpackage Structs
 */
class Assign_Organization_Roles_Sub_Business_ProcessType extends AbstractStructBase
{
    /**
     * The Business_Sub_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element for web services sub business process parameters.
     * - minOccurs: 0
     * @var \StructType\Business_Sub_Process_ParametersType
     */
    public $Business_Sub_Process_Parameters;
    /**
     * The Assign_Organization_Roles_Event_Data
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element for organization role assignment data.
     * - minOccurs: 0
     * @var \StructType\Assign_Organization_Roles_Event_DataType
     */
    public $Assign_Organization_Roles_Event_Data;
    /**
     * Constructor method for Assign_Organization_Roles_Sub_Business_ProcessType
     * @uses Assign_Organization_Roles_Sub_Business_ProcessType::setBusiness_Sub_Process_Parameters()
     * @uses Assign_Organization_Roles_Sub_Business_ProcessType::setAssign_Organization_Roles_Event_Data()
     * @param \StructType\Business_Sub_Process_ParametersType $business_Sub_Process_Parameters
     * @param \StructType\Assign_Organization_Roles_Event_DataType $assign_Organization_Roles_Event_Data
     */
    public function __construct(\StructType\Business_Sub_Process_ParametersType $business_Sub_Process_Parameters = null, \StructType\Assign_Organization_Roles_Event_DataType $assign_Organization_Roles_Event_Data = null)
    {
        $this
            ->setBusiness_Sub_Process_Parameters($business_Sub_Process_Parameters)
            ->setAssign_Organization_Roles_Event_Data($assign_Organization_Roles_Event_Data);
    }
    /**
     * Get Business_Sub_Process_Parameters value
     * @return \StructType\Business_Sub_Process_ParametersType|null
     */
    public function getBusiness_Sub_Process_Parameters()
    {
        return $this->Business_Sub_Process_Parameters;
    }
    /**
     * Set Business_Sub_Process_Parameters value
     * @param \StructType\Business_Sub_Process_ParametersType $business_Sub_Process_Parameters
     * @return \StructType\Assign_Organization_Roles_Sub_Business_ProcessType
     */
    public function setBusiness_Sub_Process_Parameters(\StructType\Business_Sub_Process_ParametersType $business_Sub_Process_Parameters = null)
    {
        $this->Business_Sub_Process_Parameters = $business_Sub_Process_Parameters;
        return $this;
    }
    /**
     * Get Assign_Organization_Roles_Event_Data value
     * @return \StructType\Assign_Organization_Roles_Event_DataType|null
     */
    public function getAssign_Organization_Roles_Event_Data()
    {
        return $this->Assign_Organization_Roles_Event_Data;
    }
    /**
     * Set Assign_Organization_Roles_Event_Data value
     * @param \StructType\Assign_Organization_Roles_Event_DataType $assign_Organization_Roles_Event_Data
     * @return \StructType\Assign_Organization_Roles_Sub_Business_ProcessType
     */
    public function setAssign_Organization_Roles_Event_Data(\StructType\Assign_Organization_Roles_Event_DataType $assign_Organization_Roles_Event_Data = null)
    {
        $this->Assign_Organization_Roles_Event_Data = $assign_Organization_Roles_Event_Data;
        return $this;
    }
}
